<?php

function apiCategorys($locale, $rid){
	$pjCategoryModel = pjCategoryModel::factory()
	->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjCategory' AND t2.locale = '".$locale."' AND t2.field = 'name'", 'left');

	$pjCategoryModel->where('t1.restaurant_id', $rid);

	if (isset($_GET['q']) && !empty($_GET['q']))
	{
		$q = pjObject::escapeString($_GET['q']);
		$pjCategoryModel->where('t2.content LIKE', "%$q%");
	}
	if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
	{
		$pjCategoryModel->where('t1.status', $_GET['status']);
	}

	$column = 'order';
	$direction = 'ASC';
	if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
	{
		$column = $_GET['column'];
		$direction = strtoupper($_GET['direction']);
	}

	$total = $pjCategoryModel->findCount()->getData();
	$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 100;
	$pages = ceil($total / $rowCount);
	$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
	$offset = ((int) $page - 1) * $rowCount;
	if ($page > $pages)
	{
		$page = $pages;
	}

	$data = $pjCategoryModel
	->select('t1.*, t2.content AS name, 
		(SELECT COUNT(TPC.product_id) FROM `'.pjProductCategoryModel::factory()->getTable().'` AS TPC WHERE TPC.category_id=t1.id) AS cnt_products')
	->orderBy("`$column` $direction")
	->limit($rowCount, $offset)
	->findAll()
	->getData();

  foreach($data as $k=>$category){
    $category['product_arr']=getProductByCategory($category['id'], $locale);
    $data[$k]=$category;
  }
	pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
}

function apiProducts($locale, $rid){
	$pjProductModel = pjProductModel::factory()
	->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$locale."' AND t2.field = 'name'", 'left');
	
	$pjProductModel->where('t1.restaurant_id', $rid);
	
	if (isset($_GET['status']) && !empty($_GET['status']))
	{
		$pjProductModel->where('t1.status', $_GET['status']);
	}
	if (isset($_GET['q']) && !empty($_GET['q']))
	{
		$q = pjObject::escapeString($_GET['q']);
		$pjProductModel->where("(t2.content LIKE '%$q%')");
	}
	if (isset($_GET['category_id']) && (int) $_GET['category_id'] > 0)
	{
		$pjProductModel->where("(t1.id IN (SELECT TPC.product_id FROM `".pjProductCategoryModel::factory()->getTable()."` AS TPC WHERE TPC.category_id='".$_GET['category_id']."'))");
	}

	$column = 'is_featured';
	$direction = 'DESC';
	if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
	{
		$column = $_GET['column'];
		$direction = strtoupper($_GET['direction']);
	}

	$total = $pjProductModel->findCount()->getData();
	$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 100;
	$pages = ceil($total / $rowCount);
	$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
	$offset = ((int) $page - 1) * $rowCount;
	if ($page > $pages)
	{
		$page = $pages;
	}
	
	$pjProductPriceModel = pjProductPriceModel::factory();
	$data = $pjProductModel
	->select("t1.*, t2.content AS name")
	->orderBy("$column $direction")
	->limit($rowCount, $offset)
	->findAll()
	->getData();
	foreach($data as $k => $v)
	{
		if($v['set_different_sizes'] == 'T')
		{
			$_arr = $pjProductPriceModel
			->reset()
			->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '".$rid."' AND t2.field = 'price_name'", 'left')
			->select('t1.*, t2.content as price_name')
			->where('product_id', $v['id'])
			->findAll()
			->getData();
			$price_arr = array();
			foreach($_arr as $price)
			{
				//$price_arr[] = $price['price_name'] . ': ' . pjUtil::formatCurrencySign($price['price'], 'USD');
				$price_arr[] = $price['price_name'] . ': ' . $price['price'];
			}
			$v['price'] = join("<br/>", $price_arr);
		}else{
			//$v['price'] = pjUtil::formatCurrencySign($v['price'], 'USD');
			$v['price'] = $v['price'];
		}
		$data[$k] = $v;
	}	
	pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
}

function apiRestaurant($locale, $rid){
	$pjRestaurantModel = pjRestaurantModel::factory()
	->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjRestaurant' AND t2.locale = '".$locale."' AND t2.field = 'name'", 'left');
	$pjRestaurantModel->where('t1.id', $rid);

	$data = $pjRestaurantModel
	->select('t1.*, t2.content AS name')
	->findAll()
	->getData()[0];
	pjAppController::jsonResponse(compact('data'));
}


function apiConfig($locale, $rid){
  $data=array();

  /*USA Epay*/
  $usaEpay=[];
  $usaEpay["URL"]="https://sandbox.usaepay.com/api/v2/paymentengine/payrequests";
  $usaEpay["APIKEY"]="_f1O2NG6i8D0L14k21WkajL9XcxN1JG1";
  $usaEpay["Authorization"]="Basic X2YxTzJORzZpOEQwTDE0azIxV2thakw5WGN4TjFKRzE6czIvMC43NDczMTE5NzY1MTQ1MjI5L2FkZDMyODBjOTFkNTA3ZDNiZmRiOGQyNTIzNGZiZjZiYTFhNThiYjBhZDJkOTJhOWI4OGVhNjViOGJjZDVkNGM=";
  $usaEpay["devicekey"]="sa_EdZHKnz0EItD7NvdvhntSLdY2AsqS";
  $usaEpay["command"]="sale";
  $usaEpay["timeout"]="120";
  $usaEpay["prompt_tip"]="false";

  /*SMS*/
  $sms=[];
  $sms["URL"]="https://rest.clicksend.com/v3/sms/send";
  $sms["From"]="caffexo.com";
  $sms["Authorization"]="Basic Y3UuYm9uZEBnbWFpbC5jb206QzYwMUUzRUItNDNDMi04NDI4LTY4M0EtRTQwRDFFNEY4MkVC";

  /*Welcome*/
  $welcome=[];
  $welcome_item1["text"]="text 111";
  $welcome_item1["img"]="https://www999.caffexo.com/files/12345/images/food-slider-1.jpg";

  $welcome_item2["text"]="text 222";
  $welcome_item2["img"]="https://www999.caffexo.com/files/12345/images/food-slider-2.jpg";

  $welcome[]=$welcome_item1;
  $welcome[]=$welcome_item2;

  /*crossAxisCount*/
  $crossAxisCount=4;

  /*items*/
  $items=[];

  $pjProductModel = pjProductModel::factory()->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$locale."' AND t2.field = 'name'", 'left');
  $pjProductModel->where('t1.restaurant_id', $rid);
  $column = 'is_featured';
  $direction = 'DESC';

  $pjProductPriceModel = pjProductPriceModel::factory();
  $products = $pjProductModel
    ->select("t1.*, t2.content AS name")
    ->orderBy("$column $direction")
    ->findAll()
    ->getData();
  foreach($products as $k => $v) {
    if($v['set_different_sizes'] == 'T')
    {
      $_arr = $pjProductPriceModel
        ->reset()
        ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '".$rid."' AND t2.field = 'price_name'", 'left')
        ->select('t1.*, t2.content as price_name')
        ->where('product_id', $v['id'])
        ->findAll()
        ->getData();
      $price_arr = array();
      foreach($_arr as $price)
      {
        $price_arr[] = $price['price_name'] . ': ' . $price['price'];
      }
      $v['price'] = join("<br/>", $price_arr);
    }else{
      $v['price'] = $v['price'];
    }
    $products[$k] = $v;

    $item["crossAxisCellCount"]=2;
    $item["mainAxisCellCount"]=2;
    $item["id"]=$v["id"];
    $item["name"]=$v["name"];
    $item["price"]=(float)$v["price"];
    $item["img"]="https://www999.caffexo.com/".$v["image"];

    $items[]=$item;
  }

  /*build data*/

  $data['USAePay']=$usaEpay;
  $data['welcome']=$welcome;
  $data['crossAxisCount']=$crossAxisCount;
  $data['items']=$items;

  pjAppController::jsonResponse($data);
}


function getProductByCategory($categoryId, $localeId){

  if(isset($categoryId))
  {
    $pjProductModel = pjProductModel::factory();
    $arr = $pjProductModel
      ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$localeId."' AND t2.field = 'name'", 'left')
      ->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjProduct' AND t3.locale = '".$localeId."' AND t3.field = 'description'", 'left')
      ->join('pjProductCategory', 't4.product_id=t1.id', 'left outer')
      ->select("t1.*, t2.content AS name, t3.content AS description, t4.category_id")
      ->where('t4.category_id', $categoryId)
      ->where('t1.status', 'T')
      ->orderBy("t1.is_featured DESC, t2.content ASC")
      ->findAll()
      ->getData();

    $pjExtraModel = pjExtraModel::factory();
    $pjProductExtraTable = pjProductExtraModel::factory()->getTable();
    $pjProductPriceModel = pjProductPriceModel::factory();
    $pjProductGroupModel = pjProductGroupModel::factory();
    $pjProductGroupItemModel = pjProductGroupItemModel::factory();
    $pjProductModifierModel = pjProductModifierModel::factory();

    $group_arr = $group_item_arr = array();
    $price_arr = array();
    $extra_arr = array();
    $product_id_arr = $pjProductModel->findAll()->getDataPair(null, 'id');
    if(!empty($product_id_arr))
    {
      $temp_extra_arr = $pjExtraModel
        ->reset()
        ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjExtra' AND t2.locale = '".$localeId."' AND t2.field = 'name'", 'left')
        ->join('pjProductExtra', "t3.extra_id = t1.id", 'left')
        ->where("(t1.id IN (SELECT TPE.extra_id FROM `".$pjProductExtraTable."` AS TPE WHERE TPE.product_id IN(".join(",", $product_id_arr).") ))")
        ->select("t1.*, t2.content AS name, t3.product_id")
        ->orderBy("name ASC")
        ->findAll()
        ->getData();
      foreach($temp_extra_arr as $k => $v)
      {
        $extra_arr[$v['product_id']][] = $v;
      }
      $temp_price_arr = $pjProductPriceModel
        ->reset()
        ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '".$localeId."' AND t2.field = 'price_name'", 'left')
        ->whereIn('t1.product_id', $product_id_arr)
        ->select("t1.*, t2.content AS price_name")
        ->findAll()
        ->getData();
      foreach($temp_price_arr as $k => $v)
      {
        $price_arr[$v['product_id']][] = $v;
      }

      $_group_arr = $pjProductGroupModel->select('t1.*, t2.content AS group_name')
        ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroup' AND t2.locale = '".$localeId."' AND t2.field = 'group_name'", 'left')
        ->whereIn('t1.product_id', $product_id_arr)
        ->orderBy('t2.content ASC')
        ->findAll()
        ->getData();
      $group_ids_arr = array();
      foreach ($_group_arr as $item) {
        $group_arr[$item['product_id']][] = $item;
        $group_ids_arr[] = $item['id'];

      }
      if ($group_ids_arr) {
        $_group_item_arr = $pjProductGroupItemModel->select('t1.*, t2.content AS group_item_name')
          ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroupItem' AND t2.locale = '".$localeId."' AND t2.field = 'group_item_name'", 'left')
          ->whereIn('t1.group_id', $group_ids_arr)
          ->orderBy('t2.content ASC')
          ->findAll()
          ->getData();
        foreach ($_group_item_arr as $item) {
          $group_item_arr[$item['group_id']][] = $item;
        }
      }

      $modifier_arr = $modifier_item_arr = array();
      $_modifier_arr = $pjProductModifierModel->select('t1.*, t2.content AS modifier_name')
        ->join('pjMultiLang', "t2.foreign_id = t1.modifier_id AND t2.model = 'pjModifier' AND t2.locale = '".$localeId."' AND t2.field = 'name'", 'left')
        ->whereIn('t1.product_id', $product_id_arr)
        ->orderBy('t2.content ASC')
        ->findAll()
        ->getData();
      $modifier_ids_arr = array();
      foreach ($_modifier_arr as $item) {
        $item['id']=$item['modifier_id'];
        unset($item['modifier_id']);

        $modifier_arr[$item['product_id']][] = $item;
        $modifier_ids_arr[] = $item['id'];
      }
      if ($modifier_ids_arr) {
        $_modifier_item_arr = pjModifierItemModel::factory()->select('t1.*, t2.content AS modifier_item_name')
          ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjModifierItem' AND t2.locale = '".$localeId."' AND t2.field = 'item_name'", 'left')
          ->whereIn('t1.modifier_id', $modifier_ids_arr)
          ->orderBy('t2.content ASC')
          ->findAll()
          ->getData();
        foreach ($_modifier_item_arr as $item) {
          $modifier_item_arr[$item['modifier_id']][] = $item;
        }
      }
    }

    /*Custom group_arr*/
    foreach($group_arr as $k => $group){
      foreach($group as $i => $group_item){
        $group_item['group_item_arr'] =  array();
        if(isset($group_item_arr[$group_item['id']])) {
          $group_item['group_item_arr'] = $group_item_arr[$group_item['id']];
        }
        $group[$i]=$group_item;
      }
      $group_arr[$k]=$group;
    }

    /*Custom modifier*/
    foreach($modifier_arr as $k => $modifier){
      foreach($modifier as $i => $modifier_item){
        $modifier_item['modifier_item_arr'] =  array();
        if(isset($modifier_item_arr[$modifier_item['id']])) {
          $modifier_item['modifier_item_arr'] = $modifier_item_arr[$modifier_item['id']];
        }
        $modifier[$i]=$modifier_item;
      }
      $modifier_arr[$k]=$modifier;
    }

    foreach($arr as $k => $product)
    {
      $product['price_arr'] = array();
      $product['extra_arr'] = array();
      $product['group_arr'] = array();
      $product['modifier_arr'] = array();

      if(isset($extra_arr[$product['id']]))
      {
        $product['extra_arr'] = $extra_arr[$product['id']];
      }
      if($product['set_different_sizes'] == 'T' && isset($price_arr[$product['id']]))
      {
        $product['price_arr'] = $price_arr[$product['id']];
      }
      if(isset($group_arr[$product['id']])){
        $product['group_arr'] = $group_arr[$product['id']];
      }
      if(isset($modifier_arr[$product['id']])){
        $product['modifier_arr'] = $modifier_arr[$product['id']];
      }
      $arr[$k] = $product;
    }

//    $this->set('arr', $arr);
//    $this->set('group_arr', $group_arr);
//    $this->set('group_item_arr', $group_item_arr);
//    $this->set('modifier_arr', $modifier_arr);
//    $this->set('modifier_item_arr', $modifier_item_arr);

//    $data['arr']=$arr;
//    $data['group_arr']=$group_arr;
//    $data['group_item_arr']=$group_item_arr;
//    $data['modifier_arr']=$modifier_arr;
//    $data['modifier_item_arr']=$modifier_item_arr;

    //pjAppController::jsonResponse($arr);

    return $arr;
  }
}
