<?php
if (isset($tpl['status'])) {
  $status = __('status', true);
  switch ($tpl['status']) {
    case 2:
      pjUtil::printNotice(NULL, $status[2]);
      break;
  }
  exit;
}

include_once("tabs.php");
pjUtil::printNotice("Custom Products", "Custom Pre-name (multi-languages) and Printers for Kitchen, ... for each products");

?>

<div class="align_middle" style="margin-bottom: 5px;">
  <label>- Category:</label>
  <select id="change-category" class="pj-form-field w200">
    <option value="0">-- All --</option>
    <?php foreach($tpl['categories'] as $key=>$category) { ?>
      <option value="<?php echo $category['id']; ?>" <?php echo (isset($_GET['categoryId']) && $_GET['categoryId']==$category['id'])?'selected':'';  ?>><?php echo pjSanitize::html($category['name']); ?></option>
    <?php } ?>
  </select>
  <label id="quickly-printers" style="line-height: 30px;">
    - Quickly Printers:
    <a href="javascript:void(0)" onclick="checkAllPrinter(true);" style="color: green;">Check All</a>
    <?php if(count($tpl['printers'])>1) { ?>
      :<?php foreach($tpl['printers'] as $k=>$printer) { ?>
        <a href="javascript:void(0)" style="margin-right: 3px;" onclick="checkAllPrinterById('<?php echo $printer['id']; ?>', true);"><?php echo $printer['pre_name']; ?></a>
      <?php } ?>
    <?php } ?>
    <span>/</span>
    <a href="javascript:void(0)" onclick="checkAllPrinter(false);" style="color: darkred;">Uncheck All</a>
  </label>
</div>

<script>
  $('#change-category').change(function() {
    window.location = "index.php?controller=pjKiosk&action=pjActionCustomProducts&categoryId=" + $(this).val();
  });
</script>

<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjKiosk&amp;action=pjActionCustomProducts&categoryId=<?php echo $tpl['categoryId']; ?>" method="post" class="form pj-form">
  <input type="hidden" name="update" value="1"/>
  <table class="pj-table" style="width: 100%; margin-bottom: 12px;" cellspacing="0" cellpadding="0">
    <thead>
      <tr style="font-weight: bold;">
        <td>ID</td>
        <td>Title/Image</td>
        <td style="width: 210px;">Pre-name (multi-languages)</td>
        <td style="width: 150px;">Printers in Kitchen</td>
        <td style="width: 30px;">Action</td>
      </tr>
    </thead>
    <tbody>
    <?php foreach($tpl['products'] as $key=>$product) { ?>
      <tr>
        <td>
          <input type="hidden"name="product_ids[<?php echo $product['id']; ?>]" value="<?php echo $product['id']; ?>">
          <?php echo $product['id']; ?>
        </td>
        <td>
          <div><?php echo $product['name']; ?></div>
          <div><img src="<?php echo $product['image']; ?>" width="100px;"></div>
        </td>
        <td><textarea class="pj-form-field w200" rows="6" name="pre_names[<?php echo $product['id']; ?>]"><?php echo $product['pre_name']; ?></textarea></td>
        <td class="select-printers">
          <?php foreach($tpl['printers'] as $k=>$printer) { ?>
          <label style="display: flex; cursor: pointer; margin-bottom: 5px;"><input type="checkbox" class="radio" location="<?php echo $printer['location'];?>" printer_id="<?php echo $printer['id'];?>" value="1" name="printers_id[<?php echo $product['id']; ?>][<?php echo $printer['id']; ?>]"  <?php echo (in_array($printer['id'], $product['printers']))?'checked':''; ?> />&nbsp;<?php echo $printer['pre_name']; ?></label>
          <?php } ?>
          <a onclick="checkAll(this, true)" style="text-decoration: underline; color: green; cursor: pointer;">Check All</a> / <a style="text-decoration: underline; color: darkred; cursor: pointer;" onclick="checkAll(this, false)">Uncheck All</a>
        </td>
        <td><a href="index.php?controller=pjAdminProducts&action=pjActionUpdate&id=<?php echo $product['id']; ?>" target="_blank">Edit</a></td>
      </tr>
    <?php } ?>
    </tbody>
  </table>

  <script>
    function checkAll(me, value){
      $(me).parent().find("input").prop("checked", value);
    }

    function checkAllPrinter(value){
      $(".select-printers").find("input").prop("checked", value);
    }

    function checkAllPrinterByLocation(location, value){
      $(".select-printers").find("input[location="+location+"]").prop("checked", value);
    }

    function checkAllPrinterById(id, value){
      $(".select-printers").find("input[printer_id="+id+"]").prop("checked", value);
    }
  </script>
  <span class="inline_block">
    <input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
    <input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjKiosk&action=pjActionKioskIndex';" />
  </span>
</form>
