<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
require  PJ_INSTALL_PATH.'vendor/autoload.php';
class pjAdminOrders extends pjAdmin
{
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor() || $this->isManager())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminOrders.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetOrder()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjOrderModel = pjOrderModel::factory()
				->join('pjClient', "t2.id=t1.client_id", 'left outer');
				
			$pjOrderModel->where('t1.restaurant_id', $this->getForeignId());
			if(!isset($_GET['all']))
			{
			    $pjOrderModel->where('t1.is_paid', 1);
			}
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjOrderModel->where("(t1.id = '$q' OR t1.uuid = '$q' OR t2.c_name LIKE '%$q%' OR t2.c_email LIKE '%$q%')");
			}
			
			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('confirmed','cancelled','pending')))
			{
				$pjOrderModel->where('t1.status', $_GET['status']);
			}
			if (isset($_GET['client_id']) && (int) $_GET['client_id'] > 0)
			{
				$pjOrderModel->where('t1.client_id', $_GET['client_id']);
			}
			if (isset($_GET['type']) && !empty($_GET['type']))
			{
				$pjOrderModel->where('t1.type', $_GET['type']);
			}	
			$column = 'created';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjOrderModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = array();
			$delivery_statuses = __('delivery_statuses', true);
			$data = $pjOrderModel
				->select("t1.*, t2.c_name as client_name, 
							AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
							AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
							AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
							AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			foreach($data as $k => $v)
			{
				$data[$k]['delivery_status'] = '';
				$data[$k]['total'] = pjUtil::formatCurrencySign($v['total'], $this->option_arr['o_currency']);
				if($v['type'] == 'delivery')
				{
					if($v['d_asap'] == 'F')
					{
						$data[$k]['datetime'] = pjUtil::formatDate(date("Y-m-d", strtotime($v['d_dt'])), "Y-m-d", $this->option_arr['o_date_format']) . ', ' . pjUtil::formatTime(date("H:i:s", strtotime($v['d_dt'])), "H:i:s", $this->option_arr['o_time_format']);
					}else{
						$data[$k]['datetime'] = pjUtil::formatDate(date("Y-m-d", strtotime($v['d_dt'])), "Y-m-d", $this->option_arr['o_date_format']) . ', ' . __('lblAsap', true);
					}
					$data[$k]['delivery_status'] = @$delivery_statuses[$v['delivery_status']];
				}else if($v['type'] == 'pickup'){
					if($v['p_asap'] == 'F')
					{
						$data[$k]['datetime'] = pjUtil::formatDate(date("Y-m-d", strtotime($v['p_dt'])), "Y-m-d", $this->option_arr['o_date_format']) . ', ' . pjUtil::formatTime(date("H:i:s", strtotime($v['p_dt'])), "H:i:s", $this->option_arr['o_time_format']);
					}else{
						$data[$k]['datetime'] = pjUtil::formatDate(date("Y-m-d", strtotime($v['p_dt'])), "Y-m-d", $this->option_arr['o_date_format'])  . ', ' . __('lblAsap', true);
					}
				} else {
					if($v['ca_asap'] == 'F')
					{
						$data[$k]['datetime'] = pjUtil::formatDate(date("Y-m-d", strtotime($v['ca_dt'])), "Y-m-d", $this->option_arr['o_date_format']) . ', ' . pjUtil::formatTime(date("H:i:s", strtotime($v['ca_dt'])), "H:i:s", $this->option_arr['o_time_format']);
					}else{
						$data[$k]['datetime'] = pjUtil::formatDate(date("Y-m-d", strtotime($v['ca_dt'])), "Y-m-d", $this->option_arr['o_date_format']) . ', ' . __('lblAsap', true);
					}
				}
			}
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionSaveOrder()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			pjOrderModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
		}
		exit;
	}
	
	public function pjActionExportOrder()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjOrderModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Orders-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionDeleteOrder()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjOrderModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjOrderItemModel::factory()->where('order_id', $_GET['id'])->eraseAll();
				pjOrderDeliveryStatusModel::factory()->where('order_id', $_GET['id'])->eraseAll();
				
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteOrderBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjOrderModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				pjOrderItemModel::factory()->whereIn('order_id', $_POST['record'])->eraseAll();
				pjOrderDeliveryStatusModel::factory()->whereIn('order_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor() || $this->isManager())
		{
			if (isset($_POST['order_create']))
			{
				$pjOrderModel = pjOrderModel::factory();
				
				$data = array();
				$data['uuid'] = time();
				$data['ip'] = pjUtil::getClientIp();
				
				if(!isset($_POST['client_id']) || (isset($_POST['client_id']) && $_POST['client_id'] == ''))
				{
					$c_data = array();
					$c_data['c_title'] = isset($_POST['c_title']) ? $_POST['c_title'] : ':NULL';
					$c_data['c_name'] = isset($_POST['c_name']) ? $_POST['c_name'] : ':NULL';
					$c_data['c_email'] = isset($_POST['c_email']) ? $_POST['c_email'] : ':NULL';
					$c_data['c_password'] = pjUtil::getRandomPassword(6);
					$c_data['c_phone'] = isset($_POST['c_phone']) ? $_POST['c_phone'] : ':NULL';
					$c_data['c_address_1'] = isset($_POST['c_address_1']) ? $_POST['c_address_1'] : ':NULL';
					$c_data['c_address_2'] = isset($_POST['c_address_2']) ? $_POST['c_address_2'] : ':NULL';
					$c_data['c_city'] = isset($_POST['c_city']) ? $_POST['c_city'] : ':NULL';
					$c_data['c_state'] = isset($_POST['c_state']) ? $_POST['c_state'] : ':NULL';
					$c_data['c_zip'] = isset($_POST['c_zip']) ? $_POST['c_zip'] : ':NULL';
					$c_data['c_country'] = isset($_POST['c_country']) ? $_POST['c_country'] : ':NULL';
					$c_data['status'] = 'T';
					
					if($c_data['c_email'] != ':NULL')
					{
						$pjClientModel = pjClientModel::factory();
						$client_id = $pjClientModel->setAttributes($c_data)->insert()->getInsertId();
						if ($client_id !== false && (int) $client_id > 0)
						{
							$data['client_id'] = $client_id;
							
							$client_arr = $pjClientModel->reset()->find($client_id)->getData();
							$tokens = pjAppController::getClientTokens($this->option_arr, $client_arr, PJ_SALT, $this->getLocaleId());
							
							$pjMultiLangModel = pjMultiLangModel::factory();
							$lang_message = $pjMultiLangModel
								->reset()
								->select('t1.*')
								->where('t1.model','pjOption')
								->where('t1.locale', $this->getLocaleId())
								->where('t1.field', 'o_email_account_message')
								->limit(0, 1)
								->findAll()
								->getData();
							$lang_subject = $pjMultiLangModel
								->reset()
								->select('t1.*')
								->where('t1.model','pjOption')
								->where('t1.locale', $this->getLocaleId())
								->where('t1.field', 'o_email_account_subject')
								->limit(0, 1)
								->findAll()
								->getData();
								
							if (count($lang_message) === 1 && count($lang_subject) === 1)
							{
								$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
								
								$Email = new pjEmail();
								if ($this->option_arr['o_send_email'] == 'smtp')
								{
									$Email
										->setTransport('smtp')
										->setSmtpHost($this->option_arr['o_smtp_host'])
										->setSmtpPort($this->option_arr['o_smtp_port'])
										->setSmtpUser($this->option_arr['o_smtp_user'])
										->setSmtpPass($this->option_arr['o_smtp_pass'])
									;
								}
								$Email->setContentType('text/html');
								$Email
									->setTo($c_data['c_email'])
									->setFrom($this->getAdminEmail())
									->setSubject($lang_subject[0]['content'])
									->send(pjUtil::textToHtml($message));
							}
						}
					}
				}
				
				switch ($_POST['type'])
				{
					case 'pickup':
						if (!empty($_POST['p_dt']))
						{
							$date_time = $_POST['p_dt'];
							if(count(explode(" ", $date_time)) == 3)
							{
								list($_date, $_time, $_period) = explode(" ", $date_time);
								$time = pjUtil::formatTime($_time . ' ' . $_period, $this->option_arr['o_time_format']);
							}else{
								list($_date, $_time) = explode(" ", $date_time);
								$time = pjUtil::formatTime($_time, $this->option_arr['o_time_format']);
							}
							unset($_POST['p_dt']);
							unset($_POST['d_dt']);
							unset($_POST['ca_dt']);
							$data['p_dt'] = pjUtil::formatDate($_date, $this->option_arr['o_date_format']) . ' ' . $time;
						}
						if (isset($_POST['p_location_id']) && (int) $_POST['p_location_id'] > 0)
						{
							$data['location_id'] = $_POST['p_location_id'];
						}
						break;
					case 'delivery':
						if (!empty($_POST['d_dt']))
						{
							$date_time = $_POST['d_dt'];
							if(count(explode(" ", $date_time)) == 3)
							{
								list($_date, $_time, $_period) = explode(" ", $date_time);
								$time = pjUtil::formatTime($_time . ' ' . $_period, $this->option_arr['o_time_format']);
							}else{
								list($_date, $_time) = explode(" ", $date_time);
								$time = pjUtil::formatTime($_time, $this->option_arr['o_time_format']);
							}
							unset($_POST['p_dt']);
							unset($_POST['d_dt']);
							unset($_POST['ca_dt']);
							$data['d_dt'] = pjUtil::formatDate($_date, $this->option_arr['o_date_format']) . ' ' . $time;
						}
						if (isset($_POST['d_location_id']) && (int) $_POST['d_location_id'] > 0)
						{
							$data['location_id'] = $_POST['d_location_id'];
						}
						break;
					case 'catering':
						if (!empty($_POST['ca_dt']))
						{
							$date_time = $_POST['ca_dt'];
							if(count(explode(" ", $date_time)) == 3)
							{
								list($_date, $_time, $_period) = explode(" ", $date_time);
								$time = pjUtil::formatTime($_time . ' ' . $_period, $this->option_arr['o_time_format']);
							}else{
								list($_date, $_time) = explode(" ", $date_time);
								$time = pjUtil::formatTime($_time, $this->option_arr['o_time_format']);
							}
							unset($_POST['p_dt']);
							unset($_POST['d_dt']);
							unset($_POST['ca_dt']);
							$data['ca_dt'] = pjUtil::formatDate($_date, $this->option_arr['o_date_format']) . ' ' . $time;
						}
						if (isset($_POST['ca_location_id']) && (int) $_POST['ca_location_id'] > 0)
						{
							$data['location_id'] = $_POST['ca_location_id'];
						}
						break;
				}
				if ($_POST['payment_method'] == 'creditcard')
				{
					$data['cc_exp'] = $_POST['cc_exp_month'] . "/" . $_POST['cc_exp_year'];
				}
				
				$data['restaurant_id'] = $this->getForeignId();
				if ($_POST['tip_option'] == 0) {
					$data['tip_percentage'] = 0;
					$data['tip_amount'] = 0;
				} elseif ($_POST['tip_option'] == 2) {
					$data['tip_percentage'] = 0;
				}
				$data = array_merge($_POST, $data);
				if ($data['type'] != 'delivery' || $this->option_arr['o_allow_delivery_doordash'] == 'No') {
					$data['external_delivery_id'] = '';
				}
				if (!empty($data['external_delivery_id'])) {
					$data['is_dashdoor_delivery'] = 1;
				}
				$data['receive_sms_messages'] = isset($_POST['receive_sms_messages']) ? 1 : 0;
				$id = pjOrderModel::factory($data)->insert()->getInsertId();
				
				if ($id !== false && (int) $id > 0)
				{
					if ($data['type'] == 'delivery' && $this->option_arr['o_allow_delivery_doordash'] == 'Yes' && !empty($data['external_delivery_id']) && $data['status'] == 'confirmed') {
						$delivery_status_arr = pjAppController::doordashAcceptDeliveryQuote($data['external_delivery_id'], $this->option_arr);
						$data_update = array(
							'is_dashdoor_delivery' => 1,
							'dasher_name' => @$delivery_status_arr['dasher_name'],
							'dasher_dropoff_phone_number' => @$delivery_status_arr['dasher_dropoff_phone_number'],
							'dasher_pickup_phone_number' => @$delivery_status_arr['dasher_pickup_phone_number'],
							'dasher_vehicle_make' => @$delivery_status_arr['dasher_vehicle_make'],
							'dasher_vehicle_model' => @$delivery_status_arr['dasher_vehicle_model'],
							'dasher_vehicle_year' => @$delivery_status_arr['dasher_vehicle_year']
						);
						pjOrderModel::factory()->reset()->set('id', $id)->modify($data_update);
					}
					if (isset($_POST['product_id']) && count($_POST['product_id']) > 0)
					{
						$pjOrderItemModel = pjOrderItemModel::factory();
						$pjProductPriceModel = pjProductPriceModel::factory();
						$pjProductModel = pjProductModel::factory();
						$pjExtraModel = pjExtraModel::factory();
						
						foreach ($_POST['product_id'] as $k => $pid)
						{
							$product = $pjProductModel
								->reset()
								->find($pid)
								->getData();
							if (strpos($k, 'new_') === 0)
							{
								$price = 0;
								$price_id = ":NULL";
								
								if($product['set_different_sizes'] == 'T')
								{
									$price_id = $_POST['price_id'][$k];
									$price_arr = $pjProductPriceModel
										->reset()
										->find($price_id)
										->getData();
									if($price_arr)
									{
										$price = $price_arr['price'];
									}
								}else{
									$price = $product['price'];
								}
								
								$hash = md5(uniqid(rand(), true));
								$oid = $pjOrderItemModel
									->reset()
									->setAttributes(array(
										'order_id' => $id,
										'foreign_id' => $pid,
										'type' => 'product',
										'hash' => $hash,
										'price_id' => $price_id,
										'price' => $price,
										'cnt' => $_POST['cnt'][$k]
									))
									->insert()
									->getInsertId();
								if ($oid !== false && (int) $oid > 0)
								{
									if (isset($_POST['extra_id']) && isset($_POST['extra_id'][$k]))
									{
										foreach ($_POST['extra_id'][$k] as $i => $eid)
										{
											$extra_price = 0;
											$extra_arr = $pjExtraModel
												->reset()
												->find($eid)
												->getData();
											if(!empty($extra_arr) && !empty($extra_arr['price']))
											{
												$extra_price = $extra_arr['price'];
											}
											$pjOrderItemModel
												->reset()
												->setAttributes(array(
													'order_id' => $id,
													'foreign_id' => $eid,
													'type' => 'extra',
													'hash' => $hash,
													'price_id' => ':NULL',
													'price' => $extra_price,
													'cnt' => $_POST['extra_cnt'][$k][$i]
												))
												->insert();
										}
									}
									
									if (isset($_POST['group_item_id']) && isset($_POST['group_item_id'][$k]))
									{
										foreach ($_POST['group_item_id'][$k] as $group_id => $group_item_id)
										{
											$pjOrderItemModel
													->reset()
													->setAttributes(array(
														'order_id' => $id,
														'foreign_id' => $group_item_id,
														'type' => 'group',
														'hash' => $hash,
														'price_id' => ':NULL',
														'price' => ':NULL',
														'cnt' => 1
													))
													->insert();
										}
									}
									
									if (isset($_POST['modifier_item_id']) && isset($_POST['modifier_item_id'][$k]))
									{
										foreach ($_POST['modifier_item_id'][$k] as $i => $mid)
										{
											$item_price = 0;
											$item_arr = pjModifierItemModel::factory()
												->reset()
												->find($mid)
												->getData();
											if(!empty($item_arr) && !empty($item_arr['price']))
											{
												$item_price = $item_arr['price'];
											}
											$pjOrderItemModel
												->reset()
												->setAttributes(array(
													'order_id' => $id,
													'foreign_id' => $mid,
													'type' => 'modifier_item',
													'hash' => $hash,
													'price_id' => ':NULL',
													'price' => $item_price,
													'cnt' => 1
												))
												->insert();
										}
									}
								}
							}
						}
					}
					
					$err = 'AR03';
				}else{
					$err = 'AR04';
				}
				
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminOrders&action=pjActionIndex&err=$err");
			}else{
				
				$country_arr = pjCountryModel::factory()
							->select('t1.id, t2.content AS country_title')
							->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
							->orderBy('`country_title` ASC')->findAll()->getData();
						
				$this->set('country_arr', $country_arr);
				
				$product_arr = pjProductModel::factory()
					->select("t1.*, t2.content AS name, (SELECT COUNT(*) FROM `".pjProductExtraModel::factory()->getTable()."` AS TPE WHERE TPE.product_id=t1.id) as cnt_extras")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where('t1.restaurant_id', $this->getForeignId())
					->where('t1.status', 'T')
					->orderBy("name ASC")
					->findAll()
					->getData();
				$this->set('product_arr', $product_arr);
				
				$location_arr = pjLocationModel::factory()
					->select("t1.*, t2.content AS name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjLocation' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where('t1.restaurant_id', $this->getForeignId())
					->orderBy("name ASC")
					->findAll()
					->getData();
				$this->set('location_arr', $location_arr);
				
				$client_arr = pjClientModel::factory()
					->where('t1.status', 'T')
					->orderBy('t1.c_name ASC')
					->findAll()
					->getData();
				$this->set('client_arr', $client_arr);

				$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendJs('jquery-ui-sliderAccess.js', PJ_THIRD_PARTY_PATH . 'datetimepicker/');
				$this->appendJs('jquery-ui-timepicker-addon.js', PJ_THIRD_PARTY_PATH . 'datetimepicker/');
				$this->appendCss('jquery-ui-timepicker-addon.css', PJ_THIRD_PARTY_PATH . 'datetimepicker/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminOrders.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor() || $this->isManager())
		{
			if (isset($_POST['order_update']))
			{
				$pjOrderModel = pjOrderModel::factory();
				$pjOrderItemModel = pjOrderItemModel::factory();
				$pjProductPriceModel = pjProductPriceModel::factory();
				$pjExtraModel = pjExtraModel::factory();
				$pjProductModel = pjProductModel::factory();
				
				$arr = $pjOrderModel->find($_POST['id'])->getData();
				if (empty($arr))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminOrders&action=pjActionIndex&err=AR08");
				}
				if (isset($_POST['product_id']) && count($_POST['product_id']) > 0)
				{
					$keys = array_keys($_POST['product_id']);
					$pjOrderItemModel
						->reset()
						->where('order_id', $_POST['id'])
						->whereNotIn('hash', $keys)
						->eraseAll();
						
					$pjOrderItemModel
						->reset()
						->where('order_id', $_POST['id'])
						->where('type', 'extra')
						->eraseAll();

					$pjOrderItemModel
						->reset()
						->where('order_id', $_POST['id'])
						->where('type', 'group')
						->eraseAll();
						
					$pjOrderItemModel
						->reset()
						->where('order_id', $_POST['id'])
						->where('type', 'modifier_item')
						->eraseAll();
						
					foreach ($_POST['product_id'] as $k => $pid)
					{
						$product = $pjProductModel
							->reset()
							->find($pid)
							->getData();
						$price = 0;
						$price_id = ":NULL";
						
						if($product['set_different_sizes'] == 'T')
						{
							$price_id = $_POST['price_id'][$k];
							$price_arr = $pjProductPriceModel
								->reset()
								->find($price_id)
								->getData();
							if($price_arr)
							{
								$price = $price_arr['price'];
							}
						}else{
							$price = $product['price'];
						}
						if (strpos($k, 'new_') === 0)
						{
							$hash = md5(uniqid(rand(), true));
							$oid = $pjOrderItemModel
								->reset()
								->setAttributes(array(
									'order_id' => $_POST['id'],
									'foreign_id' => $pid,
									'type' => 'product',
									'hash' => $hash,
									'price_id' => $price_id,
									'price' => $price,
									'cnt' => $_POST['cnt'][$k]
								))
								->insert()
								->getInsertId();
								
							if ($oid !== false && (int) $oid > 0)
							{
								if (isset($_POST['extra_id']) && isset($_POST['extra_id'][$k]))
								{
									foreach ($_POST['extra_id'][$k] as $i => $eid)
									{
										$extra_price = 0;
										$extra_arr = $pjExtraModel
											->reset()
											->find($eid)
											->getData();
										if(!empty($extra_arr) && !empty($extra_arr['price']))
										{
											$extra_price = $extra_arr['price'];
										}
										$pjOrderItemModel
											->reset()
											->setAttributes(array(
												'order_id' => $_POST['id'],
												'foreign_id' => $eid,
												'type' => 'extra',
												'hash' => $hash,
												'price_id' => ':NULL',
												'price' => $extra_price,
												'cnt' => $_POST['extra_cnt'][$k][$i]
											))
											->insert();
									}
								}
								
								if (isset($_POST['group_item_id']) && isset($_POST['group_item_id'][$k]))
								{
									foreach ($_POST['group_item_id'][$k] as $group_id => $group_item_id)
									{
										$pjOrderItemModel
												->reset()
												->setAttributes(array(
													'order_id' => $_POST['id'],
													'foreign_id' => $group_item_id,
													'type' => 'group',
													'hash' => $hash,
													'price_id' => ':NULL',
													'price' => ':NULL',
													'cnt' => 1
												))
												->insert();
									}
								}
								
								if (isset($_POST['modifier_item_id']) && isset($_POST['modifier_item_id'][$k]))
								{
									foreach ($_POST['modifier_item_id'][$k] as $i => $mid)
									{
										$item_price = 0;
										$item_arr = pjModifierItemModel::factory()
											->reset()
											->find($mid)
											->getData();
										if(!empty($item_arr) && !empty($item_arr['price']))
										{
											$item_price = $item_arr['price'];
										}
										$pjOrderItemModel
											->reset()
											->setAttributes(array(
												'order_id' => $_POST['id'],
												'foreign_id' => $mid,
												'type' => 'modifier_item',
												'hash' => $hash,
												'price_id' => ':NULL',
												'price' => $item_price,
												'cnt' => 1
											))
											->insert();
									}
								}
							}
						
						} else {
							$pjOrderItemModel
								->reset()
								->where('hash', $k)
								->where('type', 'product')
								->limit(1)
								->modifyAll(array(
									'foreign_id' => $pid,
									'cnt' => $_POST['cnt'][$k],
									'price_id' => $price_id,
									'price' => $price,
								));
							if (isset($_POST['extra_id']) && isset($_POST['extra_id'][$k]))
							{
								foreach ($_POST['extra_id'][$k] as $i => $eid)
								{
									$extra_price = 0;
									$extra_arr = $pjExtraModel
										->reset()
										->find($eid)
										->getData();
									if(!empty($extra_arr) && !empty($extra_arr['price']))
									{
										$extra_price = $extra_arr['price'];
									}
									
									$pjOrderItemModel
										->reset()
										->setAttributes(array(
											'order_id' => $_POST['id'],
											'foreign_id' => $eid,
											'type' => 'extra',
											'hash' => $k,
											'price_id' => ':NULL',
											'price' => $extra_price,
											'cnt' => $_POST['extra_cnt'][$k][$i]
										))
										->insert();
									
								}
							}

							if (isset($_POST['group_item_id']) && isset($_POST['group_item_id'][$k]))
							{
								foreach ($_POST['group_item_id'][$k] as $group_id => $group_item_id)
								{
									$pjOrderItemModel
											->reset()
											->setAttributes(array(
												'order_id' => $_POST['id'],
												'foreign_id' => $group_item_id,
												'type' => 'group',
												'hash' => $k,
												'price_id' => ':NULL',
												'price' => ':NULL',
												'cnt' => 1
											))
											->insert();
								}
							}
							
							if (isset($_POST['modifier_item_id']) && isset($_POST['modifier_item_id'][$k]))
							{
								foreach ($_POST['modifier_item_id'][$k] as $i => $mid)
								{
									$item_price = 0;
									$item_arr = pjModifierItemModel::factory()
										->reset()
										->find($mid)
										->getData();
									if(!empty($item_arr) && !empty($item_arr['price']))
									{
										$item_price = $item_arr['price'];
									}
									
									$pjOrderItemModel
										->reset()
										->setAttributes(array(
											'order_id' => $_POST['id'],
											'foreign_id' => $mid,
											'type' => 'modifier_item',
											'hash' => $k,
											'price_id' => ':NULL',
											'price' => $item_price,
											'cnt' => 1
										))
										->insert();
									
								}
							}
						}
					}
				} 
								
				$data = array();
				$data['ip'] = pjUtil::getClientIp();
				switch ($_POST['type'])
				{
					case 'pickup':
						if (!empty($_POST['p_dt']))
						{
							$date_time = $_POST['p_dt'];
							if(count(explode(" ", $date_time)) == 3)
							{
								list($_date, $_time, $_period) = explode(" ", $date_time);
								$time = pjUtil::formatTime($_time . ' ' . $_period, $this->option_arr['o_time_format']);
							}else{
								list($_date, $_time) = explode(" ", $date_time);
								$time = pjUtil::formatTime($_time, $this->option_arr['o_time_format']);
							}
							unset($_POST['p_dt']);
							unset($_POST['d_dt']);
							unset($_POST['ca_dt']);
							$data['p_dt'] = pjUtil::formatDate($_date, $this->option_arr['o_date_format']) . ' ' . $time;
						}
						if (isset($_POST['p_location_id']) && (int) $_POST['p_location_id'] > 0)
						{
							$data['location_id'] = $_POST['p_location_id'];
						}
						break;
					case 'delivery':
						if (!empty($_POST['d_dt']))
						{
							$date_time = $_POST['d_dt'];
							if(count(explode(" ", $date_time)) == 3)
							{
								list($_date, $_time, $_period) = explode(" ", $date_time);
								$time = pjUtil::formatTime($_time . ' ' . $_period, $this->option_arr['o_time_format']);
							}else{
								list($_date, $_time) = explode(" ", $date_time);
								$time = pjUtil::formatTime($_time, $this->option_arr['o_time_format']);
							}
							unset($_POST['p_dt']);
							unset($_POST['d_dt']);
							unset($_POST['ca_dt']);
							$data['d_dt'] = pjUtil::formatDate($_date, $this->option_arr['o_date_format']) . ' ' . $time;
						}
						if (isset($_POST['d_location_id']) && (int) $_POST['d_location_id'] > 0)
						{
							$data['location_id'] = $_POST['d_location_id'];
						}
						break;
					case 'catering':
						if (!empty($_POST['ca_dt']))
						{
							$date_time = $_POST['ca_dt'];
							if(count(explode(" ", $date_time)) == 3)
							{
								list($_date, $_time, $_period) = explode(" ", $date_time);
								$time = pjUtil::formatTime($_time . ' ' . $_period, $this->option_arr['o_time_format']);
							}else{
								list($_date, $_time) = explode(" ", $date_time);
								$time = pjUtil::formatTime($_time, $this->option_arr['o_time_format']);
							}
							unset($_POST['p_dt']);
							unset($_POST['d_dt']);
							unset($_POST['ca_dt']);
							$data['ca_dt'] = pjUtil::formatDate($_date, $this->option_arr['o_date_format']) . ' ' . $time;
						}
						if (isset($_POST['ca_location_id']) && (int) $_POST['ca_location_id'] > 0)
						{
							$data['location_id'] = $_POST['ca_location_id'];
						}
						break;
				}
				if ($_POST['payment_method'] == 'creditcard')
				{
					$data['cc_exp'] = $_POST['cc_exp_month'] . "/" . $_POST['cc_exp_year'];
				}
				if ($_POST['tip_option'] == 0) {
					$data['tip_percentage'] = 0;
					$data['tip_amount'] = 0;
				} elseif ($_POST['tip_option'] == 2) {
					$data['tip_percentage'] = 0;
				}
				$data['receive_sms_messages'] = isset($_POST['receive_sms_messages']) ? 1 : 0;
				$data = array_merge($_POST, $data);
				if ($arr['type'] == 'delivery' && $data['type'] != 'delivery') {
					$data['external_delivery_id'] = '';
				} else if ($this->option_arr['o_allow_delivery_doordash'] == 'Yes' && $data['type'] == 'delivery' && ($arr['external_delivery_id'] != $data['external_delivery_id'] || ($arr['status'] != 'confirmed' && $data['status'] == 'confirmed')) && !empty($data['external_delivery_id'])) {
					$restaurant_arr = pjRestaurantModel::factory()->select('t1.*, t2.content AS name')
						->join('pjMultiLang', "t2.model='pjRestaurant' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
						->find($this->getForeignId())
						->getData();
					$client_arr = pjClientModel::factory()->find($_POST['client_id'])->getData();
					$dropoff_address_arr = array();
					if (isset($_POST['d_address_1']) && !empty($_POST['d_address_1'])) {
						$dropoff_address_arr[] = $_POST['d_address_1'];
					}
					if (isset($_POST['d_address_2']) && !empty($_POST['d_address_2'])) {
						$dropoff_address_arr[] = $_POST['d_address_2'];
					}
					if (isset($_POST['d_city']) && !empty($_POST['d_city'])) {
						$dropoff_address_arr[] = $_POST['d_city'];
					}
					if (isset($_POST['d_state']) && !empty($_POST['d_state'])) {
						$dropoff_address_arr[] = $_POST['d_state'];
					}
					if (isset($_POST['d_zip']) && !empty($_POST['d_zip'])) {
						$dropoff_address_arr[] = $_POST['d_zip'];
					}
					$data_delivery = array(
						"pickup_address"=> $restaurant_arr['address'],
						"pickup_business_name"=> $restaurant_arr['name'],
						"pickup_phone_number"=> $restaurant_arr['phone'],
						"dropoff_address"=> implode(', ', $dropoff_address_arr),
					    "dropoff_business_name"=> $client_arr ? $client_arr['c_name'] : '',
						"dropoff_phone_number"=> $client_arr ? $client_arr['c_phone'] : '',
						"dropoff_instructions"=> @$_POST['d_notes'],
					    "order_value"=> ((float)$_POST['total'] - (float)$_POST['price_delivery']) * 100,
					    "tip"=> (float)$_POST['dasher_tip_amount'] * 100,
					);
					$delivery_arr = pjAppController::doordashCreateDelivery($data_delivery, $this->option_arr);
					if (isset($delivery_arr['external_delivery_id'])) {
						$data['is_dashdoor_delivery'] = 1;
						$data['external_delivery_id'] = $delivery_arr['external_delivery_id'];
						$data['dasher_name'] = @$delivery_arr['dasher_name'];
						$data['dasher_dropoff_phone_number'] = @$delivery_arr['dasher_dropoff_phone_number'];
						$data['dasher_pickup_phone_number'] = @$delivery_arr['dasher_pickup_phone_number'];
						$data['dasher_vehicle_make'] = @$delivery_arr['dasher_vehicle_make'];
						$data['dasher_vehicle_model'] = @$delivery_arr['dasher_vehicle_model'];
						$data['dasher_vehicle_year'] = @$delivery_arr['dasher_vehicle_year'];
					}
				}
				$pjOrderModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll($data);
				
				$err = 'AR01';
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminOrders&action=pjActionIndex&err=$err");
			}else{
				
				$arr = pjOrderModel::factory()
					->join('pjClient', "t2.id=t1.client_id", 'left outer')
					->select("t1.*,t2.c_name as client_name, t2.c_title, t2.c_email, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip,t2.c_notes,
							AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
							AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
							AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
							AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
					->find($_GET['id'])
					->getData();

				if(count($arr) <= 0 || ($arr && $arr['restaurant_id'] != $this->getForeignId()))
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminOrders&action=pjActionIndex&err=AR08");
				}
				$this->set('arr', $arr);
				
				$country_arr = pjCountryModel::factory()
					->select('t1.id, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('`country_title` ASC')
					->findAll()
					->getData();
						
				$this->set('country_arr', $country_arr);
				
				$product_arr = pjProductModel::factory()
					->select("t1.*, t2.content AS name, 
								(SELECT GROUP_CONCAT(extra_id SEPARATOR '~:~') FROM `".pjProductExtraModel::factory()->getTable()."` WHERE product_id = t1.id GROUP BY product_id LIMIT 1) AS allowed_extras,
								(SELECT COUNT(*) FROM `".pjProductExtraModel::factory()->getTable()."` AS TPE WHERE TPE.product_id=t1.id) as cnt_extras")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where('t1.restaurant_id', $this->getForeignId())
					->orderBy("name ASC")
					->findAll()
					->toArray('allowed_extras', '~:~')
					->getData();
				$this->set('product_arr', $product_arr);
				$product_ids_arr = array();
				foreach ($product_arr as $prod) {
					$product_ids_arr[] = $prod['id'];
				}
				
				$location_arr = pjLocationModel::factory()
					->select("t1.*, t2.content AS name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjLocation' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where('t1.restaurant_id', $this->getForeignId())
					->orderBy("name ASC")
					->findAll()
					->getData();
				$this->set('location_arr', $location_arr);
				
				$extra_arr = pjExtraModel::factory()
					->select("t1.*, t2.content AS name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjExtra' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where('t1.restaurant_id', $this->getForeignId())
					->orderBy("name ASC")
					->findAll()
					->getData();
				$this->set('extra_arr', $extra_arr);
				
				$pjProductPriceModel = pjProductPriceModel::factory();
				$oi_arr = array();
				$_oi_arr = pjOrderItemModel::factory()
					->where('t1.order_id', $arr['id'])
					->findAll()
					->getData();
				foreach ($_oi_arr as $item)
				{
					if($item['type'] == 'product')
					{
						$item['price_arr'] = $pjProductPriceModel
							->reset()
							->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'price_name'", 'left')
							->select("t1.*, t2.content AS price_name")
							->where('product_id', $item['foreign_id'])
							->findAll()
							->getData();
					}
					$oi_arr[] = $item;
				}
				$this->set('oi_arr', $oi_arr);
				
				$client_arr = pjClientModel::factory()
					->where('t1.status', 'T')
					->orderBy('t1.c_name ASC')
					->findAll()
					->getData();
				$this->set('client_arr', $client_arr);
				
				$pjProductGroupModel = pjProductGroupModel::factory();
				$pjProductGroupItemModel = pjProductGroupItemModel::factory();
				$group_arr = $group_item_arr = array();
				$modifier_arr = $modifier_item_arr = array();
				if(!empty($product_ids_arr))
				{
					$_group_arr = $pjProductGroupModel->select('t1.*, t2.content AS group_name')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroup' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'group_name'", 'left')
						->whereIn('t1.product_id', $product_ids_arr)
						->orderBy('t2.content ASC')
						->findAll()
						->getData();
					$group_ids_arr = array();		
					foreach ($_group_arr as $item) {
						$group_arr[$item['product_id']][] = $item;
						$group_ids_arr[] = $item['id'];
					}		
					if ($group_ids_arr) {
						$_group_item_arr = $pjProductGroupItemModel->select('t1.*, t2.content AS group_item_name')
							->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroupItem' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'group_item_name'", 'left')
							->whereIn('t1.group_id', $group_ids_arr)
							->orderBy('t2.content ASC')
							->findAll()
							->getData();
						foreach ($_group_item_arr as $item) {
							$group_item_arr[$item['group_id']][] = $item;
						}
					}
					
					$_modifier_arr = pjProductModifierModel::factory()->select('t1.*, t2.content AS modifier_name')
						->join('pjMultiLang', "t2.foreign_id = t1.modifier_id AND t2.model = 'pjModifier' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
						->whereIn('t1.product_id', $product_ids_arr)
						->orderBy('t2.content ASC')
						->findAll()
						->getData();
					$modifier_ids_arr = array();		
					foreach ($_modifier_arr as $item) {
						$modifier_arr[$item['product_id']][] = $item;
						$modifier_ids_arr[] = $item['modifier_id'];
					}		
					if ($modifier_ids_arr) {
						$_modifier_item_arr = pjModifierItemModel::factory()->select('t1.*, t2.content AS modifier_item_name')
							->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjModifierItem' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'item_name'", 'left')
							->whereIn('t1.modifier_id', $modifier_ids_arr)
							->orderBy('t2.content ASC')
							->findAll()
							->getData();
						foreach ($_modifier_item_arr as $item) {
							$modifier_item_arr[$item['modifier_id']][] = $item;
						}
					}
				}
				$this->set('group_arr', $group_arr);
				$this->set('group_item_arr', $group_item_arr);
				$this->set('modifier_arr', $modifier_arr);
				$this->set('modifier_item_arr', $modifier_item_arr);
				
				$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
				$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendJs('jquery-ui-sliderAccess.js', PJ_THIRD_PARTY_PATH . 'datetimepicker/');
				$this->appendJs('jquery-ui-timepicker-addon.js', PJ_THIRD_PARTY_PATH . 'datetimepicker/');
				$this->appendCss('jquery-ui-timepicker-addon.css', PJ_THIRD_PARTY_PATH . 'datetimepicker/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.noty.packaged.min.js', PJ_THIRD_PARTY_PATH . 'noty/packaged/');
				$this->appendJs('pjAdminOrders.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionPrintOrder()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor() || $this->isManager())
		{
			$this->setLayout('pjActionPrint');
			$this->_pjActionPrintOrder('o_print_order');
			
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionPrintOrderNormal()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor() || $this->isManager())
		{
			$this->setLayout('pjActionPrintNormal');
			$this->_pjActionPrintOrder('o_print_order_normal');
			
		} else {
			$this->set('status', 2);
		}
	}
	
	private function _pjActionPrintOrder($print_template) {
		
		$pjOrderModel = pjOrderModel::factory();
							
		$arr = $pjOrderModel
			->join('pjClient', "t2.id=t1.client_id", 'left outer')
			->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
					AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
					AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
					AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
					AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
			->find($_GET['id'])
			->getData();
		if (empty($arr) || ($arr && $arr['restaurant_id'] != $this->getForeignId()))
		{
			pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminOrders&action=pjActionIndex&err=AR08");
		}

		$hash = sha1($arr['id'].$arr['created'].PJ_SALT);
		if($hash != $_GET['hash'])
		{
			pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminOrders&action=pjActionIndex&err=AR08");
		}

		pjAppController::addOrderDetails($arr, $this->getLocaleId());

		$pjMultiLangModel = pjMultiLangModel::factory();
		$lang_template = $pjMultiLangModel
			->reset()->select('t1.*')
			->where('t1.foreign_id', $this->getForeignId())
			->where('t1.model','pjOption')
			->where('t1.locale', $this->getLocaleId())
			->where('t1.field', $print_template)
			->limit(0, 1)
			->findAll()->getData();
		$template = '';											 
		if (count($lang_template) === 1)
		{
			$template = $lang_template[0]['content'];
		}									 

		if ($arr['type'] == 'delivery')
		{
			$template = str_replace(array('[Delivery]', '[/Delivery]'), array('', ''), $template);
			$template = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $template);
		} elseif ($arr['type'] == 'catering') {
			$template = str_replace(array('[Catering]', '[/Catering]'), array('', ''), $template);
			$template = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $template);
		} else {
			$template = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $template);
			$template = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $template);
		}

		$template_arr = '';
		$data = pjAppController::getTokens($this->option_arr, $arr, PJ_SALT, $this->getLocaleId());
                $template_arr = str_replace($data['search'], $data['replace'], $template);
		$this->set('template_arr', $template_arr);
			
	}
	
	public function pjActionReminderEmail()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() && $this->isLoged())
		{
			if (isset($_POST['send_email']) && isset($_POST['to']) && !empty($_POST['to']) && !empty($_POST['from']) &&
				!empty($_POST['subject']) && !empty($_POST['message']) && !empty($_POST['id']))
			{
				$Email = new pjEmail();
				$Email->setContentType('text/html');
				if ($this->option_arr['o_send_email'] == 'smtp')
				{
					$Email
						->setTransport('smtp')
						->setSmtpHost($this->option_arr['o_smtp_host'])
						->setSmtpPort($this->option_arr['o_smtp_port'])
						->setSmtpUser($this->option_arr['o_smtp_user'])
						->setSmtpPass($this->option_arr['o_smtp_pass']);
				}
				$r = $Email
					->setTo($_POST['to'])
					->setFrom($_POST['from'])
					->setSubject($_POST['subject'])
					->send($_POST['message']);
					
				if (isset($r) && $r)
				{
					pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => __('lblEmailSent', true, false)));
				}
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => __('lblFailedToSend', true, false)));
			}
			
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjOrderModel = pjOrderModel::factory();
								
				$arr = $pjOrderModel
					->join('pjClient', "t2.id=t1.client_id", 'left outer')
					->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
							AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
							AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
							AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
							AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
					->find($_GET['id'])
					->getData();
						
				if (!empty($arr))
				{
					pjAppController::addOrderDetails($arr, $this->getLocaleId());
					
					$tokens = pjAppController::getTokens($this->option_arr, $arr, PJ_SALT, $this->getLocaleId());
					
					$pjMultiLangModel = pjMultiLangModel::factory();
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.foreign_id', $this->getForeignId())
						->where('t1.model','pjOption')
						->where('t1.locale', $this->getLocaleId())
						->where('t1.field', 'o_email_confirmation_message')
						->limit(0, 1)
						->findAll()
						->getData();
					$lang_subject = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.foreign_id', $this->getForeignId())
						->where('t1.model','pjOption')
						->where('t1.locale', $this->getLocaleId())
						->where('t1.field', 'o_email_confirmation_subject')
						->limit(0, 1)
						->findAll()
						->getData();
								   
					if (count($lang_message) === 1 && count($lang_subject) === 1)
					{
						if ($arr['type'] == 'delivery')
						{
							$message = str_replace(array('[Delivery]', '[/Delivery]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						} elseif ($arr['type'] == 'catering') {
							$message = str_replace(array('[Catering]', '[/Catering]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $message);
						} else {
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						}
						
						$subject_client = str_replace($tokens['search'], $tokens['replace'], $lang_subject[0]['content']);
						$message_client = str_replace($tokens['search'], $tokens['replace'], $message);
						$from = !empty($this->option_arr['o_sender_email']) ? $this->option_arr['o_sender_email'] : $this->getAdminEmail();
						$this->set('arr', array(
							'id' => $_GET['id'],
							'client_email' => $arr['c_email'],
							'from' => $from,
							'message' => $message_client,
							'subject' => $subject_client
						));
					}
				}else{
					exit;
				}
			} else {
				exit;
			}
		}
	}
	
	public function pjActionGetExtras()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['product_id']) && (int) $_GET['product_id'] > 0)
			{
				$extra_arr = pjExtraModel::factory()
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjExtra' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->select("t1.*, t2.content AS name")
					->where("t1.id IN (SELECT TPE.extra_id FROM `".pjProductExtraModel::factory()->getTable()."` AS TPE WHERE TPE.product_id=".$_GET['product_id'].")")
					->orderBy("name ASC")
					->findAll()
					->getData();
				$this->set('extra_arr', $extra_arr);
			}
		}
	}
	public function pjActionGetPrices()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['product_id']) && (int) $_GET['product_id'] > 0)
			{
				$arr = pjProductModel::factory()
					->find($_GET['product_id'])
					->getData();
				if (!empty($arr))
				{
					if($arr['set_different_sizes'] == 'T')
					{
						$price_arr = pjProductPriceModel::factory()
							->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'price_name'", 'left')
							->select("t1.*, t2.content AS price_name")
							->where("product_id", $_GET['product_id'])
							->orderBy("price_name ASC")
							->findAll()
							->getData();
						$this->set('price_arr', $price_arr);
					}
				}
				$this->set('arr', $arr);
			}
		}
	}
	
	public function pjActionGetTotal()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$is_null = true;
			foreach($_POST['product_id'] as $k => $v)
			{
				if( (int) $v > 0 )
				{
					$is_null = false;
				}
			}
			if($is_null == false)
			{
				$price = 0;
				$subtotal = 0;
				$delivery = 0;
				$tax = 0;
				$total = 0;
				$external_delivery_id = '';
				
				$pjProductModel = pjProductModel::factory();
				$pjProductPriceModel = pjProductPriceModel::factory();
				$pjExtraModel = pjExtraModel::factory();
				 
				$product_arr = $pjProductModel
					->whereIn("t1.id", $_POST['product_id'])
					->findAll()
					->getData();
				$extra_arr = $pjExtraModel
					->where('t1.restaurant_id', $this->getForeignId())
					->findAll()
					->getData();
					
				$modifier_item_arr = pjModifierItemModel::factory()
					->join('pjModifier', 't2.id=t1.modifier_id', 'inner')
					->where('t2.restaurant_id', $this->getForeignId())
					->findAll()
					->getDataPair('id', NULL);
					
				foreach ($_POST['product_id'] as $hash => $product_id)
				{
					foreach ($product_arr as $product)
					{
						if ($product['id'] == $product_id)
						{
							$_price = 0;
							$extra_price = 0;
							$modifier_item_price = 0;
							
							if($product['set_different_sizes'] == 'T')
							{
								$price_arr = $pjProductPriceModel
									->reset()
									->find($_POST['price_id'][$hash])
									->getData();
								if($price_arr)
								{
									$_price = $price_arr['price'];
								}
							}else{
								$_price = $product['price'];
							}
							
							$product_price = $_price * $_POST['cnt'][$hash];
							if (isset($_POST['extra_id']) && isset($_POST['extra_id'][$hash]))
							{
								foreach ($_POST['extra_id'][$hash] as $oi_id => $extra_id)
								{
									if (isset($_POST['extra_cnt'][$hash][$oi_id]) && (int) $_POST['extra_cnt'][$hash][$oi_id] > 0)
									{
										foreach ($extra_arr as $extra)
										{
											if ($extra['id'] == $extra_id)
											{
												$extra_price += $extra['price'] * $_POST['extra_cnt'][$hash][$oi_id];
												break;
											}
										}
									}
								}
							}
							
							if (isset($_POST['modifier_item_id']) && isset($_POST['modifier_item_id'][$hash]))
							{
								foreach ($_POST['modifier_item_id'][$hash] as $m_id)
								{
									if (isset($modifier_item_arr[$m_id]) && (float)$modifier_item_arr[$m_id]['price'] > 0) {
										$modifier_item_price += (float)$modifier_item_arr[$m_id]['price'];
									}
								}
							}
							$_price = $product_price + $extra_price + $modifier_item_price;
							$price += $_price;
							break;
						}
					}
				}
								
				$p_arr = $this->calcPriceWithoutDeliveryFee($_POST);
				$dasher_tip_amount = $p_arr['dasher_tip_amount'];
				if ($_POST['type'] == 'delivery' && isset($_POST['d_location_id']) && (int) $_POST['d_location_id'] > 0)
				{
					$client_arr = pjClientModel::factory()->find($_POST['client_id'])->getData();
					if ($this->option_arr['o_allow_delivery_doordash'] == 'Yes') {
						if (!empty($_POST['external_delivery_id'])) {
							$delivery = (float)$_POST['price_delivery'];
							$$external_delivery_id = $_POST['external_delivery_id'];
						} else {
							$restaurant_arr = pjRestaurantModel::factory()->select('t1.*, t2.content AS name')
								->join('pjMultiLang', "t2.model='pjRestaurant' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
								->find($this->getForeignId())
								->getData();
							$dropoff_address_arr = array();
							if (isset($_POST['d_address_1']) && !empty($_POST['d_address_1'])) {
								$dropoff_address_arr[] = $_POST['d_address_1'];
							}
							if (isset($_POST['d_address_2']) && !empty($_POST['d_address_2'])) {
								$dropoff_address_arr[] = $_POST['d_address_2'];
							}
							if (isset($_POST['d_city']) && !empty($_POST['d_city'])) {
								$dropoff_address_arr[] = $_POST['d_city'];
							}
							if (isset($_POST['d_state']) && !empty($_POST['d_state'])) {
								$dropoff_address_arr[] = $_POST['d_state'];
							}
							if (isset($_POST['d_zip']) && !empty($_POST['d_zip'])) {
								$dropoff_address_arr[] = $_POST['d_zip'];
							}
							$data_delivery = array(
								"external_delivery_id"=> $_POST['external_delivery_id'],
								"pickup_address"=> $restaurant_arr['address'],
								"pickup_business_name"=> $restaurant_arr['name'],
								"pickup_phone_number"=> $restaurant_arr['phone'],
								"dropoff_address"=> implode(', ', $dropoff_address_arr),
							    "dropoff_business_name"=> $client_arr ? $client_arr['c_name'] : '',
								"dropoff_phone_number"=> $client_arr ? $client_arr['c_phone'] : '',
								"dropoff_instructions"=> @$_POST['d_notes'],
							    "order_value"=> (float)$p_arr['price'] * 100,
							    "tip"=> (float)$dasher_tip_amount * 100
							);
							$delivery_arr = pjAppController::doordashDeliveryQuote($data_delivery, $this->option_arr);
							if (isset($delivery_arr['external_delivery_id'])) {
								$external_delivery_id = $delivery_arr['external_delivery_id'];
								$delivery = (float)$delivery_arr['fee'] > 0 ? ((float)$delivery_arr['fee'] / 100) : 0;
							}
						}
					} else {
						$arr = pjPriceModel::factory()
							->where("t1.location_id", $_POST['d_location_id'])
							->where("(t1.total_from <= $price)")
							->where("(t1.total_to >= $price)")
							->findAll()
							->limit(1)
							->getData();
							
						if (count($arr) === 1)
						{
							$delivery = $arr[0]['price'];
						}
					}
				}
	
				$discount = 0;
				if (!empty($_POST['voucher_code']))
				{
					$_POST['restaurant_id'] = $this->getForeignId();
					$resp = pjAppController::getDiscount($_POST, $this->option_arr);
					if ($resp['code'] == 200)
					{
						$voucher_discount = $resp['voucher_discount'];
						switch ($resp['voucher_type'])
						{
							case 'percent':
								$discount = (($price + $delivery) * $voucher_discount) / 100;
								break;
							case 'amount':
								$discount = $voucher_discount;
								break;
						}
					}
				}
				if($discount > ($price + $delivery))
				{
					$discount = $price + $delivery;
				}
				$subtotal = $price + $delivery - $discount;
				if($this->option_arr['o_add_tax'] == '1')
				{
					if($discount > $price)
					{
						$discount = $price;
					}
					$subtotal = $price - $discount;
				}
				
				if(!empty($this->option_arr['o_tax_payment']))
				{
					$tax = ($subtotal * $this->option_arr['o_tax_payment']) / 100;
				}

				$service_fee = $catering_fee = 0;
				if($this->option_arr['o_allow_service_fee'] == 'Yes' && (float) $this->option_arr['o_service_fee'] > 0)
				{
					$service_fee = $this->option_arr['o_service_fee'];
				}
				
				if ($_POST['type'] == 'catering') {                                        
                    if ($subtotal >= (float) $this->option_arr['o_catering_total']) {
                        $catering_fee = (float) $this->option_arr['o_catering_fee_percent'] * $subtotal / 100;
                    }
                    else {
                    	$catering_fee = (float) $this->option_arr['o_catering_fee'];
                    }
				}
				
				$total = $subtotal + $tax + $service_fee + $catering_fee;
				if($this->option_arr['o_add_tax'] == '1')
				{
					$total = $subtotal + $tax + $delivery + $service_fee + $catering_fee;
				}
				
				$tip_amount = $tip_percentage = 0;
				if ($_POST['tip_option'] == 1) {
					$tip_amount = ($total * $_POST['tip_percentage']) / 100;
				} elseif ($_POST['tip_option'] == 2) {
					$tip_amount = $_POST['tip_amount'];
				}
				$total += $tip_amount;
				
				$price = number_format($price, 2);
				$discount = number_format($discount, 2);
				$delivery = number_format($delivery, 2);
				$subtotal = number_format($subtotal, 2);
				$tax = number_format($tax, 2);
				$service_fee = number_format($service_fee, 2);
				$catering_fee = number_format($catering_fee, 2);
				$total = number_format($total, 2);
				$tip_amount = number_format($tip_amount, 2);
				$dasher_tip_amount = number_format($dasher_tip_amount, 2);
				pjAppController::jsonResponse(compact('price', 'discount', 'delivery', 'subtotal', 'tax', 'service_fee', 'total', 'catering_fee', 'tip_amount', 'dasher_tip_amount', 'external_delivery_id'));
			}else{
				pjAppController::jsonResponse(array('price' => 'NULL'));
			}
		}
		exit;
	}
	
	public function pjActionGetClient()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$client_arr = pjClientModel::factory()->find($_GET['id'])->getData();
			pjAppController::jsonResponse($client_arr);
		}
		exit;
	}
	
	public function pjActionCheckPickup()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_POST['type']) || empty($_POST['type']) || empty($_POST['p_location_id']))
			{
				echo 'true';
				exit;
			}
			if ($_POST['type'] != 'pickup')
			{
				echo 'true';
				exit;
			}
			$date_time = $_POST['p_dt'];
			if(count(explode(" ", $date_time)) == 3)
			{
				list($_date, $_time, $_period) = explode(" ", $date_time);
				$time = pjUtil::formatTime($_time . ' ' . $_period, $this->option_arr['o_time_format']);
			}else{
				list($_date, $_time) = explode(" ", $date_time);
				$time = pjUtil::formatTime($_time, $this->option_arr['o_time_format']);
			}
			$date = pjUtil::formatDate($_date, $this->option_arr['o_date_format']);
			$wt_arr = pjAppController::getWorkingTime($date, $_POST['p_location_id'], $_POST['type']);
			if($wt_arr == false)
			{
				echo 'false';
				exit;
			}
			$ts = strtotime($date . ' ' . $time);
			$start_ts = strtotime($date . ' ' . $wt_arr['start_hour'] . ':' . $wt_arr['start_minutes'] . ':00');
			$end_ts = strtotime($date . ' ' . $wt_arr['end_hour'] . ':' . $wt_arr['end_minutes'] . ':00');
			
			if($end_ts <= $start_ts)
			{
				$end_ts += 86400;
			}
			
			if($ts >= $start_ts && $ts <= $end_ts)
			{
				$location_wt_arr = pjAppController::getLocationWT($date, $_POST['p_location_id'], $_POST['type']);
				$is_lunch_break = false;
				if (isset($location_wt_arr['break_time']) && count($location_wt_arr['break_time']) > 0) {
					foreach ($location_wt_arr['break_time'] as $bt) {
						if ($ts >= $bt['lunch_break_from_ts'] && $ts < $bt['lunch_break_to_ts']) {
							$is_lunch_break = true;
							continue;	
						}
					}
				}
				if ($is_lunch_break) {
					echo 'false';
					exit;
				} else {
					echo 'true';
				}
			}else{
				if($ts < $start_ts)
				{
					$date = date('Y-m-d', ($ts - 86400));
					$wt_arr = pjAppController::getWorkingTime($date, $_POST['p_location_id'], $_POST['type']);
					if($wt_arr == false)
					{
						echo 'false';
						exit;
					}
					$start_ts = strtotime($date . ' ' . $wt_arr['start_hour'] . ':' . $wt_arr['start_minutes'] . ':00');
					$end_ts = strtotime($date . ' ' . $wt_arr['end_hour'] . ':' . $wt_arr['end_minutes'] . ':00');
						
					if($end_ts <= $start_ts)
					{
						$end_ts += 86400;
					}
					if($ts >= $start_ts && $ts <= $end_ts)
					{
						$location_wt_arr = pjAppController::getLocationWT($date, $_POST['p_location_id'], $_POST['type']);
						$is_lunch_break = false;
						if (isset($location_wt_arr['break_time']) && count($location_wt_arr['break_time']) > 0) {
							foreach ($location_wt_arr['break_time'] as $bt) {
								if ($ts >= $bt['lunch_break_from_ts'] && $ts < $bt['lunch_break_to_ts']) {
									$is_lunch_break = true;
									continue;	
								}
							}
						}
						if ($is_lunch_break) {
							echo 'false';
							exit;
						} else {
							echo 'true';
						}
					}else{
						echo 'false';
					}
				}else{
					echo 'false';
				}
			}
		}
		exit;
	}
	
	public function pjActionCheckDelivery()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_POST['type']) || empty($_POST['type']) || empty($_POST['d_location_id']))
			{
				echo 'true';
				exit;
			}
			if ($_POST['type'] != 'delivery')
			{
				echo 'true';
				exit;
			}
			$date_time = $_POST['d_dt'];
			if(count(explode(" ", $date_time)) == 3)
			{
				list($_date, $_time, $_period) = explode(" ", $date_time);
				$time = pjUtil::formatTime($_time . ' ' . $_period, $this->option_arr['o_time_format']);
			}else{
				list($_date, $_time) = explode(" ", $date_time);
				$time = pjUtil::formatTime($_time, $this->option_arr['o_time_format']);
			}
			$date = pjUtil::formatDate($_date, $this->option_arr['o_date_format']);
			$wt_arr = pjAppController::getWorkingTime($date, $_POST['d_location_id'], $_POST['type']);
			
			if($wt_arr == false)
			{
				echo 'false';
				exit;
			}
			$ts = strtotime($date . ' ' . $time);
			$start_ts = strtotime($date . ' ' . $wt_arr['start_hour'] . ':' . $wt_arr['start_minutes'] . ':00');
			$end_ts = strtotime($date . ' ' . $wt_arr['end_hour'] . ':' . $wt_arr['end_minutes'] . ':00');
			
			if($end_ts <= $start_ts)
			{
				$end_ts += 86400;
			}
			
			if($ts >= $start_ts && $ts <= $end_ts)
			{
				$location_wt_arr = pjAppController::getLocationWT($date, $_POST['d_location_id'], $_POST['type']);
				$is_lunch_break = false;
				if (isset($location_wt_arr['break_time']) && count($location_wt_arr['break_time']) > 0) {
					foreach ($location_wt_arr['break_time'] as $bt) {
						if ($ts >= $bt['lunch_break_from_ts'] && $ts < $bt['lunch_break_to_ts']) {
							$is_lunch_break = true;
							continue;	
						}
					}
				}
				if ($is_lunch_break) {
					echo 'false';
					exit;
				} else {
					echo 'true';	
				}
			}else{
				if($ts < $start_ts)
				{
					$date = date('Y-m-d', ($ts - 86400));
					$wt_arr = pjAppController::getWorkingTime($date, $_POST['d_location_id'], $_POST['type']);
					if($wt_arr == false)
					{
						echo 'false';
						exit;
					}
					$start_ts = strtotime($date . ' ' . $wt_arr['start_hour'] . ':' . $wt_arr['start_minutes'] . ':00');
					$end_ts = strtotime($date . ' ' . $wt_arr['end_hour'] . ':' . $wt_arr['end_minutes'] . ':00');
						
					if($end_ts <= $start_ts)
					{
						$end_ts += 86400;
					}
					if($ts >= $start_ts && $ts <= $end_ts)
					{
						$location_wt_arr = pjAppController::getLocationWT($date, $_POST['d_location_id'], $_POST['type']);
						$is_lunch_break = false;
						if (isset($location_wt_arr['break_time']) && count($location_wt_arr['break_time']) > 0) {
							foreach ($location_wt_arr['break_time'] as $bt) {
								if ($ts >= $bt['lunch_break_from_ts'] && $ts < $bt['lunch_break_to_ts']) {
									$is_lunch_break = true;
									continue;	
								}
							}
						}
						if ($is_lunch_break) {
							echo 'false';
							exit;
						} else {
							echo 'true';	
						}
					}else{
						echo 'false';
					}
				}else{
					echo 'false';
				}
			}
		}
		exit;
	}
	
	public function pjActionGetProductGroups()
	{
		$this->setAjax(true);
		if ($this->isXHR())
		{
			if (isset($_GET['product_id']) && (int) $_GET['product_id'] > 0)
			{
				$pjProductGroupModel = pjProductGroupModel::factory();
				$pjProductGroupItemModel = pjProductGroupItemModel::factory();
				$group_arr = $pjProductGroupModel->select('t1.*, t2.content AS group_name')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroup' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'group_name'", 'left')
					->where('t1.product_id', $_GET['product_id'])
					->orderBy('t2.content ASC')
					->findAll()
					->getData();
				$group_item_arr = $group_ids_arr = array();		
				foreach ($group_arr as $item) {
					$group_ids_arr[] = $item['id'];
				}		
				if ($group_ids_arr) {
					$_group_item_arr = $pjProductGroupItemModel->select('t1.*, t2.content AS group_item_name')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroupItem' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'group_item_name'", 'left')
						->whereIn('t1.group_id', $group_ids_arr)
						->orderBy('t2.content ASC')
						->findAll()
						->getData();
					foreach ($_group_item_arr as $item) {
						$group_item_arr[$item['group_id']][] = $item;
					}
				}
				$this->set('group_arr', $group_arr);
				$this->set('group_item_arr', $group_item_arr);
			}
		}
	}
	
	public function pjActionGetProductModifiers()
	{
		$this->setAjax(true);
		if ($this->isXHR())
		{
			if (isset($_GET['product_id']) && (int) $_GET['product_id'] > 0)
			{
				$modifier_arr = $modifier_item_arr = array();
				$_modifier_arr = pjProductModifierModel::factory()->select('t1.*, t2.content AS modifier_name')
					->join('pjMultiLang', "t2.foreign_id = t1.modifier_id AND t2.model = 'pjModifier' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where('t1.product_id', $_GET['product_id'])
					->orderBy('t2.content ASC')
					->findAll()
					->getData();
				$modifier_ids_arr = array();		
				foreach ($_modifier_arr as $item) {
					$modifier_arr[$item['product_id']][] = $item;
					$modifier_ids_arr[] = $item['modifier_id'];
				}		
				if ($modifier_ids_arr) {
					$_modifier_item_arr = pjModifierItemModel::factory()->select('t1.*, t2.content AS modifier_item_name')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjModifierItem' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'item_name'", 'left')
						->whereIn('t1.modifier_id', $modifier_ids_arr)
						->orderBy('t2.content ASC')
						->findAll()
						->getData();
					foreach ($_modifier_item_arr as $item) {
						$modifier_item_arr[$item['modifier_id']][] = $item;
					}
				}
				$this->set('modifier_arr', $modifier_arr);
				$this->set('modifier_item_arr', $modifier_item_arr);
			}
		}
	}
	
	public function pjActionSendToRemotePrinter()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() && $this->isLoged())
		{
			if (isset($_POST['send']) && isset($_POST['id']) && (int)$_POST['id'] > 0) {
				if ($_POST['type'] == 2) {
					$pjOrderModel = pjOrderModel::factory();
					$pjMultiLangModel = pjMultiLangModel::factory();
			
					$order_arr = $pjOrderModel
						->join('pjClient', "t2.id=t1.client_id", 'left outer')
						->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
								AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
								AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
								AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
								AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
						->find($_POST['id'])
						->getData();
					pjAppController::addOrderDetails($order_arr, $this->getLocaleId());
					
					$Email = new pjEmail();
					$option_arr = $this->option_arr;
					if ($option_arr['o_send_email'] == 'smtp')
					{
						$Email
							->setTransport('smtp')
							->setSmtpHost($option_arr['o_smtp_host'])
							->setSmtpPort($option_arr['o_smtp_port'])
							->setSmtpUser($option_arr['o_smtp_user'])
							->setSmtpPass($option_arr['o_smtp_pass'])
						;
					}
					$Email->setContentType('text/html');
					$admin_email = $this->getAdminEmail();
					$from_email = $admin_email;
					if(!empty($option_arr['o_sender_email']))
					{
						$from_email = $option_arr['o_sender_email'];
					}
					$tokens = pjAppController::getTokens($option_arr, $order_arr, PJ_SALT, $this->getLocaleId());
					
					/* Send payment confirmation email to customer */
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $this->getLocaleId())
						->where('t1.field', 'o_email_payment_message')
						->where('t1.foreign_id', $order_arr['restaurant_id'])
						->limit(0, 1)
						->findAll()
						->getData();
					$lang_subject = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $this->getLocaleId())
						->where('t1.field', 'o_email_payment_subject')
						->where('t1.foreign_id', $order_arr['restaurant_id'])
						->limit(0, 1)
						->findAll()
						->getData();
						
					if (count($lang_message) === 1 && count($lang_subject) === 1)
					{
						if ($order_arr['type'] == 'delivery')
						{
							$message = str_replace(array('[Delivery]', '[/Delivery]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						} elseif ($order_arr['type'] == 'catering') {
							$message = str_replace(array('[Catering]', '[/Catering]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $message);
						} else {
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						}
						$message = str_replace($tokens['search'], $tokens['replace'], $message);
						
						$Email
							->setTo($order_arr['c_email'])
							->setFrom($from_email)
							->setSubject($lang_subject[0]['content'])
							->send(pjUtil::textToHtml($message));
					}
					
					/* Send payment confirmation email to administrators */
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $this->getLocaleId())
						->where('t1.field', 'o_admin_email_payment_message')
						->where('t1.foreign_id', $order_arr['restaurant_id'])
						->limit(0, 1)
						->findAll()
						->getData();
					$lang_subject = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $this->getLocaleId())
						->where('t1.field', 'o_admin_email_payment_subject')
						->where('t1.foreign_id', $order_arr['restaurant_id'])
						->limit(0, 1)
						->findAll()
						->getData();
						
					if (count($lang_message) === 1 && count($lang_subject) === 1)
					{
						if ($order_arr['type'] == 'delivery')
						{
							$message = str_replace(array('[Delivery]', '[/Delivery]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						} elseif ($order_arr['type'] == 'catering') {
							$message = str_replace(array('[Catering]', '[/Catering]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $message);
						} else {
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						}
						$message = str_replace($tokens['search'], $tokens['replace'], $message);
						if (!empty($option_arr['o_second_notification_email'])) {
							$admin_email = $option_arr['o_second_notification_email'];
							//$Email->setCc($option_arr['o_second_notification_email']);					
						}
						$Email
							->setTo($admin_email)
							->setFrom($from_email)
							->setSubject($lang_subject[0]['content'])
							->send(pjUtil::textToHtml($message));
					}
				}
				if ($this->option_arr['o_allow_automatic_print'] == 'Yes_SDP') {
				    //Khuetech thêm thời gian yêu cầu sent_to_remote_printer_time để ghi nhận và in lại nhưng đơn yêu cầu trong 1 giờ trở lại
					pjOrderModel::factory()->reset()->set('id', (int)$_POST['id'])->modify(array('sent_to_remote_printer' => 'F', 'sent_to_remote_printer_time' => ':NOW()'));
				} else {
					pjFront::sendToRemotePrinter((int)$_POST['id'], $this->getLocaleId(), $this->option_arr, true);
				}
			}
			pjAppController::jsonResponse(array('status' => 'OK'));
		}
	}
	
	public function pjActionSendConfirmedOrderSms()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() && $this->isLoged())
		{
			if (isset($_POST['send']) && isset($_POST['id']) && (int)$_POST['id'] > 0) {
				$pjOrderModel = pjOrderModel::factory();
				$pjMultiLangModel = pjMultiLangModel::factory();
		
				$order_arr = $pjOrderModel
					->join('pjClient', "t2.id=t1.client_id", 'left outer')
					->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
							AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
							AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
							AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
							AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
					->find($_POST['id'])
					->getData();	
				pjAppController::addOrderDetails($order_arr, $this->getLocaleId());
				$tokens = pjAppController::getTokens($this->option_arr, $order_arr, PJ_SALT, $this->getLocaleId());
				if ($_POST['recipient'] == 'owner') {
					if (!empty($this->option_arr['o_notification_phone_number'])) {
						$phone = $this->option_arr['o_notification_phone_number'];
					} else {
						$phone = $this->getAdminPhone();
					}
					$field = 'o_admin_sms_payment_message';
				} else {
					$phone = $order_arr['c_phone'];
					$field = 'o_sms_payment_message';
				}
				if (!empty($phone)) {
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $this->getLocaleId())
						->where('t1.field', $field)
						->where('t1.foreign_id', $order_arr['restaurant_id'])
						->limit(0, 1)
						->findAll()
						->getData();
					if (count($lang_message) === 1)
					{
						$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
						if ($this->smsServiceProvider == 'clicksend') {
							$config = ClickSend\Configuration::getDefaultConfiguration()
							              ->setUsername($this->option_arr['plugin_sms_api_username'])
							              ->setPassword($this->option_arr['plugin_sms_api_password']);							
							$apiInstance = new ClickSend\Api\SMSApi(new GuzzleHttp\Client(),$config);
							$msg = new \ClickSend\Model\SmsMessage();
							$msg->setBody($message); 
							$msg->setTo($phone);
							$msg->setSource("sdk");
							$sms_messages = new \ClickSend\Model\SmsMessageCollection(); 
							$sms_messages->setMessages([$msg]);							
							try {
							    $result = $apiInstance->smsSendPost($sms_messages);			
							    $resp = json_decode($result, true);
							    pjSmsModel::factory()->reset()->setAttributes(array(
									'number' => $phone,
									'text' => $message,
									'provider' => 'clicksend',
							    	'restaurant_id' => $order_arr['restaurant_id'],
									'status' => @$resp['response_code']
								))->insert();				    
							} catch (Exception $e) {
							    //echo 'Exception when calling SMSApi->smsSendPost: ', $e->getMessage(), PHP_EOL;
							}
						} else {
							$params = array(
								'text' => $message,
								'type' => 'unicode',
								'restaurant_id' => $order_arr['restaurant_id'],
								'key' => md5(@$option_arr['private_key'] . PJ_SALT)
							);
							$params['number'] = $phone;
							$params['provider'] = $this->smsServiceProvider;
							$this->requestAction(array('controller' => 'pjSms', 'action' => 'pjActionSend', 'params' => $params), array('return'));
						}
					}
				}
			}
			pjAppController::jsonResponse(array('status' => 'OK'));
		}
	}
	
	public function pjActionSendReadyForPickupSms()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() && $this->isLoged())
		{
			if (isset($_POST['send']) && isset($_POST['id']) && (int)$_POST['id'] > 0) {
				$pjOrderModel = pjOrderModel::factory();
				$pjMultiLangModel = pjMultiLangModel::factory();
		
				$order_arr = $pjOrderModel
					->join('pjClient', "t2.id=t1.client_id", 'left outer')
					->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
							AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
							AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
							AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
							AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
					->find($_POST['id'])
					->getData();	
				pjAppController::addOrderDetails($order_arr, $this->getLocaleId());
				$tokens = pjAppController::getTokens($this->option_arr, $order_arr, PJ_SALT, $this->getLocaleId());
				$phone = $order_arr['c_phone'];
				$field = 'o_sms_ready_pickup_message';
				if (!empty($phone)) {
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $this->getLocaleId())
						->where('t1.field', $field)
						->where('t1.foreign_id', $order_arr['restaurant_id'])
						->limit(0, 1)
						->findAll()
						->getData();
					if (count($lang_message) === 1)
					{
						$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
						if ($this->smsServiceProvider == 'clicksend') {
							$config = ClickSend\Configuration::getDefaultConfiguration()
							              ->setUsername($this->option_arr['plugin_sms_api_username'])
							              ->setPassword($this->option_arr['plugin_sms_api_password']);							
							$apiInstance = new ClickSend\Api\SMSApi(new GuzzleHttp\Client(),$config);
							$msg = new \ClickSend\Model\SmsMessage();
							$msg->setBody($message); 
							$msg->setTo($phone);
							$msg->setSource("sdk");
							$sms_messages = new \ClickSend\Model\SmsMessageCollection(); 
							$sms_messages->setMessages([$msg]);							
							try {
							    $result = $apiInstance->smsSendPost($sms_messages);			
							    $resp = json_decode($result, true);
							    pjSmsModel::factory()->reset()->setAttributes(array(
									'number' => $phone,
									'text' => $message,
									'provider' => 'clicksend',
							    	'restaurant_id' => $order_arr['restaurant_id'],
									'status' => @$resp['response_code']
								))->insert();				    
							} catch (Exception $e) {
							    //echo 'Exception when calling SMSApi->smsSendPost: ', $e->getMessage(), PHP_EOL;
							}
						} else {
							$params = array(
								'text' => $message,
								'type' => 'unicode',
								'restaurant_id' => $order_arr['restaurant_id'],
								'key' => md5(@$option_arr['private_key'] . PJ_SALT)
							);
							$params['number'] = $phone;
							$params['provider'] = $this->smsServiceProvider;
							$this->requestAction(array('controller' => 'pjSms', 'action' => 'pjActionSend', 'params' => $params), array('return'));
						}
					}
				}
			}
			pjAppController::jsonResponse(array('status' => 'OK'));
		}
	}
	
	private function calcPriceWithoutDeliveryFee($params) {
	    $is_null = true;
	    foreach($params['product_id'] as $k => $v)
	    {
	        if( (int) $v > 0 )
	        {
	            $is_null = false;
	        }
	    }
	    if($is_null == false)
	    {
	        $price = 0;
	        $subtotal = 0;
	        $delivery = 0;
	        $tax = 0;
	        $total = 0;
	        $external_delivery_id = '';
	        
	        $pjProductModel = pjProductModel::factory();
	        $pjProductPriceModel = pjProductPriceModel::factory();
	        $pjExtraModel = pjExtraModel::factory();
	        
	        $product_arr = $pjProductModel
	        ->whereIn("t1.id", $params['product_id'])
	        ->findAll()
	        ->getData();
	        $extra_arr = $pjExtraModel
	        ->where('t1.restaurant_id', $this->getForeignId())
	        ->findAll()
	        ->getData();
	        
	        $modifier_item_arr = pjModifierItemModel::factory()
	        ->join('pjModifier', 't2.id=t1.modifier_id', 'inner')
	        ->where('t2.restaurant_id', $this->getForeignId())
	        ->findAll()
	        ->getDataPair('id', NULL);
	        
	        foreach ($params['product_id'] as $hash => $product_id)
	        {
	            foreach ($product_arr as $product)
	            {
	                if ($product['id'] == $product_id)
	                {
	                    $_price = 0;
	                    $extra_price = 0;
	                    $modifier_item_price = 0;
	                    
	                    if($product['set_different_sizes'] == 'T')
	                    {
	                        $price_arr = $pjProductPriceModel
	                        ->reset()
	                        ->find($params['price_id'][$hash])
	                        ->getData();
	                        if($price_arr)
	                        {
	                            $_price = $price_arr['price'];
	                        }
	                    }else{
	                        $_price = $product['price'];
	                    }
	                    
	                    $product_price = $_price * $params['cnt'][$hash];
	                    if (isset($params['extra_id']) && isset($params['extra_id'][$hash]))
	                    {
	                        foreach ($params['extra_id'][$hash] as $oi_id => $extra_id)
	                        {
	                            if (isset($params['extra_cnt'][$hash][$oi_id]) && (int) $params['extra_cnt'][$hash][$oi_id] > 0)
	                            {
	                                foreach ($extra_arr as $extra)
	                                {
	                                    if ($extra['id'] == $extra_id)
	                                    {
	                                        $extra_price += $extra['price'] * $params['extra_cnt'][$hash][$oi_id];
	                                        break;
	                                    }
	                                }
	                            }
	                        }
	                    }
	                    
	                    if (isset($params['modifier_item_id']) && isset($params['modifier_item_id'][$hash]))
	                    {
	                        foreach ($params['modifier_item_id'][$hash] as $m_id)
	                        {
	                            if (isset($modifier_item_arr[$m_id]) && (float)$modifier_item_arr[$m_id]['price'] > 0) {
	                                $modifier_item_price += (float)$modifier_item_arr[$m_id]['price'];
	                            }
	                        }
	                    }
	                    $_price = $product_price + $extra_price + $modifier_item_price;
	                    $price += $_price;
	                    break;
	                }
	            }
	        }
	        
	        $discount = 0;
	        if (!empty($params['voucher_code']))
	        {
	            $params['restaurant_id'] = $this->getForeignId();
	            $resp = pjAppController::getDiscount($params, $this->option_arr);
	            if ($resp['code'] == 200)
	            {
	                $voucher_discount = $resp['voucher_discount'];
	                switch ($resp['voucher_type'])
	                {
	                    case 'percent':
	                        $discount = ($price * $voucher_discount) / 100;
	                        break;
	                    case 'amount':
	                        $discount = $voucher_discount;
	                        break;
	                }
	            }
	        }
	        if($discount > $price)
	        {
	            $discount = $price;
	        }
	        $subtotal = $price - $discount;
	        
	        if(!empty($this->option_arr['o_tax_payment']))
	        {
	            $tax = ($subtotal * $this->option_arr['o_tax_payment']) / 100;
	        }
	        
	        $service_fee = $catering_fee = 0;
	        if($this->option_arr['o_allow_service_fee'] == 'Yes' && (float) $this->option_arr['o_service_fee'] > 0)
	        {
	            $service_fee = $this->option_arr['o_service_fee'];
	        }
	        
	        if ($params['type'] == 'catering') {
	            
	            if ($subtotal >= (float) $this->option_arr['o_catering_total']) {
	                $catering_fee = (float) $this->option_arr['o_catering_fee_percent'] * $subtotal / 100;
	            }
	            else {
	                $catering_fee = (float) $this->option_arr['o_catering_fee'];
	            }
	        }
	        
	        $total = $subtotal + $tax + $service_fee + $catering_fee;
	        
	        $tip_amount = $dasher_tip_amount = 0;
	        if ($params['tip_option'] == 1) {
	            $tip_amount = ($total * $params['tip_percentage']) / 100;
	        } elseif ($params['tip_option'] == 2) {
	            $tip_amount = $params['tip_amount'];
	        }
	        $total += $tip_amount;
	        if ($params['type'] == 'delivery' && $this->option_arr['o_allow_delivery_doordash'] == 'Yes' && (float)$this->option_arr['o_doordash_dasher_tip_earn'] > 0) {
	            $dasher_tip_amount = ($tip_amount * (float)$this->option_arr['o_doordash_dasher_tip_earn']) / 100;
	        }
	        
	        return array('price' => $total, 'dasher_tip_amount' => $dasher_tip_amount);
	    }else{
	        return array('price' => 0, 'dasher_tip_amount' => 0);
	    }
	}
	
	public function test() {
		$header = json_encode(array(
			'alg' => 'HS256',
		    'typ' => 'JWT',
		    'dd-ver' => 'DD-JWT-V1'
		));
		
		$payload = json_encode(array(
			'aud' => 'doordash',
		    'iss' => '42b46fb6-5450-40f8-8ff0-26ecf8b86b76',
		    'kid' => '89848790-a713-49b3-9c01-c13b4a1e3377',
		    'exp' => time() + 60,
		    'iat' => time()
		));
		
		$base64UrlHeader = pjAppController::base64UrlEncode($header);
		$base64UrlPayload = pjAppController::base64UrlEncode($payload);
		
		$signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, pjAppController::base64UrlDecode('aT_UsqENlP7O_laV1tw_h4MKFjZ0RYqVjaTjyMasFBI'), true);
		$base64UrlSignature = pjAppController::base64UrlEncode($signature);
		
		$jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
		
		$uuid = pjUtil::uuid();
		$request_body = json_encode(array(
			"external_delivery_id" => $uuid,
			  "pickup_address"=> "901 Market Street 6th Floor San Francisco, CA 94103",
			  "pickup_business_name"=> "Wells Fargo SF Downtown",
			  "pickup_phone_number"=> "+16505555555",
			  "pickup_instructions"=> "Enter gate code 1234 on the callbox.",
			  "dropoff_address"=> "901 Market Street 6th Floor San Francisco, CA 94103",
			  "dropoff_business_name"=> "Wells Fargo SF Downtown",
			  "dropoff_phone_number"=> "+16505555555",
			  "dropoff_instructions"=> "Enter gate code 1234 on the callbox.",
			  "order_value"=> 1999
		));
		
		$headers = array(
		  "Content-type: application/json",
		  "Authorization: Bearer ".$jwt
		);
		
		$http = new pjHttp();
		
		/*$http->setHeaders($headers);
		$http->request('https://openapi.doordash.com/drive/v2/deliveries/VN1663733326');
		$resp = $http->getResponse();
		echo "<pre>";
		print_r(json_decode($resp, true));
		echo "</pre>";
		exit;*/
		
		/*$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "https://openapi.doordash.com/drive/v2/deliveries/");
		//curl_setopt($ch, CURLOPT_URL, "https://openapi.doordash.com/drive/v2/quotes");
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $request_body);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		//$result = curl_exec($ch);*/
		
		
		$http->setHeaders($headers);
		$http->setMethod('POST');
		$http->setData($request_body, false);
		$http->request('https://openapi.doordash.com/drive/v2/quotes');
		$resp = $http->getResponse();
		echo "<pre>";
		print_r(json_decode($resp, true));
		echo "</pre>";exit;
		
		$http->setHeaders($headers);
		$http->request('https://openapi.doordash.com/drive/v2/quotes/'.$uuid.'/accept');
		$resp = $http->getResponse();
		echo "<pre>";
		print_r(json_decode($resp, true));
		echo "</pre>";
		
		$uuid = pjUtil::uuid();
		$request_body = json_encode(array(
			"external_delivery_id" => $uuid,
			  "pickup_address"=> "901 Market Street 6th Floor San Francisco, CA 94103",
			  "pickup_business_name"=> "Wells Fargo SF Downtown",
			  "pickup_phone_number"=> "+16505555555",
			  "pickup_instructions"=> "Enter gate code 1234 on the callbox.",
			  "dropoff_address"=> "901 Market Street 6th Floor San Francisco, CA 94103",
			  "dropoff_business_name"=> "Wells Fargo SF Downtown",
			  "dropoff_phone_number"=> "+16505555555",
			  "dropoff_instructions"=> "Enter gate code 1234 on the callbox.",
			  "order_value"=> 1999
		));
		$http->setHeaders($headers);
		$http->setMethod('POST');
		$http->setData($request_body, false);
		$http->request('https://openapi.doordash.com/drive/v2/deliveries/');
		$resp = $http->getResponse();
		echo "<pre>";
		print_r(json_decode($resp, true));
		echo "</pre>";
		
		
		$http->setHeaders($headers);
		$http->request('https://openapi.doordash.com/drive/v2/deliveries/'.$uuid);
		$resp = $http->getResponse();
		echo "<pre>";
		print_r(json_decode($resp, true));
		echo "</pre>";
		
		exit;
	}
}
?>