<div class="form pj-form">
	<p>
		<label class="title"><?php __('report_total_orders'); ?></label>
		<span class="inline_block t5"><?php echo $tpl['total_orders']?></span>
	</p>
	<p>
		<label class="title"><?php __('report_confirmed'); ?></label>
		<span class="inline_block t5"><?php echo $tpl['confirmed_orders']?></span>
	</p>
	<p>
		<label class="title"><?php __('report_pickup'); ?></label>
		<span class="inline_block t5"><?php echo $tpl['pickup_orders']?></span>
	</p>
	<p>
		<label class="title"><?php __('report_catering'); ?></label>
		<span class="inline_block t5"><?php echo $tpl['catering_orders']?></span>
	</p>
	<p>
		<label class="title"><?php __('report_delivery'); ?></label>
		<span class="inline_block t5"><?php echo $tpl['delivery_orders']?></span>
	</p>
	
	<p></p>
	
	<p>
		<label class="title"><?php __('report_unique_clients'); ?></label>
		<span class="inline_block t5"><?php echo $tpl['unique_clients']?></span>
	</p>
	<p>
		<label class="title"><?php __('report_first_time_clients'); ?></label>
		<span class="inline_block t5"><?php echo $tpl['first_time_clients']?></span>
	</p>
	
	<p></p>
	
	<p>
		<label class="title"><?php __('report_total_amount'); ?></label>
		<span class="inline_block t5"><?php echo pjUtil::formatCurrencySign(number_format($tpl['price_info']['total_amount'], 2), $tpl['option_arr']['o_currency']);?></span>
	</p>
	<p>
		<label class="title"><?php __('report_delivery_fees'); ?></label>
		<span class="inline_block t5"><?php echo pjUtil::formatCurrencySign(number_format($tpl['price_info']['delivery_fee'], 2), $tpl['option_arr']['o_currency']);?></span>
	</p>
	<p>
		<label class="title"><?php __('report_catering_fee'); ?></label>
		<span class="inline_block t5"><?php echo pjUtil::formatCurrencySign(number_format($tpl['price_info']['catering_fee'], 2), $tpl['option_arr']['o_currency']);?></span>
	</p>
	<p>
		<label class="title"><?php __('report_tax'); ?></label>
		<span class="inline_block t5"><?php echo pjUtil::formatCurrencySign(number_format($tpl['price_info']['tax'], 2), $tpl['option_arr']['o_currency']);?></span>
	</p>
	<p>
		<label class="title"><?php __('report_discounts'); ?></label>
		<span class="inline_block t5"><?php echo pjUtil::formatCurrencySign(number_format($tpl['price_info']['discount'], 2), $tpl['option_arr']['o_currency']);?></span>
	</p>
	<p>
		<label class="title"><?php __('report_tip'); ?></label>
		<span class="inline_block t5"><?php echo pjUtil::formatCurrencySign(number_format($tpl['price_info']['tip_amount'], 2), $tpl['option_arr']['o_currency']);?></span>
	</p>
	<p></p>
	
	<p>
		<label class="title"><?php __('report_total_products_ordered'); ?></label>
		<span class="inline_block t5"><?php echo $tpl['total_products']?></span>
	</p>
	
	<p></p>
	
	<table class="pj-table" style="width: 100%; margin-bottom: 12px;" cellspacing="0" cellpadding="0">
		<thead>
			<tr>
				<th><?php __('report_category');?></th>
				<th><?php __('report_products_ordered');?></th>
				<th><?php __('report_total_amount');?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach($tpl['category_arr'] as $k => $v)
			{
				?>
				<tr>
					<td><?php echo pjSanitize::html($v['name']);?></td>
					<td><?php echo (int) $v['total_products'];?></td>
					<td><?php echo pjUtil::formatCurrencySign(number_format( (float)$v['total_amount'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
				</tr>
				<?php
			} 
			?>
		</tbody>
	</table>
	
	<table class="pj-table" style="width: 100%;" cellspacing="0" cellpadding="0">
		<thead>
			<tr>
				<th><?php __('report_product');?></th>
				<th><?php __('report_quantity');?></th>
				<th><?php __('report_total_amount');?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach($tpl['product_arr'] as $k => $v)
			{
				?>
				<tr>
					<td><?php echo pjSanitize::html($v['name']);?></td>
					<td><?php echo (int) $v['total_products'];?></td>
					<td><?php echo pjUtil::formatCurrencySign(number_format( (float)$v['total_amount'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
				</tr>
				<?php
			} 
			?>
		</tbody>
	</table>
</div>