<?php
if (!defined("ROOT_PATH")) {
    header("HTTP/1.1 403 Forbidden");
    exit;
}

/*Library for Click send SMS*/
include(__DIR__ . '/components/click-send/vendor/autoload.php');

class pjKiosk extends pjKioskAppController
{

    public function checkAccess()
    {
        if ($this->getKioskId() == 0) {
            pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjKiosk&action=pjActionKioskIndex");
        }
    }

    public function pjActionKioskIndex()
    {
        $this->checkLogin();
        if ($this->isLoged() && $this->isAdmin()) {
            $this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
            $this->appendJs('pjKioskIndex.js', $this->getConst('PLUGIN_JS_PATH'));

        } else if ($this->isManager() || $this->isEditor()) {
            pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjKiosk&action=pjActionOrder");
        } else {
            $this->set('status', 2);
        }
    }

    public function pjAjaxKioskList()
    {
        $this->checkLogin();
        $this->setAjax(true);
        if ($this->isXHR() && $this->isLoged()) {
            $data = pjKioskModel::factory()->where('t1.rid', $this->getForeignId())->findAll()->getData();
            foreach ($data as $k => $kiosk) {
                /*Config App*/
                $setting = "files/" . $kiosk['rid'] . "/" . $kiosk['id'] . "/static/setting.json";
                if (is_file($setting)) {
                    $kiosk['setting'] = '<b style="color: white; background: #0e962c; padding: 3px 10px; border-radius: 3px;">Ready</b>';
                } else {
                    $kiosk['setting'] = '';
                }

                if (isset($kiosk['pre_receipt_name']) && $kiosk['pre_receipt_name'] === 'On') {
                    $kiosk['pre_receipt_name'] = '<span style="color: green;">' . $kiosk['pre_receipt_name'] . '</span>';
                } else {
                    $kiosk['pre_receipt_name'] = '<span style="color: red;">' . $kiosk['pre_receipt_name'] . '</span>';
                }

                /*Status*/
                if ($kiosk['active']) {
                    $kiosk['active'] = 'Active';
                } else {
                    $kiosk['active'] = 'Inactive';
                }

                $kiosk['clone']='<a class="pj-button" href="'.$_SERVER['PHP_SELF'].'?controller=pjKiosk&action=pjActionKioskClone&id='.$kiosk['id'].'">Clone</a>';

                $data[$k] = $kiosk;
            }

            $total = count($data);
            $page = 1;
            $rowCount = 100;
            $pages = $total / $rowCount;

            pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount'));
        }
    }

    private function copyDirectory($source, $destination) {
        if (!is_dir($destination)) {
            mkdir($destination, 0755, true);
        }
        $files = scandir($source);
        foreach ($files as $file) {
            if ($file !== '.' && $file !== '..') {
                $sourceFile = $source . '/' . $file;
                $destinationFile = $destination . '/' . $file;
                if (is_dir($sourceFile)) {
                    $this->copyDirectory($sourceFile, $destinationFile);
                } else {
                    copy($sourceFile, $destinationFile);
                }
            }
        }
    }

    public function pjActionKioskClone(){
        $this->checkLogin();
        if ($this->isLoged() && $this->isAdmin()) {
            if (isset($_GET['id'])) {
                $kiosk = pjKioskModel::factory()->find($_GET['id'])->getData();
                if(isset($kiosk)){
                    $kiosk_id_new = pjKioskModel::factory()
                        ->setAttributes(array(
                            'rid' => $this->getForeignId(),
                            'name' => $kiosk['name'].' (Clone)',
                            'description' => $kiosk['description'],
                            'pre_receipt_name' => $kiosk['pre_receipt_name']
                        ))
                        ->insert()
                        ->getInsertId();

                    $dir = "files/".$this->getForeignId()."/".$_GET['id']."/config/";
                    $dirNew = "files/".$this->getForeignId()."/".$kiosk_id_new."/config/";
                    $this->copyDirectory($dir, $dirNew);
                }
                pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjKiosk&action=pjActionKioskIndex");
            }
        }
    }

    public function pjActionKioskCreate()
    {
        $this->checkLogin();
        if ($this->isLoged() && $this->isAdmin()) {
            if (isset($_POST['kiosk_create'])) {
                pjKioskModel::factory()
                    ->setAttributes(array(
                        'rid' => $this->getForeignId(),
                        'name' => $_POST['name'],
                        'description' => $_POST['description'],
                        'pre_receipt_name' => $_POST['pre_receipt_name']
                    ))
                    ->insert()
                    ->getInsertId();
                pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjKiosk&action=" . $_POST['next_action']);
            }
        }
    }

    public function pjActionKioskUpdate()
    {
        $this->checkLogin();
        if ($this->isAdmin()) {
            if (isset($_POST['kiosk_update'])) {
                $update = array();
                $update['name'] = $_POST['name'];
                $update['description'] = $_POST['description'];
                $update['pre_receipt_name'] = $_POST['pre_receipt_name'];

                pjKioskModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($update);
                pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjKiosk&action=" . $_POST['next_action']);
            }

            $kiosk_update = pjKioskModel::factory()->find($_GET['id'])->getData();
            $this->set('kiosk_update', $kiosk_update);
        }
    }

    public function pjActionKioskDelete()
    {
        $this->checkLogin();
        $this->setAjax(true);
        if ($this->isXHR() && $this->isLoged() && $this->isAdmin()) {
            if (isset($_GET['id'])) {
                pjKioskModel::factory()->where('id', $_GET['id'])->eraseAll();
                $response['code'] = 200;
            } else {
                $response['code'] = 100;
            }
            pjAppController::jsonResponse($response);
        }
        exit;
    }

    public function pjActionSettingApp()
    {
        $this->checkLogin();
        $this->checkAccess();
        if ($this->isLoged()) {
            if (isset($_POST['kiosk_general_setting'])) {
                $status = $this->generalSetting($this->getLocaleId(), $this->getForeignId(), $this->getKioskId());
                $this->set('status', $status);
                //pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjKiosk&action=pjActionSettingApp&status=".$status);
            }

            $this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
            $this->appendJs('pjKioskSettingApp.js', $this->getConst('PLUGIN_JS_PATH'));
            $this->appendJs('index.php?controller=pjAdmin&action=pjActionMessages', PJ_INSTALL_URL, true);
        } else {
            $this->set('status', 2);
        }
    }

    public function pjActionSettingAppEdit()
    {

    }

    public function pjAjaxGetKioskSettingList()
    {
        $this->checkLogin();
        $this->setAjax(true);
        if ($this->isXHR() && $this->isLoged() && $this->isAdmin()) {
            $pathStatic = "files/" . $this->getForeignId() . "/" . $this->getKioskId() . "/static";
            $fileList = glob($pathStatic . '/*.json');

            $data = [];
            $total = 0;
            foreach ($fileList as $filename) {
                if (is_file($filename)) {
                    $item['filename'] = $filename;
                    $item['basename'] = basename($filename);
                    $item['filesize'] = filesize($filename);
                    $item['filedate'] = date("Y-m-d H:i:s", fileatime($filename));
                    $item['status'] = "<span style='color: red; background: #ffebeb; padding: 3px 5px; border-radius: 5px;'>Backup</span>";

                    if (strpos($filename, 'setting.json') !== false) {
                        $item['status'] = "<span style='color: green; background: #edf4ec; padding: 3px 5px; border-radius: 5px;'>Active</span>";
                    }
                    $data[] = $item;
                    $total++;
                }
            }

            $page = 1;
            $rowCount = 100;
            $pages = $total / $rowCount;

            pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount'));
        }
    }

    public function pjAjaxSettingAppEdit()
    {
        $this->checkLogin();
        $this->setAjax(true);
        if ($this->isXHR() && $this->isLoged() && $this->isAdmin()) {
            if (isset($_POST['filename'])) {
                $content = json_decode(file_get_contents($_POST['filename']), true);
                pjAppController::jsonResponse($content);
            }
        }
    }

    public function pjAjaxSettingAppSave()
    {
        $this->checkLogin();
        $this->setAjax(true);
        if ($this->isXHR() && $this->isLoged() && $this->isAdmin()) {
            if (isset($_POST['update_setting_app']) && isset($_POST['filename']) && isset($_POST['content'])) {
                $filename = $_POST['filename'];
                $content = $_POST['content'];

                if (file_put_contents($filename, $content)) {
                    pjAppController::jsonResponse('success');
                }
                pjAppController::jsonResponse('error');
            }
        }
    }

    public function pjAjaxSettingAppDelete()
    {
        $this->checkLogin();
        $this->setAjax(true);
        if ($this->isXHR() && $this->isLoged() && $this->isAdmin()) {
            if (isset($_GET['filename'])) {
                $filename = $_GET['filename'];
                if (unlink($filename)) {
                    $response['code'] = 200;
                } else {
                    $response['code'] = 100;
                }
                pjAppController::jsonResponse($response);
            }
        }
        exit;
    }


    public function pjActionSetKioskId()
    {
        if (isset($_POST['kioskId']) && (int)$_POST['kioskId'] > 0) {
            $this->setKioskId((int)$_POST['kioskId']);
        }
        exit;
    }

    public function pjActionConfig()
    {
        $this->checkLogin();
        $this->checkAccess();
        if ($this->isLoged() && $this->isAdmin()) {

            /*Nếu cập nhật general*/
            if (isset($_POST['options_update'])) {

                //print_r($_FILES['welcome_imgs']);
                /*Xử lý danh sách printers*/
                $printer_ids = $_POST['printer_ids'];
                $printer_pre_names = $_POST['printer_pre_names'];
                $printer_ips = $_POST['printer_ips'];
                $printer_ports = $_POST['printer_ports'];
                $printer_locations = $_POST['printer_locations'];
                unset($_POST['printer_pre_names']);
                unset($_POST['printer_ips']);
                unset($_POST['printer_ports']);
                unset($_POST['printer_locations']);

                $printers = [];
                for ($i = 0; $i < count($printer_ids); $i++) {
                    if ($printer_ids[$i] === '') {
                        $printer_ids[$i] = uniqid();
                    }
                    $printer['id'] = $printer_ids[$i];
                    $printer['pre_name'] = $printer_pre_names[$i];
                    $printer['ip'] = $printer_ips[$i];
                    $printer['port'] = $printer_ports[$i];
                    $printer['location'] = $printer_locations[$i];

                    $printers[] = $printer;
                }

                /*Xử lý danh sách welcome*/
                $welcome_texts = $_POST['welcome_texts'];
                $welcome_imgs = $_FILES['welcome_imgs'];
                $welcome_imgs_old = $_POST['welcome_imgs_old'];
                unset($_POST['welcome_texts']);
                unset($_FILES['welcome_imgs']);
                unset($_POST['welcome_imgs_old']);
                $welcome = [];
                for ($i = 0; $i < count($welcome_texts); $i++) {
                    $pathImages = "files/" . $this->getForeignId() . "/" . $this->getKioskId() . "/images";
                    if (!file_exists($pathImages)) {
                        mkdir($pathImages, 0777, true);
                    }

                    $target_file=$welcome_imgs_old[$i];
                    if(isset($welcome_imgs["name"][$i]) && strlen($welcome_imgs["name"][$i])>0){
                        $target_file = $pathImages. "/" .basename($welcome_imgs["name"][$i]);
                        if (!file_exists($target_file)) {
                            move_uploaded_file($welcome_imgs["tmp_name"][$i], $target_file);
                        }
                    }

                    if(isset($target_file) && strlen($target_file)>0) {
                        $wc['text'] = $welcome_texts[$i];
                        $wc['img'] = $target_file;
                        $welcome[] = $wc;
                    }
                }

                /*Lưu data*/
                $data = array();
                foreach ($_POST as $key => $value) {
                    $data[$key] = $value;
                }
                $data['printers'] = $printers;
                $data['welcome'] = $welcome;

                if ($this->setConfigData($data)) {
                    pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjKiosk&action=pjActionConfig&result=success");
                } else {
                    pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjKiosk&action=pjActionConfig&result=error");
                }
            }

            $config = $this->getConfigData();
            $this->set('kiosk_config', $config);
            $this->set('rid', $this->getForeignId());
            $this->set('kid', $this->getKioskId());
            $this->set('domain', PJ_INSTALL_URL);
        } else {
            $this->set('status', 2);
        }
    }

    private function generalUSAEpay($key, $pin)
    {
        $seed = "abcdefghijklmnop";
        $apikey = $key;
        $apipin = $pin;
        $prehash = $apikey . $seed . $apipin;
        $apihash = "s2/" . $seed . "/" . hash("sha256", $prehash);
        $authKey = base64_encode($apikey . ':' . $apihash);
        return "Basic " . $authKey;
    }

    public function apiGetSettingApp()
    {
        $this->setAjax(true);
        $response = array();
        $response['code'] = 400;
        $response['message'] = "Bad request";

        /*$headers = apache_request_headers();
        $authorization=$headers['Authorization'];
        $response['headers']=$authorization;*/

        $body = json_decode(file_get_contents('php://input'), true);
        if (isset($body['rid']) && isset($body['kid'])) {
            $rid = $body['rid'];
            $kid = $body['kid'];

            $pathConfig = "files/" . $rid . "/" . $kid . "/static";
            if (file_exists($pathConfig . "/setting.json")) {
                $setting = json_decode(file_get_contents($pathConfig . "/setting.json"), true);

                $response['code'] = 200;
                $response['message'] = "Success";
                $response['result'] = $setting;
            } else {
                $response['code'] = 404;
                $response['message'] = "Not found";
            }
        }

        pjAppController::jsonResponse($response);
        exit;
    }

    private function generalSetting($locale, $rid, $kiosId)
    {
        $data = array();
        $config = $this->getConfigData();

        /*Restaurant*/
        $restaurant = pjRestaurantModel::factory()->find($rid)->getData();

        /*Kiosk*/
        $kioskInfo = $this->getKiosk();
        $kiosk = [];
        $kiosk["name"] = $kioskInfo['name'];
        $kiosk["description"] = $kioskInfo['description'];
        $kiosk["pre_receipt_name"] = $kioskInfo['pre_receipt_name'];

        /*USA Epay*/
        $usaEpay = [];
        $usaEpay["URL"] = $config['usaepay_api_url'];
        $usaEpay["Authorization"] = $config['usaepay_api_key'];
        $usaEpay["Pin"] = $config['usaepay_api_pin'];
        //$usaEpay["Authorization"]=$this->generalUSAEpay($config['usaepay_api_key'], $config['usaepay_api_pin']);
        $usaEpay["devicekey"] = $config['usaepay_api_devicekey'];
        $usaEpay["command"] = $config['usaepay_api_command'];
        $usaEpay["timeout"] = $config['usaepay_api_timeout'];
        $usaEpay["prompt_tip"] = $config['usaepay_prompt_tip'];
        $usaEpay["fee_charges"] = $config['usaepay_fee_charges'];
        $usaEpay["fee_other"] = $config['usaepay_fee_other'];

        /*SMS*/
        $sms = [];
        $sms["URL"] = $config['sms_url'];
        $sms["From"] = $config['sms_from'];
        $sms["Username"] = $config['sms_username'];
        $sms["APIKey"] = $config['sms_apikey'];
        $sms["Authorization"] = $config['sms_authorization'];

        /*build data*/
        $data['restaurant'] = $restaurant;
        $data['kiosk'] = $kiosk;
        $data['USAePay'] = $usaEpay;
        $data['SMS'] = $sms;
        $data['printers'] = $config['printers'];
        $data['welcome'] = $config['welcome'];
        foreach ($data['welcome'] as $k=>$v){
            if(isset($data['welcome'][$k]['img']) && strpos($data['welcome'][$k]['img'],"http")!==false){
                $data['welcome'][$k]['img'] =  $data['welcome'][$k]['img'];
            }else {
                $data['welcome'][$k]['img'] = PJ_INSTALL_URL . $data['welcome'][$k]['img'];
            }
        }
        $data['crossAxisCount'] = (int)$config['cross_axis_count'];
        $data['tips'] = $config['tips'];
        $data['tax'] = (float)$config['tax'];
        $data['categories'] = $this->generalCategories($locale, $rid, (int)$config['cross_axis_cell_count'], (int)$config['main_axis_cell_count']);

        $json = json_encode($data, JSON_UNESCAPED_UNICODE);

        $pathStatic = "files/" . $rid . "/" . $kiosId . "/static";
        $pathImages = "files/" . $rid . "/" . $kiosId . "/images";

        if (!file_exists($pathStatic)) {
            mkdir($pathStatic, 0777, true);
        }

        if (!file_exists($pathImages)) {
            mkdir($pathImages, 0777, true);
        }

        $pathOld = $pathStatic . "/setting.json";
        if (file_exists($pathOld)) {
            $pathBackup = $pathStatic . "/setting_backup_" . date("YmdHis") . ".json";
            rename($pathOld, $pathBackup);
        }

        $status = "Oops! Error creating json file";
        if (file_put_contents($pathStatic . "/setting.json", $json)) {
            $status = "JSON file created successfully";
        }

        return $status;
    }

    private function generalCategories($locale, $rid, $cross_axis_cell_count, $main_axis_cell_count)
    {
        $pjCategoryModel = pjCategoryModel::factory()->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjCategory' AND t2.locale = '" . $locale . "' AND t2.field = 'name'", 'left');
        $pjCategoryModel->where('t1.restaurant_id', $rid);
        $pjCategoryModel->where('t1.status', 'T');

        $data = $pjCategoryModel
            ->select('t1.*, t2.content AS name, (SELECT COUNT(TPC.product_id) FROM `' . pjProductCategoryModel::factory()->getTable() . '` AS TPC WHERE TPC.category_id=t1.id) AS cnt_products')
            ->orderBy('t1.order ASC')
            ->findAll()
            ->getData();

        foreach ($data as $k => $category) {
            $category['lst_products'] = $this->getProductByCategory($category['id'], $rid, $locale, $cross_axis_cell_count, $main_axis_cell_count);
            $category['cnt_products']=count($category['lst_products'])."";
            $data[$k] = $category;
        }

        return $data;
    }

    private function getProductByCategory($categoryId, $rid, $localeId, $cross_axis_cell_count, $main_axis_cell_count)
    {
        if (isset($categoryId)) {
            $pjProductModel = pjProductModel::factory();
            $arr = $pjProductModel
                ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '" . $localeId . "' AND t2.field = 'name'", 'left')
                ->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjProduct' AND t3.locale = '" . $localeId . "' AND t3.field = 'description'", 'left')
                ->join('pjProductCategory', 't4.product_id=t1.id', 'left outer')
                ->select("t1.*, t2.content AS name, t3.content AS description, t4.category_id")
                ->where('t4.category_id', $categoryId)
                ->where('t1.status', 'T')
                ->orderBy("t1.is_featured DESC, t2.content ASC")
                ->findAll()
                ->getData();

            $pjExtraModel = pjExtraModel::factory();
            $pjProductExtraTable = pjProductExtraModel::factory()->getTable();
            $pjProductPriceModel = pjProductPriceModel::factory();
            $pjProductGroupModel = pjProductGroupModel::factory();
            $pjProductGroupItemModel = pjProductGroupItemModel::factory();
            $pjProductModifierModel = pjProductModifierModel::factory();

            $pjProductComboModel = pjProductComboModel::factory();
            $pjProductComboItemModel = pjProductComboItemModel::factory();
            $combo_arr = $combo_item_arr = array();

            $group_arr = $group_item_arr = array();
            $price_arr = array();
            $extra_arr = array();
            $product_id_arr = $pjProductModel->findAll()->getDataPair(null, 'id');
            if (!empty($product_id_arr)) {
                $temp_extra_arr = $pjExtraModel
                    ->reset()
                    ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjExtra' AND t2.locale = '" . $localeId . "' AND t2.field = 'name'", 'left')
                    ->join('pjProductExtra', "t3.extra_id = t1.id", 'left')
                    ->where("(t1.id IN (SELECT TPE.extra_id FROM `" . $pjProductExtraTable . "` AS TPE WHERE TPE.product_id IN(" . join(",", $product_id_arr) . ") ))")
                    ->select("t1.*, t2.content AS name, t3.product_id")
                    ->orderBy("name ASC")
                    ->findAll()
                    ->getData();
                foreach ($temp_extra_arr as $k => $v) {
                    $extra_arr[$v['product_id']][] = $v;
                }
                $temp_price_arr = $pjProductPriceModel
                    ->reset()
                    ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '" . $localeId . "' AND t2.field = 'price_name'", 'left')
                    ->whereIn('t1.product_id', $product_id_arr)
                    ->select("t1.*, t2.content AS price_name")
                    ->findAll()
                    ->getData();
                foreach ($temp_price_arr as $k => $v) {
                    $price_arr[$v['product_id']][] = $v;
                }

                $_group_arr = $pjProductGroupModel->select('t1.*, t2.content AS group_name')
                    ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroup' AND t2.locale = '" . $localeId . "' AND t2.field = 'group_name'", 'left')
                    ->whereIn('t1.product_id', $product_id_arr)
                    ->orderBy('t2.content ASC')
                    ->findAll()
                    ->getData();
                $group_ids_arr = array();
                foreach ($_group_arr as $item) {
                    $group_arr[$item['product_id']][] = $item;
                    $group_ids_arr[] = $item['id'];

                }
                if ($group_ids_arr) {
                    $_group_item_arr = $pjProductGroupItemModel->select('t1.*, t2.content AS group_item_name')
                        ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroupItem' AND t2.locale = '" . $localeId . "' AND t2.field = 'group_item_name'", 'left')
                        ->whereIn('t1.group_id', $group_ids_arr)
                        ->orderBy('t2.content ASC')
                        ->findAll()
                        ->getData();
                    foreach ($_group_item_arr as $item) {
                        $group_item_arr[$item['group_id']][] = $item;
                    }
                }

                /*Khuetech product combo*/
                $_combo_arr = $pjProductComboModel->select('t1.*, t2.content AS name')
                    ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductCombo' AND t2.locale = '" . $localeId . "' AND t2.field = 'combo_name'", 'left')
                    ->whereIn('t1.product_id', $product_id_arr)
                    ->orderBy('t2.content ASC')
                    ->findAll()
                    ->getData();
                $combo_ids_arr = array();
                foreach ($_combo_arr as $item) {
                    $combo_arr[$item['product_id']][] = $item;
                    $combo_ids_arr[] = $item['id'];

                }
                if ($combo_ids_arr) {
                    $_combo_item_arr = $pjProductComboItemModel
                        ->whereIn('t1.combo_id', $combo_ids_arr)
                        ->findAll()
                        ->getData();
                    foreach ($_combo_item_arr as $item) {
                        $combo_item_arr[$item['combo_id']][] = $item;
                    }
                }
                /*End Khuetech*/

                $modifier_arr = $modifier_item_arr = array();
                $_modifier_arr = $pjProductModifierModel->select('t1.*, t2.content AS modifier_name')
                    ->join('pjMultiLang', "t2.foreign_id = t1.modifier_id AND t2.model = 'pjModifier' AND t2.locale = '" . $localeId . "' AND t2.field = 'name'", 'left')
                    ->whereIn('t1.product_id', $product_id_arr)
                    ->orderBy('t2.content ASC')
                    ->findAll()
                    ->getData();
                $modifier_ids_arr = array();
                foreach ($_modifier_arr as $item) {
                    $item['id'] = $item['modifier_id'];
                    unset($item['modifier_id']);

                    $modifier_arr[$item['product_id']][] = $item;
                    $modifier_ids_arr[] = $item['id'];
                }
                if ($modifier_ids_arr) {
                    $_modifier_item_arr = pjModifierItemModel::factory()->select('t1.*, t2.content AS modifier_item_name')
                        ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjModifierItem' AND t2.locale = '" . $localeId . "' AND t2.field = 'item_name'", 'left')
                        ->whereIn('t1.modifier_id', $modifier_ids_arr)
                        ->orderBy('t2.content ASC')
                        ->findAll()
                        ->getData();
                    foreach ($_modifier_item_arr as $item) {
                        $modifier_item_arr[$item['modifier_id']][] = $item;
                    }
                }
            }

            /*Custom group_arr*/
            foreach ($group_arr as $k => $group) {
                foreach ($group as $i => $group_item) {
                    $group_item['group_item_arr'] = array();
                    if (isset($group_item_arr[$group_item['id']])) {
                        $group_item['group_item_arr'] = $group_item_arr[$group_item['id']];
                    }
                    $group[$i] = $group_item;
                }
                $group_arr[$k] = $group;
            }

            /*Custom extra_arr*/
            $custom_extras=$this->getCustomExtrasData();
            foreach ($extra_arr as $k => $extra) {
                foreach ($extra as $i => $extra_item) {
                    if (array_key_exists($extra_item['id'], $custom_extras)) {
                        $extra_item['pre_name'] = $custom_extras[$extra_item['id']]['pre_name'];
                        $extra_item['printers'] = $custom_extras[$extra_item['id']]['printers'];
                    } else {
                        $extra_item['pre_name'] = "";
                        $extra_item['printers'] = array();
                    }
                    $extra[$i] = $extra_item;
                }
                $extra_arr[$k] = $extra;
            }

            /*Custom modifier_arr*/
            $custom_modifiers=$this->getCustomModifiersData();
            foreach ($modifier_arr as $k => $modifier) {
                foreach ($modifier as $i => $modifier_item) {
                    if (array_key_exists($modifier_item['id'], $custom_modifiers)) {
                        $modifier_item['modifier_pre_name'] = $custom_modifiers[$modifier_item['id']]['pre_name'];
                        $modifier_item['printers'] = $custom_modifiers[$modifier_item['id']]['printers'];
                    } else {
                        $modifier_item['modifier_pre_name'] = "";
                        $modifier_item['printers'] = array();
                    }

                    $modifier_item['modifier_item_arr'] = array();
                    if (isset($modifier_item_arr[$modifier_item['id']])) {
                        $modifier_item['modifier_item_arr'] = $modifier_item_arr[$modifier_item['id']];

                        if(isset($custom_modifiers[$modifier_item['id']]['pre_item_names'])) {
                            foreach ($modifier_item['modifier_item_arr'] as $j => $modifier_item_arr_item) {
                                if (array_key_exists($modifier_item_arr_item['id'], $custom_modifiers[$modifier_item['id']]['pre_item_names'])) {
                                    $modifier_item['modifier_item_arr'][$j]['modifier_item_pre_name'] = $custom_modifiers[$modifier_item['id']]['pre_item_names'][$modifier_item_arr_item['id']];
                                } else {
                                    $modifier_item['modifier_item_arr'][$j]['modifier_item_pre_name'] = "";
                                }
                            }
                        }
                    }
                    $modifier[$i] = $modifier_item;
                }
                $modifier_arr[$k] = $modifier;
            }

            /*Custom combo_arr*/
            $product_all=$this->getProductAll($rid, $localeId, $cross_axis_cell_count, $main_axis_cell_count);
            foreach ($combo_arr as $k => $combo) {
                foreach ($combo as $i => $combo_item) {
                    $combo_item['lst_products'] = array();
                    if (isset($combo_item_arr[$combo_item['id']])) {
                        $lst_products=array();
                        foreach ($combo_item_arr[$combo_item['id']] as $k1=>$v1){
                            foreach($product_all as $k2=>$v2){
                                if($v1['product_combo_id']==$v2['id']){
                                    $product_custom['id']=$v2['id'];
                                    $product_custom['name']=$v2['name'];
                                    $product_custom['pre_name']=$v2['pre_name'];
                                    $product_custom['description']=$v2['description'];
                                    $product_custom['image']=$v2['image'];
                                    $product_custom['printers']=$v2['printers'];

                                    $lst_products[]=$product_custom;
                                    break;
                                }
                            }
                        }
                        $keys = array_column($lst_products, 'name');
                        array_multisort($keys, SORT_ASC, $lst_products);
                        $combo_item['lst_products'] = $lst_products;
                    }
                    unset($combo_item['product_id']);
                    $combo[$i] = $combo_item;
                }
                $combo_arr[$k] = $combo;
            }

            /*Custom products*/
            $custom_products = $this->getCustomProductsData();
            foreach ($arr as $k => $product) {
                $product['price_arr'] = array();
                $product['extra_arr'] = array();
                $product['group_arr'] = array();
                $product['modifier_arr'] = array();
                $product['combo_arr'] = array();

                if (isset($extra_arr[$product['id']])) {
                    $product['extra_arr'] = $extra_arr[$product['id']];
                }
                if ($product['set_different_sizes'] == 'T' && isset($price_arr[$product['id']])) {
                    $product['price_arr'] = $price_arr[$product['id']];
                }
                if (isset($group_arr[$product['id']])) {
                    $product['group_arr'] = $group_arr[$product['id']];
                }
                if (isset($modifier_arr[$product['id']])) {
                    $product['modifier_arr'] = $modifier_arr[$product['id']];
                }
                if (isset($combo_arr[$product['id']])) {
                    $product['combo_arr'] = $combo_arr[$product['id']];
                }

                /*Chỉnh lại image path và thêm thuộc tính sản phẩm ở đây*/
                $product["crossAxisCellCount"] = $cross_axis_cell_count;
                $product["mainAxisCellCount"] = $main_axis_cell_count;
                $product["image"] = PJ_INSTALL_URL . $product["image"];

                if (array_key_exists($product['id'], $custom_products)) {
                    $product['pre_name'] = $custom_products[$product['id']]['pre_name'];
                    $product['printers'] = $custom_products[$product['id']]['printers'];
                } else {
                    $product['pre_name'] = "";
                    $product['printers'] = array();
                }

                $arr[$k] = $product;
            }
            return $arr;
        }
    }

    private function getProductAll($restaurant_id, $localeId, $cross_axis_cell_count, $main_axis_cell_count)
    {
        if (isset($restaurant_id)) {
            $pjProductModel = pjProductModel::factory();
            $arr = $pjProductModel
                ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '" . $localeId . "' AND t2.field = 'name'", 'left')
                ->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjProduct' AND t3.locale = '" . $localeId . "' AND t3.field = 'description'", 'left')
                ->join('pjProductCategory', 't4.product_id=t1.id', 'left outer')
                ->select("t1.*, t2.content AS name, t3.content AS description, t4.category_id")
                ->where('t1.restaurant_id', $restaurant_id)
                ->where('t1.status', 'T')
                ->orderBy("t1.is_featured DESC, t2.content ASC")
                ->findAll()
                ->getData();

            $pjExtraModel = pjExtraModel::factory();
            $pjProductExtraTable = pjProductExtraModel::factory()->getTable();
            $pjProductPriceModel = pjProductPriceModel::factory();
            $pjProductGroupModel = pjProductGroupModel::factory();
            $pjProductGroupItemModel = pjProductGroupItemModel::factory();
            $pjProductModifierModel = pjProductModifierModel::factory();

            $pjProductComboModel = pjProductComboModel::factory();
            $pjProductComboItemModel = pjProductComboItemModel::factory();
            $combo_arr = $combo_item_arr = array();

            $group_arr = $group_item_arr = array();
            $price_arr = array();
            $extra_arr = array();
            $product_id_arr = $pjProductModel->findAll()->getDataPair(null, 'id');
            if (!empty($product_id_arr)) {
                $temp_extra_arr = $pjExtraModel
                    ->reset()
                    ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjExtra' AND t2.locale = '" . $localeId . "' AND t2.field = 'name'", 'left')
                    ->join('pjProductExtra', "t3.extra_id = t1.id", 'left')
                    ->where("(t1.id IN (SELECT TPE.extra_id FROM `" . $pjProductExtraTable . "` AS TPE WHERE TPE.product_id IN(" . join(",", $product_id_arr) . ") ))")
                    ->select("t1.*, t2.content AS name, t3.product_id")
                    ->orderBy("name ASC")
                    ->findAll()
                    ->getData();
                foreach ($temp_extra_arr as $k => $v) {
                    $extra_arr[$v['product_id']][] = $v;
                }
                $temp_price_arr = $pjProductPriceModel
                    ->reset()
                    ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '" . $localeId . "' AND t2.field = 'price_name'", 'left')
                    ->whereIn('t1.product_id', $product_id_arr)
                    ->select("t1.*, t2.content AS price_name")
                    ->findAll()
                    ->getData();
                foreach ($temp_price_arr as $k => $v) {
                    $price_arr[$v['product_id']][] = $v;
                }

                $_group_arr = $pjProductGroupModel->select('t1.*, t2.content AS group_name')
                    ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroup' AND t2.locale = '" . $localeId . "' AND t2.field = 'group_name'", 'left')
                    ->whereIn('t1.product_id', $product_id_arr)
                    ->orderBy('t2.content ASC')
                    ->findAll()
                    ->getData();
                $group_ids_arr = array();
                foreach ($_group_arr as $item) {
                    $group_arr[$item['product_id']][] = $item;
                    $group_ids_arr[] = $item['id'];

                }
                if ($group_ids_arr) {
                    $_group_item_arr = $pjProductGroupItemModel->select('t1.*, t2.content AS group_item_name')
                        ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroupItem' AND t2.locale = '" . $localeId . "' AND t2.field = 'group_item_name'", 'left')
                        ->whereIn('t1.group_id', $group_ids_arr)
                        ->orderBy('t2.content ASC')
                        ->findAll()
                        ->getData();
                    foreach ($_group_item_arr as $item) {
                        $group_item_arr[$item['group_id']][] = $item;
                    }
                }

                /*Khuetech product combo*/
                $_combo_arr = $pjProductComboModel->select('t1.*, t2.content AS name')
                    ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductCombo' AND t2.locale = '" . $localeId . "' AND t2.field = 'combo_name'", 'left')
                    ->whereIn('t1.product_id', $product_id_arr)
                    ->orderBy('t2.content ASC')
                    ->findAll()
                    ->getData();
                $combo_ids_arr = array();
                foreach ($_combo_arr as $item) {
                    $combo_arr[$item['product_id']][] = $item;
                    $combo_ids_arr[] = $item['id'];

                }
                if ($combo_ids_arr) {
                    $_combo_item_arr = $pjProductComboItemModel
                        ->whereIn('t1.combo_id', $combo_ids_arr)
                        ->findAll()
                        ->getData();
                    foreach ($_combo_item_arr as $item) {
                        $combo_item_arr[$item['combo_id']][] = $item;
                    }
                }
                /*End Khuetech*/

                $modifier_arr = $modifier_item_arr = array();
                $_modifier_arr = $pjProductModifierModel->select('t1.*, t2.content AS modifier_name')
                    ->join('pjMultiLang', "t2.foreign_id = t1.modifier_id AND t2.model = 'pjModifier' AND t2.locale = '" . $localeId . "' AND t2.field = 'name'", 'left')
                    ->whereIn('t1.product_id', $product_id_arr)
                    ->orderBy('t2.content ASC')
                    ->findAll()
                    ->getData();
                $modifier_ids_arr = array();
                foreach ($_modifier_arr as $item) {
                    $item['id'] = $item['modifier_id'];
                    unset($item['modifier_id']);

                    $modifier_arr[$item['product_id']][] = $item;
                    $modifier_ids_arr[] = $item['id'];
                }
                if ($modifier_ids_arr) {
                    $_modifier_item_arr = pjModifierItemModel::factory()->select('t1.*, t2.content AS modifier_item_name')
                        ->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjModifierItem' AND t2.locale = '" . $localeId . "' AND t2.field = 'item_name'", 'left')
                        ->whereIn('t1.modifier_id', $modifier_ids_arr)
                        ->orderBy('t2.content ASC')
                        ->findAll()
                        ->getData();
                    foreach ($_modifier_item_arr as $item) {
                        $modifier_item_arr[$item['modifier_id']][] = $item;
                    }
                }
            }

            /*Custom group_arr*/
            foreach ($group_arr as $k => $group) {
                foreach ($group as $i => $group_item) {
                    $group_item['group_item_arr'] = array();
                    if (isset($group_item_arr[$group_item['id']])) {
                        $group_item['group_item_arr'] = $group_item_arr[$group_item['id']];
                    }
                    $group[$i] = $group_item;
                }
                $group_arr[$k] = $group;
            }

            /*Custom extra_arr*/
            $custom_extras=$this->getCustomExtrasData();
            foreach ($extra_arr as $k => $extra) {
                foreach ($extra as $i => $extra_item) {
                    if (array_key_exists($extra_item['id'], $custom_extras)) {
                        $extra_item['pre_name'] = $custom_extras[$extra_item['id']]['pre_name'];
                        $extra_item['printers'] = $custom_extras[$extra_item['id']]['printers'];
                    } else {
                        $extra_item['pre_name'] = "";
                        $extra_item['printers'] = array();
                    }
                    $extra[$i] = $extra_item;
                }
                $extra_arr[$k] = $extra;
            }

            /*Custom modifier_arr*/
            $custom_modifiers=$this->getCustomModifiersData();
            foreach ($modifier_arr as $k => $modifier) {
                foreach ($modifier as $i => $modifier_item) {
                    if (array_key_exists($modifier_item['id'], $custom_modifiers)) {
                        $modifier_item['modifier_pre_name'] = $custom_modifiers[$modifier_item['id']]['pre_name'];
                        $modifier_item['printers'] = $custom_modifiers[$modifier_item['id']]['printers'];
                    } else {
                        $modifier_item['modifier_pre_name'] = "";
                        $modifier_item['printers'] = array();
                    }

                    $modifier_item['modifier_item_arr'] = array();
                    if (isset($modifier_item_arr[$modifier_item['id']])) {
                        $modifier_item['modifier_item_arr'] = $modifier_item_arr[$modifier_item['id']];

                        if(isset($custom_modifiers[$modifier_item['id']]['pre_item_names'])) {
                            foreach ($modifier_item['modifier_item_arr'] as $j => $modifier_item_arr_item) {
                                if (array_key_exists($modifier_item_arr_item['id'], $custom_modifiers[$modifier_item['id']]['pre_item_names'])) {
                                    $modifier_item['modifier_item_arr'][$j]['modifier_item_pre_name'] = $custom_modifiers[$modifier_item['id']]['pre_item_names'][$modifier_item_arr_item['id']];
                                } else {
                                    $modifier_item['modifier_item_arr'][$j]['modifier_item_pre_name'] = "";
                                }
                            }
                        }
                    }
                    $modifier[$i] = $modifier_item;
                }
                $modifier_arr[$k] = $modifier;
            }

            /*Custom combo_arr*/
            foreach ($combo_arr as $k => $combo) {
                foreach ($combo as $i => $combo_item) {
                    $combo_item['lst_products'] = array();
                    if (isset($combo_item_arr[$combo_item['id']])) {
                        $combo_item['lst_products'] = $combo_item_arr[$combo_item['id']];
                    }
                    unset($combo_item['product_id']);
                    $combo[$i] = $combo_item;
                }
                $combo_arr[$k] = $combo;
            }


            /*Custom products*/
            $custom_products = $this->getCustomProductsData();
            foreach ($arr as $k => $product) {
                $product['price_arr'] = array();
                $product['extra_arr'] = array();
                $product['group_arr'] = array();
                $product['modifier_arr'] = array();
                //$product['combo_arr'] = array();

                if (isset($extra_arr[$product['id']])) {
                    $product['extra_arr'] = $extra_arr[$product['id']];
                }
                if ($product['set_different_sizes'] == 'T' && isset($price_arr[$product['id']])) {
                    $product['price_arr'] = $price_arr[$product['id']];
                }
                if (isset($group_arr[$product['id']])) {
                    $product['group_arr'] = $group_arr[$product['id']];
                }
                if (isset($modifier_arr[$product['id']])) {
                    $product['modifier_arr'] = $modifier_arr[$product['id']];
                }
                if (isset($combo_arr[$product['id']])) {
                    $product['combo_arr'] = $combo_arr[$product['id']];
                }

                /*Chỉnh lại image path và thêm thuộc tính sản phẩm ở đây*/
                $product["crossAxisCellCount"] = $cross_axis_cell_count;
                $product["mainAxisCellCount"] = $main_axis_cell_count;
                $product["image"] = PJ_INSTALL_URL . $product["image"];

                if (array_key_exists($product['id'], $custom_products)) {
                    $product['pre_name'] = $custom_products[$product['id']]['pre_name'];
                    $product['printers'] = $custom_products[$product['id']]['printers'];
                } else {
                    $product['pre_name'] = "";
                    $product['printers'] = array();
                }

                $arr[$k] = $product;
            }
            return $arr;
        }
    }

    /*Để cài đặt plugin*/
    public function pjActionInstallPlugin()
    {

    }

    public function pjActionOrder()
    {
        $this->checkLogin();
        if ($this->isLoged()) {
            //$date_from = date('Y-m-d', strtotime(date('1-1-Y 0:0'))); //Đầu năm hiện tại
            $date_from = date('Y-m-d');
            $date_to = date('Y-m-d');
            $status_list = $this->getStatusList();

            $this->set('date_from', $date_from);
            $this->set('date_to', $date_to);
            $this->set('status_list', $status_list);

            $this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
            $this->appendJs('pjKioskOrder.js', $this->getConst('PLUGIN_JS_PATH'));
        } else {
            $this->set('status', 2);
        }
    }

    public function pjAjaxOrderList()
    {
        $this->checkLogin();
        $this->setAjax(true);
        if ($this->isXHR() && $this->isLoged()) {
            /*Khởi tạo đối tượng truy vấn*/
            $pjKioskOrderModel = pjKioskOrderModel::factory()
                ->where('t1.rid', $this->getForeignId())
                ->where('t1.kid', $this->getKioskId());

            if (isset($_GET['status']) && !empty($_GET['status'])) {
                $pjKioskOrderModel->where('t1.status', $_GET['status']);
            }

            if (isset($_GET['date_from']) && !empty($_GET['date_from']) && isset($_GET['date_to']) && !empty($_GET['date_to'])) {
                $date_from = pjUtil::formatDate($_GET['date_from'], $this->option_arr['o_date_format']);
                $date_to = pjUtil::formatDate($_GET['date_to'], $this->option_arr['o_date_format']);
                $pjKioskOrderModel->where("(DATE(createdTime) BETWEEN '$date_from' AND '$date_to')");
            } else if (isset($_GET['date_from']) && !empty($_GET['date_from'])) {
                $date_from = pjUtil::formatDate($_GET['date_from'], $this->option_arr['o_date_format']);
                $pjKioskOrderModel->where("(DATE(createdTime) >= '$date_from')");
            } else if (isset($_GET['date_to']) && !empty($_GET['date_to'])) {
                $date_to = pjUtil::formatDate($_GET['date_to'], $this->option_arr['o_date_format']);
                $pjKioskOrderModel->where("(DATE(createdTime) <= '$date_to')");
            }

            /*Mặc định sẽ sort theo createdTime DESC*/
            $column = 'createdTime';
            $direction = 'DESC';
            if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC'))) {
                $column = $_GET['column'];
                $direction = strtoupper($_GET['direction']);
            }

            $total = $pjKioskOrderModel->findCount()->getData();
            $rowCount = isset($_GET['rowCount']) && (int)$_GET['rowCount'] > 0 ? (int)$_GET['rowCount'] : 10;
            $pages = ceil($total / $rowCount);
            $page = isset($_GET['page']) && (int)$_GET['page'] > 0 ? intval($_GET['page']) : 1;
            $offset = ((int)$page - 1) * $rowCount;
            if ($page > $pages) {
                $page = $pages;
            }

            $data = $pjKioskOrderModel
                ->orderBy("$column $direction")
                ->limit($rowCount, $offset)
                ->findAll()
                ->getData();

            foreach ($data as $key => $value) {
                $color = "#39b2df";
                if ($value['status'] == 'Approved') {
                    $color = "#0da20d";
                } else if ($value['status'] == 'user cancel') {
                    $color = "#f6b234";
                } else if ($value['status'] == 'Error') {
                    $color = "#e33d3d";
                }

                $data[$key]['status'] = "<span style='background: $color; color: white; padding: 3px 5px; border-radius: 3px;'>" . $value['status'] . "</span>";
                $data[$key]['discount'] = pjUtil::formatCurrencySign($value['discount'], $this->option_arr['o_currency']);
                $data[$key]['tax'] = pjUtil::formatCurrencySign($value['tax'], $this->option_arr['o_currency']);
                $data[$key]['tip'] = pjUtil::formatCurrencySign($value['tip'], $this->option_arr['o_currency']);
                $data[$key]['totalPrice'] = "<div style='width: 50px; text-align: center; font-weight: bold; color: #de2b24; background: #fff2f2; padding: 3px 5px; border-radius: 3px; border: 1px #e88e8e solid;'>" . pjUtil::formatCurrencySign($value['totalPrice'], $this->option_arr['o_currency']) . "</div>";
                $data[$key]['detail'] = '<a target="_blank" href="' . $_SERVER['PHP_SELF'] . "?controller=pjKiosk&action=pjActionOrderDetail&id=" . $value['id'] . '&transactionId=' . $value['transactionId'] . '" class="detail">View</a>';
            }

            pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount'));
        }
    }

    public function pjActionOrderUpdate()
    {
        $this->checkLogin();
        if ($this->isLoged()) {
            if (isset($_POST['order_update']) && isset($_POST['id']) && isset($_POST['transactionId']) && isset($_POST['status'])) {
                $update = array();
                $update['status'] = $_POST['status'];

                pjKioskOrderModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($update);
                pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjKiosk&action=" . $_POST['next_action']);
            }
        }
    }

    public function pjActionOrderUpdateSignature()
    {
        $this->setAjax(true);
        $response = array();
        $response['code'] = 404;
        $response['message'] = 'Bad request';

        $body = json_decode(file_get_contents('php://input'), true);
        if (isset($body['rid'])
            && isset($body['kid'])
            && isset($body['deviceId'])
            && isset($body['transactionId'])
            && isset($body['signature'])
        ) {
            $update = array();
            $update['signature'] = $body['signature'];

            pjKioskOrderModel::factory()
                ->where('rid', $body['rid'])
                ->where('kid', $body['kid'])
                ->where('deviceId', $body['deviceId'])
                ->where('transactionId', $body['transactionId'])
                ->limit(1)
                ->modifyAll($update);

            $response['code'] = 200;
            $response['message'] = 'Success';
        }
        pjAppController::jsonResponse($response);
        exit;
    }

    public function pjActionOrderCreate()
    {
        $this->setAjax(true);
        $response = array();
        $response['code'] = 404;
        $response['message'] = 'Bad request';

        $body = json_decode(file_get_contents('php://input'), true);
        if (isset($body['rid'])
            && isset($body['kid'])
            && isset($body['deviceId'])
            && isset($body['transactionId'])
            && isset($body['numberOrder'])
            && isset($body['subTotal'])
            && isset($body['discount'])
            && isset($body['tax'])
            && isset($body['tip'])
            && isset($body['totalPrice'])
            && isset($body['data'])
            && isset($body['status'])
            && isset($body['extra'])
        ) {
            $ccfee = (isset($body['ccfee'])) ? $body['ccfee'] : 0;
            $phone = (isset($body['phone']) && !empty($body['phone'])) ? $body['phone'] : null;
            $note = (isset($body['note']) && !empty($body['note'])) ? $body['note'] : null;
            $status = $body['status'];
            if (!in_array($status, array("Approved", "Declined", "user cancel"))){
                $status="Error";
            }

            $kiosk = $this->getKioskById($body['kid']);
            $setting = $this->getConfigDataById($body['rid'], $body['kid']);

            $id = pjKioskOrderModel::factory()
                ->setAttributes(array(
                    'rid' => $body['rid'],
                    'kid' => $body['kid'],
                    'deviceId' => $body['deviceId'],
                    'transactionId' => $body['transactionId'],
                    'numberOrder' => $body['numberOrder'],
                    'subTotal' => $body['subTotal'],
                    'discount' => $body['discount'],
                    'tax' => $body['tax'],
                    'ccfee' => $ccfee,
                    'tip' => $body['tip'],
                    'totalPrice' => $body['totalPrice'],
                    'data' => json_encode($body['data'], JSON_UNESCAPED_UNICODE),
                    'extra' => json_encode($body['extra'], JSON_UNESCAPED_UNICODE),
                    'phone' => $phone,
                    'note' => $note,
                    'status' => $status,
                    'restaurantName' => $body['restaurantName'],
                    'type' => $body['type'],
                    'tent' => $body['tent']
                ))
                ->insert()
                ->getInsertId();
            $response['code'] = 200;
            $response['message'] = 'Success';

            /*Update other_fee theo ngày, nếu đã có thì overide luôn*/
            $config=$this->getConfigDataById($body['rid'], $body['kid']);
            if(isset($config) && isset($config['usaepay_fee_other'])) {
                $other_fee = (float)$config['usaepay_fee_other'];
            }else{
                $other_fee = 0.00;
            }
            $date=date('Y-m-d');
            $find=pjKioskOtherFeeModel::factory()
                    ->where('rid', $body['rid'])
                    ->where('kid', $body['kid'])
                    ->where('date', $date)
                    ->findCount()
                    ->getData();
            if(isset($find) & $find>0){
                $update = array();
                $update['other_fee'] = $other_fee;
                pjKioskOtherFeeModel::factory()
                        ->where('rid', $body['rid'])
                        ->where('kid', $body['kid'])
                        ->where('date', $date)
                        ->limit(1)
                        ->modifyAll($update);
            }else{
                $insert = array();
                $insert['rid'] = $body['rid'];
                $insert['kid'] = $body['kid'];
                $insert['date'] = $date;
                $insert['other_fee'] = $other_fee;
                pjKioskOtherFeeModel::factory()
                    ->setAttributes($insert)
                    ->insert();
            }

            try {
                if (isset($phone) && strlen($phone) > 8 && $status === 'Approved') {
                    $sms = $setting['SMS'];
                    if (isset($sms['Username']) && isset($sms['APIKey'])) {
                        $e_receipt = PJ_INSTALL_URL . "er-" . $id;
                        $sms_response = $this->sendSMS($body['numberOrder'], $kiosk['name'], $e_receipt, $phone, $sms['Username'], $sms['APIKey']);
                        $response['sms_response'] = json_decode($sms_response);
                    }
                }
            } catch (Exception $e) {
                pjAppController::jsonResponse($e->getMessage());
                exit;
            }
        }
        pjAppController::jsonResponse($response);
        exit;
    }

    private function sendSMS($order_number, $location, $e_receipt, $phone_number, $username, $apikey)
    {
        $config = ClickSend\Configuration::getDefaultConfiguration()
            ->setUsername($username)
            ->setPassword($apikey);

        $apiInstance = new ClickSend\Api\SMSApi(new GuzzleHttp\Client(), $config);
        $msg = new \ClickSend\Model\SmsMessage();
        $msg->setBody("Your order is confirmed! We're preparing your order now. Order#" . $order_number . ", location: " . $location . ". E-receipt: " . $e_receipt);
        //$msg->setBody("Your order is confirmed! We're preparing your order now. Order: ".$order_number);
        $msg->setTo($phone_number);
        $msg->setSource("sdk");

        $sms_messages = new \ClickSend\Model\SmsMessageCollection();
        $sms_messages->setMessages([$msg]);

        /*try {
          $result = $apiInstance->smsSendPost($sms_messages);
          print_r($result);
        } catch (Exception $e) {
          echo 'Exception when calling SMSApi->smsSendPost: ', $e->getMessage(), PHP_EOL;
        }*/
        $result = $apiInstance->smsSendPost($sms_messages);
        return $result;
    }

    public function pjActionSDPStatusPublic()
    {
        $this->setAjax(true);
        if (isset($_REQUEST['rid']) && isset($_REQUEST['kid']) && isset($_REQUEST['printer_id']) && isset($_REQUEST['device_id'])) {
            $rid = $_REQUEST['rid'];
            $kid = $_REQUEST['kid'];
            $printer_id = $_REQUEST['printer_id'];
            $device_id = $_REQUEST['device_id'];

            $folder = "files/" . $rid . "/" . $kid . "/printer";
            if (!file_exists($folder)) {
                mkdir($folder, 0777, true);
            }
            $file = $folder . "/result_status.log";
            $fhandle = @fopen($file, "wt");
            $status = $_POST["Status"];

            $xml = simplexml_load_string($status);
            foreach ($xml->printerstatus as $printerstatus) {
                $asb = hexdec($printerstatus['asbstatus']);
                $strmsg = "Ready";
                if (($asb & 0x00000001) == 0x00000001) {
                    $strmsg .= " No TM printer response\n";
                }
                if (($asb & 0x00000002) == 0x00000002) {
                    $strmsg .= " Print completed \n";
                }
                if (($asb & 0x00000004) == 0x00000004) {
                    $strmsg .= " Status of the drawer kick number 3 connector pin\n";
                }
                if (($asb & 0x00000008) == 0x00000008) {
                    $strmsg .= " Offline status \n";
                }
                if (($asb & 0x00000020) == 0x00000020) {
                    $strmsg .= " Cover is open \n";
                }
                if (($asb & 0x00000040) == 0x00000040) {
                    $strmsg .= " During paper feeding by pressing paper feed switch \n";
                }
                if (($asb & 0x00000100) == 0x00000100) {
                    $strmsg .= " Waiting for online recovery \n";
                }
                if (($asb & 0x00000200) == 0x00000200) {
                    $strmsg .= " Paper feed switch is being pressed (ON) \n";
                }
                if (($asb & 0x00000400) == 0x00000400) {
                    $strmsg .= " Mechanical error generated \n";
                }
                if (($asb & 0x00000800) == 0x00000800) {
                    $strmsg .= " Auto cutter error generated \n";
                }
                if (($asb & 0x00002000) == 0x00002000) {
                    $strmsg .= " Unrecoverable error generated \n";
                }
                if (($asb & 0x00004000) == 0x00004000) {
                    $strmsg .= " Auto recovery error generated \n";
                }
                if (($asb & 0x00020000) == 0x00020000) {
                    $strmsg .= " No paper in the roll paper near end detector \n";
                }
                if (($asb & 0x00080000) == 0x00080000) {
                    $strmsg .= " No paper in the roll paper end detector \n";
                }
                if (($asb & 0x80000000) == 0x80000000) {
                    $strmsg .= " Stop the spooler \n";
                }
                $result = fprintf($fhandle, "Printer name = %s : Status ASB value is %s \n", $printerstatus['devicename'], $asb);
                $result = fprintf($fhandle, "%s\n", $strmsg);
                if ($result) {
                    pjKioskOrderPrintModel::factory()->reset()->set('id', 1)->modify(array('message' => $strmsg));
                } else {
                    pjKioskOrderPrintModel::factory()->reset()->set('id', 1)->modify(array('message' => $strmsg));
                }
            }
            fclose($fhandle);
        }
        exit;
    }

    public function pjActionSDPPublic()
    {
        $this->setLayout('pjActionEmpty');
        header("HTTP/1.1 200 OK");
        header('Content-Type: text/xml; charset=UTF-8');

        if (isset($_REQUEST['rid']) && isset($_REQUEST['kid']) && isset($_REQUEST['printer_id']) && isset($_REQUEST['device_id']) && isset($_REQUEST["ConnectionType"]) && in_array($_REQUEST["ConnectionType"], array('GetRequest', 'SetResponse'))) {
            if ($_REQUEST["ConnectionType"] == 'GetRequest') {
                $rid = $_REQUEST['rid'];
                $kid = $_REQUEST['kid'];
                $printer_id = $_REQUEST['printer_id'];
                $device_id = $_REQUEST['device_id'];

                $data = pjKioskOrderPrintModel::factory()
                    ->where('rid', $rid)
                    ->where('kid', $kid)
                    ->where('printer_id', $printer_id)
                    ->where('status', 0)
                    ->where('createdTime >= DATE_SUB(NOW(), INTERVAL 1 HOUR)')
                    ->orderBy('createdTime', 'ASC')
                    ->limit(1)->findAll()->getDataIndex(0);

                if (isset($data) && isset($data['order_id'])) {
                    $order = pjKioskOrderModel::factory()->find($data['order_id'])->getData();
                    $kiosk = $this->getKioskById($data['kid']);
                    $printerInfo = $this->getPrinterById($rid, $kid, $printer_id);
                    $setting = $this->getSettingDataById($rid, $kid);

                    $this->set("order", $order);
                    $this->set("kiosk", $kiosk);
                    $this->set("printerInfo", $printerInfo);
                    $this->set("setting", $setting);
                    $this->set("device_id", $device_id);

                    pjKioskOrderPrintModel::factory()->reset()->set('id', $data['id'])->modify(array('status' => 1));
                }
            }
        }
    }

    private function getStatusList()
    {
        $status_list = [];
        $pjKiosOrderModel = pjKioskOrderModel::factory()->select("distinct(status)");
        $data = $pjKiosOrderModel->findAll()->getData();
        foreach ($data as $k => $v) {
            $status_list[] = $v['status'];
        }
        return $status_list;
    }

    public function pjActionOrderDetail()
    {
        $this->checkLogin();
        if ($this->isLoged()) {
            $status_list = $this->getStatusList();
            $detail = pjKioskOrderModel::factory()->find($_GET['id'])->getData();

            /*Get printers*/
            $config = $this->getConfigData();
            $printers = [];
            foreach ($config['printers'] as $key => $printer) {
                //if($printer['location']=='C'){
                $printers[] = $printer;
                //}
            }

            $this->set('printers', $printers);
            $this->set('status_list', $status_list);
            $this->set('detail', $detail);
        } else {
            $this->set('status', 2);
        }
    }

    /*Dùng in server direct print*/
    public function pjAjaxOrderPrintAddQueue()
    {
        $this->checkLogin();
        $this->setAjax(true);
        $status = "Error, please contact to administrator";

        if ($this->isXHR() && $this->isLoged() && ($this->isAdmin() || $this->isEditor() || $this->isManager()) && isset($_REQUEST['printer_id']) && isset($_REQUEST['order_id'])) {
            $printer_id = $_REQUEST['printer_id'];
            $order_id = $_REQUEST['order_id'];

            $id = pjKioskOrderPrintModel::factory()
                ->setAttributes(array(
                    'rid' => $this->getForeignId(),
                    'kid' => $this->getKioskId(),
                    'printer_id' => $printer_id,
                    'order_id' => $order_id,
                    'status' => 0
                ))
                ->insert()
                ->getInsertId();

            $status = "Already, the request had added in queue. Please check your printer!";
        }
        pjAppController::jsonResponse($status);
    }

    public function pjActionOrderCustomer()
    {
        $this->setLayout('pjActionEmpty');
        if (isset($_GET['id']) && empty($_GET['id']) == false) {
            $detail = pjKioskOrderModel::factory()->find($_GET['id'])->getData();
            $this->set('kiosk', $this->getKioskById($detail['kid']));
            $this->set('detail', $detail);
        } else if (isset($_GET['transactionId']) && empty($_GET['transactionId']) == false) {
            $detail = pjKioskOrderModel::factory()->where('transactionId', $_GET['transactionId'])->findAll()->getData();
            if (count($detail) > 0) {
                $detail = $detail[0];
            }
            $this->set('kiosk', $this->getKioskById($detail['kid']));
            $this->set('detail', $detail);
        } else {
            $this->set('error', 'bad_request');
        }
    }

    public function pjActionReport()
    {
        $this->checkLogin();
        if ($this->isLoged()) {
            //$date_from = date('Y-m-d', time() - 30 * 86400 ); // 30 ngày trước so với hiện tại
            //$date_from = date('Y-m-d', strtotime(date('1-1-Y 0:0'))); // Ngày đầu năm
            $date_from = date('Y-m-d');
            $date_to = date('Y-m-d');

            $this->set('date_from', $date_from);
            $this->set('date_to', $date_to);

            $this->appendJs('jquery.min.js', PJ_THIRD_PARTY_PATH . 'jquery/');
            $this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
            $this->appendJs('pjKioskReport.js', $this->getConst('PLUGIN_JS_PATH'));
        } else {
            $this->set('status', 2);
        }
    }


    public function pjActionReportGeneral()
    {
        $this->checkLogin();
        $this->setAjax(true);
        if ($this->isXHR()) {
            if (isset($_POST['generate_report'])) {

                $date_from = pjUtil::formatDate($_POST['date_from'], $this->option_arr['o_date_format']);
                $date_to = pjUtil::formatDate($_POST['date_to'], $this->option_arr['o_date_format']);

                $pjKiosOrderModel = pjKioskOrderModel::factory()->where('rid', $this->getForeignId());
                $pjKiosOrderModel->where('kid', $this->getKioskId());
                $pjKiosOrderModel->where("(DATE(createdTime) BETWEEN '$date_from' AND '$date_to')");
                $kiosOrderData = $pjKiosOrderModel->findAll()->getData();

                $total_orders = 0;
                $total_orders_confirmed = 0;
                $total_products_ordered = 0;
                $total_discount = 0;
                $total_tax = 0;
                $total_tip = 0;
                $total_amount = 0;

                $transaction_arr = array();
                $category_arr = array();
                $product_arr = array();

                foreach ($kiosOrderData as $key => $value) {
                    $total_orders++;

                    /*Chỉ lấy trạng thái Approved*/
                    if ($value['status'] == 'Approved') {
                        $total_orders_confirmed++;
                        $total_discount += (float)$value['discount'];
                        $total_tax += (float)$value['tax'];
                        $total_tip += (float)$value['tip'];
                        $total_amount += (float)$value['totalPrice'];

                        $products = json_decode(json_decode($value['data'], true), true);
                        foreach ($products as $k => $v) {
                            $total_products_ordered += (int)$v['QTY'];
                        }
                    }

                    $status = $value['status'];
                    $transaction = $transaction_arr[$status];
                    $transaction['status'] = $status;
                    $transaction['total_ordered'] = $transaction['total_ordered'] + 1;
                    $transaction['total_amount'] = $transaction['total_amount'] + (float)$value['totalPrice'];
                    $transaction_arr[$status] = $transaction;
                }
                $price = array_column($transaction_arr, 'total_amount');
                array_multisort($price, SORT_DESC, $transaction_arr);

                /*Category*/
                $pjCategoryModel = pjCategoryModel::factory()->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjCategory' AND t2.locale = '" . $this->getLocaleId() . "' AND t2.field = 'name'", 'left');
                $pjCategoryModel->where('t1.restaurant_id', $this->getForeignId());
                $categoriesData = $pjCategoryModel->select("t1.*, t2.content AS name")->findAll()->getData();
                foreach ($categoriesData as $key => $value) {
                    $category['id'] = $value['id'];
                    $category['name'] = $value['name'];
                    $category['total_ordered'] = 0;
                    $category['total_amount'] = 0;

                    $category_arr[$value['id']] = $category;
                }

                /*Product*/
                $pjProductModel = pjProductModel::factory()->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '" . $this->getLocaleId() . "' AND t2.field = 'name'", 'left');
                $pjProductModel->where('t1.restaurant_id', $this->getForeignId());
                $productsData = $pjProductModel->select("t1.*, t2.content AS name")->findAll()->getData();
                foreach ($productsData as $key => $value) {
                    $product['id'] = $value['id'];
                    $product['name'] = $value['name'];
                    $product['total_ordered'] = 0;
                    $product['total_amount'] = 0;

                    $product_arr[$value['id']] = $product;
                }

                /*Tổng hợp - Lặp danh sách transactions*/
                foreach ($kiosOrderData as $key => $value) {
                    /*Chỉ lấy trạng thái Approved*/
                    if ($value['status'] == 'Approved') {
                        $products = json_decode(json_decode($value['data'], true), true);
                        foreach ($products as $k => $v) {
                            $product_id = $k;
                            if (array_key_exists($product_id, $product_arr)) {
                                $product = $product_arr[$product_id];
                                $product['total_ordered'] = $product['total_ordered'] + (int)$v['QTY'];
                                $product['total_amount'] = $product['total_amount'] + (float)$v['TOTAL'];
                                $product_arr[$product_id] = $product;
                            }

                            $category_id = $v['category_id'];
                            if (array_key_exists($category_id, $category_arr)) {
                                $category = $category_arr[$category_id];
                                $category['total_ordered'] = $category['total_ordered'] + (int)$v['QTY'];
                                $category['total_amount'] = $category['total_amount'] + (float)$v['TOTAL'];
                                $category_arr[$category_id] = $category;
                            }
                        }
                    }
                }

                /*Sort*/
                $price = array_column($product_arr, 'total_amount');
                array_multisort($price, SORT_DESC, $product_arr);

                $price = array_column($category_arr, 'total_amount');
                array_multisort($price, SORT_DESC, $category_arr);

                $this->set('total_orders', $total_orders);
                $this->set('total_orders_confirmed', $total_orders_confirmed);
                $this->set('total_products_ordered', $total_products_ordered);
                $this->set('total_discount', $total_discount);
                $this->set('total_tax', $total_tax);
                $this->set('total_tip', $total_tip);
                $this->set('total_amount', $total_amount);

                $this->set('transaction_arr', $transaction_arr);
                $this->set('category_arr', $category_arr);
                $this->set('product_arr', $product_arr);

                $this->set('date_from',$date_from);
                $this->set('date_to', $date_to);
            }
        }
    }

    public function pjActionReportSettlement()
    {
        $this->checkLogin();
        if ($this->isLoged()) {
            $date_from = date('Y-m-d');
            $date_to = date('Y-m-d');

            if(isset($_SESSION['report_settlement_'.$this->getForeignId()])){
                $date_from = $date_to = $_SESSION['report_settlement_'.$this->getForeignId()];
            }

            $this->set('date_from', $date_from);
            $this->set('date_to', $date_to);

            $this->appendJs('jquery.min.js', PJ_THIRD_PARTY_PATH . 'jquery/');
            $this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
            $this->appendJs('pjKioskReportSettlement.js', $this->getConst('PLUGIN_JS_PATH'));
        } else {
            $this->set('status', 2);
        }
    }

    public function pjActionReportSettlementGeneral()
    {
        $this->checkLogin();
        $this->setAjax(true);
        if ($this->isXHR()) {
            if (isset($_POST['generate_report'])) {
                $rid=$this->getForeignId();
                $kid=$this->getKioskId();

                /*Restaurant*/
                $restaurant = pjRestaurantModel::factory()->find($rid)->getData();
                $restaurant_languages = pjMultiLangModel::factory()->getMultiLang($restaurant['id'], 'pjRestaurant');
                $date_from = pjUtil::formatDate($_POST['date_from'], $this->option_arr['o_date_format']);

                $_SESSION['report_settlement_'.$rid]=$date_from;

                /*Kiosk Orders*/
                $pjKiosOrderModel = pjKioskOrderModel::factory()->where('rid', $rid);
                $pjKiosOrderModel->where('kid', $kid);
                $pjKiosOrderModel->where("(DATE(createdTime) = '$date_from')");
                $pjKiosOrderModel->where('status','Approved');
                $kiosOrderData = $pjKiosOrderModel->findAll()->getData();

                $total_orders = 0;
                $total_discount = 0;
                $total_tax = 0;
                $total_ccfee = 0;
                $total_tip = 0;
                $total_amount = 0;

                $card_arr = array();
                foreach ($kiosOrderData as $key => $value) {
                    $extra = json_decode(json_decode($value['extra'], true), true);
                    $card="UNKNOWN";
                    if(isset($extra) && isset($extra['emv_application_label'])){
                        $card = $extra['emv_application_label'];
                    } else if(isset($extra) && isset($extra['emv_application_preferred_name'])){
                        $card = $extra['emv_application_preferred_name'];
                    }

                    $total_orders++;

                    $total_discount += (float)$value['discount'];
                    $total_tax += (float)$value['tax'];
                    $total_ccfee += (float)$value['ccfee'];
                    $total_tip += (float)$value['tip'];
                    $total_amount += (float)$value['totalPrice'];

                    $card_info = $card_arr[$card];
                    $card_info['name'] = $card;
                    $card_info['type'] = 'Sale';
                    $card_info['count'] = $card_info['count'] + 1;
                    $card_info['amount'] = $card_info['amount'] + (float)$value['totalPrice'];
                    $card_arr[$card] = $card_info;
                }
                $card_name = array_column($card_arr, 'name');
                array_multisort($card_name, SORT_DESC, $card_arr);

                $total_sale=$total_amount;
                $merchant_fee=0.0;
                $other_fee=0.0;
                $deposit_amount=0.0;
                if($total_sale>0){
                    $merchant_fee=$total_ccfee;

                    $find=pjKioskOtherFeeModel::factory()
                        ->where('rid', $rid)
                        ->where('kid', $kid)
                        ->where('date', $date_from)
                        ->limit(1)
                        ->findAll()
                        ->getData();
                    if(isset($find) && isset($find[0]['other_fee'])) {
                        $other_fee = (float)$find[0]['other_fee'];
                    }
                    $deposit_amount=$total_sale - $merchant_fee - $other_fee;
                }
                $this->set('card_arr', $card_arr);
                $this->set('total_sale', $total_sale);
                $this->set('merchant_fee', $merchant_fee);
                $this->set('other_fee', $other_fee);
                $this->set('deposit_amount', $deposit_amount);

                $this->set('total_orders', $total_orders);
                $this->set('total_discount', $total_discount);
                $this->set('total_tax', $total_tax);
                $this->set('total_tip', $total_tip);
                $this->set('total_amount', $total_amount);
                $this->set('date_from',$date_from);
                $this->set('kid',$kid);
                $this->set('res_name',$restaurant_languages[1]['name']);

                /*summary other kiosks*/
                $data = pjKioskModel::factory()->where('t1.rid', $this->getForeignId())->findAll()->getData();
                if(count($data)>1) {
                    foreach ($data as $k => $kiosk) {
                        $data[$k]['settlement'] = $this->calculatorReportSettlementForKiosks($rid, $kiosk['id'], $date_from);
                    }
                    $this->set('all_kiosks', $data);
                }
            }
        }
    }

    private function calculatorReportSettlementForKiosks($rid, $kid, $date_from){
        /*Kiosk Orders*/
        $pjKiosOrderModel = pjKioskOrderModel::factory()->where('rid', $rid);
        $pjKiosOrderModel->where('kid', $kid);
        $pjKiosOrderModel->where("(DATE(createdTime) = '$date_from')");
        $pjKiosOrderModel->where('status','Approved');
        $kiosOrderData = $pjKiosOrderModel->findAll()->getData();

        $total_orders = 0;
        $total_discount = 0;
        $total_tax = 0;
        $total_ccfee = 0;
        $total_tip = 0;
        $total_amount = 0;

        $card_arr = array();
        foreach ($kiosOrderData as $key => $value) {
            $extra = json_decode(json_decode($value['extra'], true), true);
            $card="UNKNOWN";
            if(isset($extra) && isset($extra['emv_application_label'])){
                $card = $extra['emv_application_label'];
            } else if(isset($extra) && isset($extra['emv_application_preferred_name'])){
                $card = $extra['emv_application_preferred_name'];
            }

            $total_orders++;

            $total_discount += (float)$value['discount'];
            $total_tax += (float)$value['tax'];
            $total_ccfee += (float)$value['ccfee'];
            $total_tip += (float)$value['tip'];
            $total_amount += (float)$value['totalPrice'];

            $card_info = $card_arr[$card];
            $card_info['name'] = $card;
            $card_info['type'] = 'Sale';
            $card_info['count'] = $card_info['count'] + 1;
            $card_info['amount'] = $card_info['amount'] + (float)$value['totalPrice'];
            $card_arr[$card] = $card_info;
        }
        $card_name = array_column($card_arr, 'name');
        array_multisort($card_name, SORT_DESC, $card_arr);

        $total_sale=$total_amount;
        $merchant_fee=0.0;
        $other_fee=0.0;
        $deposit_amount=0.0;
        if($total_sale>0){
            $merchant_fee=$total_ccfee;

            $find=pjKioskOtherFeeModel::factory()
                ->where('rid', $rid)
                ->where('kid', $kid)
                ->where('date', $date_from)
                ->limit(1)
                ->findAll()
                ->getData();
            if(isset($find) && isset($find[0]['other_fee'])) {
                $other_fee = (float)$find[0]['other_fee'];
            }
            $deposit_amount=$total_sale - $merchant_fee - $other_fee;
        }

        $result['card_arr']=$card_arr;
        $result['total_sale']=$total_sale;
        $result['merchant_fee']=$merchant_fee;
        $result['other_fee']=$other_fee;
        $result['deposit_amount']=$deposit_amount;

        $result['total_orders']=$total_orders;
        $result['total_discount']=$total_discount;
        $result['total_tax']=$total_tax;
        $result['total_tip']=$total_tip;
        $result['total_amount']=$total_amount;
        $result['date_from']=$date_from;
        $result['kid']=$kid;

        return $result;
    }

    public function pjActionExportReport(){
        $this->checkLogin();

        if ($this->isAdmin() || $this->isEditor() || $this->isManager())
        {
            $this->setLayout('pjActionPrintNormal');
            $this->_pjActionExportReport('detail');
        } else {
            $this->set('status', 2);
        }
    }

    private function _pjActionExportReport($type){
        if ($type=='detail') {
            $date_from = $_REQUEST['date_from'];
            $date_to = $_REQUEST['date_to'];
            $date_current = date('m-d-Y H:i:s');

            /*Restaurant*/
            $restaurant = pjRestaurantModel::factory()->find( $this->getForeignId())->getData();
            $restaurant_languages = pjMultiLangModel::factory()->getMultiLang($restaurant['id'], 'pjRestaurant');

            $pjKiosOrderModel = pjKioskOrderModel::factory()->where('rid', $this->getForeignId());
            $pjKiosOrderModel->where('kid', $this->getKioskId());
            $pjKiosOrderModel->where("(DATE(createdTime) BETWEEN '$date_from' AND '$date_to')");
            $kiosOrderData = $pjKiosOrderModel->findAll()->getData();

            $total_orders = 0;
            $total_orders_confirmed = 0;
            $total_products_ordered = 0;
            $total_discount = 0;
            $total_tax = 0;
            $total_tip = 0;
            $total_amount = 0;

            $transaction_arr = array();
            $category_arr = array();
            $product_arr = array();

            foreach ($kiosOrderData as $key => $value) {
                $total_orders++;

                /*Chỉ lấy trạng thái Approved*/
                if ($value['status'] == 'Approved') {
                    $total_orders_confirmed++;
                    $total_discount += (float)$value['discount'];
                    $total_tax += (float)$value['tax'];
                    $total_tip += (float)$value['tip'];
                    $total_amount += (float)$value['totalPrice'];

                    $products = json_decode(json_decode($value['data'], true), true);
                    foreach ($products as $k => $v) {
                        $total_products_ordered += (int)$v['QTY'];
                    }
                }

                $status = $value['status'];
                $transaction = $transaction_arr[$status];
                $transaction['status'] = $status;
                $transaction['total_ordered'] = $transaction['total_ordered'] + 1;
                $transaction['total_amount'] = $transaction['total_amount'] + (float)$value['totalPrice'];
                $transaction_arr[$status] = $transaction;
            }
            $price = array_column($transaction_arr, 'total_amount');
            array_multisort($price, SORT_DESC, $transaction_arr);

            /*Category*/
            $pjCategoryModel = pjCategoryModel::factory()->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjCategory' AND t2.locale = '" . $this->getLocaleId() . "' AND t2.field = 'name'", 'left');
            $pjCategoryModel->where('t1.restaurant_id', $this->getForeignId());
            $categoriesData = $pjCategoryModel->select("t1.*, t2.content AS name")->findAll()->getData();
            foreach ($categoriesData as $key => $value) {
                $category['id'] = $value['id'];
                $category['name'] = $value['name'];
                $category['total_ordered'] = 0;
                $category['total_amount'] = 0;

                $category_arr[$value['id']] = $category;
            }

            /*Product*/
            $pjProductModel = pjProductModel::factory()->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '" . $this->getLocaleId() . "' AND t2.field = 'name'", 'left');
            $pjProductModel->where('t1.restaurant_id', $this->getForeignId());
            $productsData = $pjProductModel->select("t1.*, t2.content AS name")->findAll()->getData();
            foreach ($productsData as $key => $value) {
                $product['id'] = $value['id'];
                $product['name'] = $value['name'];
                $product['total_ordered'] = 0;
                $product['total_amount'] = 0;

                $product_arr[$value['id']] = $product;
            }

            /*Tổng hợp - Lặp danh sách transactions*/
            foreach ($kiosOrderData as $key => $value) {
                /*Chỉ lấy trạng thái Approved*/
                if ($value['status'] == 'Approved') {
                    $products = json_decode(json_decode($value['data'], true), true);
                    foreach ($products as $k => $v) {
                        $product_id = $k;
                        if (array_key_exists($product_id, $product_arr)) {
                            $product = $product_arr[$product_id];
                            $product['total_ordered'] = $product['total_ordered'] + (int)$v['QTY'];
                            $product['total_amount'] = $product['total_amount'] + (float)$v['TOTAL'];
                            $product_arr[$product_id] = $product;
                        }

                        $category_id = $v['category_id'];
                        if (array_key_exists($category_id, $category_arr)) {
                            $category = $category_arr[$category_id];
                            $category['total_ordered'] = $category['total_ordered'] + (int)$v['QTY'];
                            $category['total_amount'] = $category['total_amount'] + (float)$v['TOTAL'];
                            $category_arr[$category_id] = $category;
                        }
                    }
                }
            }

            /*Sort*/
            $price = array_column($product_arr, 'total_amount');
            array_multisort($price, SORT_DESC, $product_arr);

            $price = array_column($category_arr, 'total_amount');
            array_multisort($price, SORT_DESC, $category_arr);

            $this->set('total_orders', $total_orders);
            $this->set('total_orders_confirmed', $total_orders_confirmed);
            $this->set('total_products_ordered', $total_products_ordered);
            $this->set('total_discount', $total_discount);
            $this->set('total_tax', $total_tax);
            $this->set('total_tip', $total_tip);
            $this->set('total_amount', $total_amount);

            $this->set('transaction_arr', $transaction_arr);
            $this->set('category_arr', $category_arr);
            $this->set('product_arr', $product_arr);

            $this->set('date_from',$date_from);
            $this->set('date_to', $date_to);
            $this->set('date_current', $date_current);
            $this->set('restaurant_languages', $restaurant_languages[1]['name']);
        }
    }

    public function pjActionCustomProducts()
    {
        $this->checkLogin();
        $this->checkAccess();
        if ($this->isLoged() && ($this->isAdmin() || $this->isEditor()) && $this->getKioskId() > 0) {

            /*Nếu có cập nhật custom products*/
            if (isset($_POST['update'])) {
                /*Read custom products*/
                $custom_products = $this->getCustomProductsData();

                $product_ids = $_POST['product_ids'];
                $pre_names = $_POST['pre_names'];
                $printers_id = $_POST['printers_id'];

                foreach ($product_ids as $k => $id) {
                    $item = [];
                    $item['pre_name'] = $pre_names[$id];

                    if (count($printers_id[$id]) > 0) {
                        $item['printers'] = array_keys($printers_id[$id]);
                    } else {
                        $item['printers'] = array();
                    }

                    $custom_products[$id] = $item;
                }

                /*Ghi lại*/
                $this->setCustomProductsData($custom_products);
            }

            /*Get catetories*/
            $pjCategoryModel = pjCategoryModel::factory()->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjCategory' AND t2.locale = '" . $this->getLocaleId() . "' AND t2.field = 'name'", 'left');
            $pjCategoryModel->where('t1.restaurant_id', $this->getForeignId());
            $categories = $pjCategoryModel
                ->select('t1.*, t2.content AS name, (SELECT COUNT(TPC.product_id) FROM `' . pjProductCategoryModel::factory()->getTable() . '` AS TPC WHERE TPC.category_id=t1.id) AS cnt_products')
                ->findAll()
                ->getData();
            $this->set('categories', $categories);

            /*Get products*/
            $categoryId = $_GET['categoryId'];
            $products = array();
            if (isset($categoryId) && $categoryId > 0) {
                $products = $this->getProductByCategory($categoryId, $this->getForeignId(), $this->getLocaleId(), 1, 1);
            } else {
                foreach ($categories as $key => $category) {
                    $_products = $this->getProductByCategory($category['id'], $this->getForeignId(), $this->getLocaleId(), 1, 1);
                    foreach ($_products as $k => $product) {
                        if (array_key_exists($product['id'], $products)) {

                        } else {
                            $products[$product['id']] = $product;
                        }
                    }
                }
            }

            $this->set('categoryId', $categoryId);
            $this->set('products', $products);

            /*Get printers*/
            $config = $this->getConfigData();
            $printers = [];
            foreach ($config['printers'] as $key => $printer) {
                if ($printer['location'] == 'K') {
                    $printers[] = $printer;
                }
            }
            $this->set('printers', $printers);
        }
    }

    public function pjActionCustomExtras()
    {
        $this->checkLogin();
        $this->checkAccess();
        if ($this->isLoged() && ($this->isAdmin() || $this->isEditor()) && $this->getKioskId() > 0) {
            /*Read custom extras*/
            $custom_extras = $this->getCustomExtrasData();

            /*Nếu có cập nhật custom products*/
            if (isset($_POST['update'])) {
                $extra_ids = $_POST['extra_ids'];
                $pre_names = $_POST['pre_names'];
                $printers_id = $_POST['printers_id'];

                foreach ($extra_ids as $k => $id) {
                    $item = [];
                    $item['pre_name'] = $pre_names[$id];
                    if (count($printers_id[$id]) > 0) {
                        $item['printers'] = array_keys($printers_id[$id]);
                    } else {
                        $item['printers'] = array();
                    }
                    $custom_extras[$id] = $item;
                }

                /*Ghi lại*/
                $this->setCustomExtrasData($custom_extras);
            }

            /*Get extras*/
            $extras = pjExtraModel::factory()->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjExtra' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
                ->where('t1.restaurant_id', $this->getForeignId())
                ->select('t1.*, t2.content AS name, (SELECT COUNT(t3.product_id) FROM `'.pjProductExtraModel::factory()->getTable().'` AS t3 WHERE t3.extra_id=t1.id) as products')
                ->orderBy("name ASC")
                ->findAll()
                ->getData();
            foreach($extras as $key => $extra){
                if (array_key_exists($extra['id'], $custom_extras)) {
                    $extra['pre_name'] = $custom_extras[$extra['id']]['pre_name'];
                    $extra['printers'] = $custom_extras[$extra['id']]['printers'];
                } else {
                    $extra['pre_name'] = "";
                    $extra['printers'] = array();
                }
                $extras[$key] = $extra;
            }

            /*Get printers*/
            $config = $this->getConfigData();
            $printers = [];
            foreach ($config['printers'] as $key => $printer) {
                if ($printer['location'] == 'K') {
                    $printers[] = $printer;
                }
            }

            $this->set('extras', $extras);
            $this->set('printers', $printers);
        }
    }

    public function pjActionCustomModifiers()
    {
        $this->checkLogin();
        $this->checkAccess();
        if ($this->isLoged() && ($this->isAdmin() || $this->isEditor()) && $this->getKioskId() > 0) {
            /*Read custom extras*/
            $custom_modifiers = $this->getCustomModifiersData();

            /*Nếu có cập nhật custom products*/
            if (isset($_POST['update'])) {
                $modifier_ids = $_POST['modifier_ids'];
                $pre_names = $_POST['pre_names'];
                $pre_item_names = $_POST['pre_item_names'];
                $printers_id = $_POST['printers_id'];

                foreach ($modifier_ids as $k => $id) {
                    $item = [];
                    $item['pre_name'] = $pre_names[$id];
                    $item['pre_item_names'] = $pre_item_names[$id];
                    if (count($printers_id[$id]) > 0) {
                        $item['printers'] = array_keys($printers_id[$id]);
                    } else {
                        $item['printers'] = array();
                    }
                    $custom_modifiers[$id] = $item;
                }

                /*Ghi lại*/
                $this->setCustomModifiersData($custom_modifiers);
            }

            /*Get modifiers*/
            $modifiers = pjModifierModel::factory()->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjModifier' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
                ->where('t1.restaurant_id', $this->getForeignId())
                ->select('t1.*, t2.content AS name, (SELECT COUNT(t3.product_id) FROM `'.pjProductModifierModel::factory()->getTable().'` AS t3 WHERE t3.modifier_id=t1.id) as products')
                ->orderBy("name ASC")
                ->findAll()
                ->getData();

            foreach($modifiers as $key => $modifier){
                $item_arr = pjModifierItemModel::factory()->where('modifier_id', $modifier['id'])->findAll()->getData();
                foreach($item_arr as $k => $v)
                {
                    $item_arr[$k]['name'] = pjMultiLangModel::factory()->getMultiLang($v['id'], 'pjModifierItem')[1]['item_name'];
                    if (array_key_exists($v['id'], $custom_modifiers[$modifier['id']]['pre_item_names'])) {
                        $item_arr[$k]['pre_name'] = $custom_modifiers[$modifier['id']]['pre_item_names'][$v['id']];
                    } else {
                        $item_arr[$k]['pre_name'] = "";
                    }
                }
                $modifier['item_arr'] = $item_arr;

                if (array_key_exists($modifier['id'], $custom_modifiers)) {
                    $modifier['pre_name'] = $custom_modifiers[$modifier['id']]['pre_name'];
                    $modifier['printers'] = $custom_modifiers[$modifier['id']]['printers'];
                } else {
                    $modifier['pre_name'] = "";
                    $modifier['printers'] = array();
                }
                $modifiers[$key] = $modifier;
            }

            /*Get printers*/
            $config = $this->getConfigData();
            $printers = [];
            foreach ($config['printers'] as $key => $printer) {
                if ($printer['location'] == 'K') {
                    $printers[] = $printer;
                }
            }

            $this->set('modifiers', $modifiers);
            $this->set('printers', $printers);
        }
    }

    public function pjActionAddPromo()
    {
        $this->setAjax(true);
        $response = array();
        $response['code'] = 404;
        $response['message'] = 'Bad request';

        $body = json_decode(file_get_contents('php://input'), true);
        if (isset($body['rid']) && isset($body['code'])) {

            $_arr = pjVoucherModel::factory()
                ->where('code', $body['code'])
                ->where('t1.restaurant_id', (int)$body['rid'])
                ->findAll()
                ->getData();

            if (count($_arr) > 0) {
                $arr = $_arr[0];

                $date = date('Y-m-d');
                $time = "00:00:00";

                $d = strtotime($date);
                $dt = strtotime($date . " " . $time);

                $valid = false;
                switch ($arr['valid']) {
                    case 'fixed':
                        $time_from = strtotime($arr['date_from'] . " " . $arr['time_from']);
                        $time_to = strtotime($arr['date_to'] . " " . $arr['time_to']);
                        if ($time_from <= $dt && $time_to >= $dt) {
                            $valid = true;
                        }
                        break;
                    case 'period':
                        $d_from = strtotime($arr['date_from']);
                        $d_to = strtotime($arr['date_to']);
                        $t_from = strtotime($arr['date_from'] . " " . $arr['time_from']);
                        $t_to = strtotime($arr['date_to'] . " " . $arr['time_to']);
                        if ($d_from <= $d && $d_to >= $d && $t_from <= $dt && $t_to >= $dt) {
                            $valid = true;
                        }
                        break;
                    case 'recurring':
                        $t_from = strtotime($date . " " . $arr['time_from']);
                        $t_to = strtotime($date . " " . $arr['time_to']);
                        if ($arr['every'] == strtolower(date("l", $dt)) && $t_from <= $dt && $t_to >= $dt) {
                            $valid = true;
                        }
                        break;
                }

                if ($valid) {
                    $result['voucher_code'] = $arr['code'];
                    $result['voucher_type'] = $arr['type'];
                    $result['voucher_discount'] = $arr['discount'];

                    $response['code'] = 200;
                    $response['message'] = 'Success';
                    $response['result'] = $result;
                } else {
                    $response['code'] = 406;
                    $response['message'] = 'Invalid';
                }
            } else {
                $response['code'] = 404;
                $response['message'] = 'Not found';
            }
        }
        pjAppController::jsonResponse($response);
        exit;
    }

    /*Phương thức này sẽ áp dụng cho các nhà hàng với orders trước đó, nên chạy 1 lần để cập nhật khi bổ sung chức năng Settlement Report*/
    public function pjActionUpdateOtherFeeForDayHistory(){
        $this->checkLogin();
        if ($this->isAdmin()) {
            $orders = pjKioskOrderModel::factory()
                ->select('rid, kid, createdTime')
                ->where('status', 'Approved')
                ->orderBy("createdTime ASC")
                ->findAll()
                ->getData();

            foreach ($orders as $key => $value) {
                $rid=$value['rid'];
                $kid=$value['kid'];
                $date=date('Y-m-d', strtotime($value['createdTime']));

                $config=$this->getConfigDataById($rid, $kid);
                if(isset($config) && isset($config['usaepay_fee_other'])) {
                    $other_fee = (float)$config['usaepay_fee_other'];
                }else{
                    $other_fee = 0.00;
                }
                $find=pjKioskOtherFeeModel::factory()
                    ->where('rid', $rid)
                    ->where('kid', $kid)
                    ->where('date', $date)
                    ->findCount()
                    ->getData();
                if(isset($find) & $find>0){
                    $update = array();
                    $update['other_fee'] = $other_fee;
                    pjKioskOtherFeeModel::factory()
                        ->where('rid', $rid)
                        ->where('kid', $kid)
                        ->where('date', $date)
                        ->limit(1)
                        ->modifyAll($update);
                }else{
                    $insert = array();
                    $insert['rid'] = $rid;
                    $insert['kid'] = $kid;
                    $insert['date'] = $date;
                    $insert['other_fee'] = $other_fee;
                    pjKioskOtherFeeModel::factory()
                        ->setAttributes($insert)
                        ->insert();
                }
            }
        }
        exit;
    }
}

?>
