<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjOrderModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'orders';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'restaurant_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'uuid', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'client_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'location_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'type', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'status', 'type' => 'enum', 'default' => 'pending'),
		array('name' => 'payment_method', 'type' => 'enum', 'default' => 'none'),
		array('name' => 'is_paid', 'type' => 'tinyint', 'default' => 0),
		array('name' => 'txn_id', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'processed_on', 'type' => 'datetime', 'default' => ':NULL'),
		array('name' => 'ip', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'price', 'type' => 'decimal', 'default' => ':NULL'),
		array('name' => 'price_delivery', 'type' => 'decimal', 'default' => ':NULL'),
		array('name' => 'catering_fee', 'type' => 'decimal', 'default' => ':NULL'),
		array('name' => 'discount', 'type' => 'decimal', 'default' => ':NULL'),
		array('name' => 'subtotal', 'type' => 'decimal', 'default' => ':NULL'),
		array('name' => 'tax', 'type' => 'decimal', 'default' => ':NULL'),
		array('name' => 'service_fee', 'type' => 'decimal', 'default' => ':NULL'),
		array('name' => 'total', 'type' => 'decimal', 'default' => ':NULL'),
		array('name' => 'tip_percentage', 'type' => 'decimal', 'default' => ':NULL'),
		array('name' => 'tip_amount', 'type' => 'decimal', 'default' => ':NULL'),
		array('name' => 'tip_option', 'type' => 'tinyint', 'default' => '0'),
	    array('name' => 'dasher_tip_amount', 'type' => 'decimal', 'default' => '0'),
	    array('name' => 'num_of_recall_dasher', 'type' => 'smallint', 'default' => '0'),
		array('name' => 'voucher_code', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'created', 'type' => 'datetime', 'default' => ':NOW()'),
		array('name' => 'p_dt', 'type' => 'datetime', 'default' => ':NULL'),
		array('name' => 'p_asap', 'type' => 'enum', 'default' => 'F'),
		array('name' => 'p_notes', 'type' => 'tinytext', 'default' => ':NULL'),
		array('name' => 'd_address_1', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'd_address_2', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'd_country_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'd_state', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'd_city', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'd_zip', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'd_notes', 'type' => 'tinytext', 'default' => ':NULL'),
		array('name' => 'd_dt', 'type' => 'datetime', 'default' => ':NULL'),
		array('name' => 'd_asap', 'type' => 'enum', 'default' => 'F'),
		array('name' => 'ca_address_1', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'ca_address_2', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'ca_country_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'ca_state', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'ca_city', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'ca_zip', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'ca_notes', 'type' => 'tinytext', 'default' => ':NULL'),
		array('name' => 'ca_dt', 'type' => 'datetime', 'default' => ':NULL'),
		array('name' => 'ca_asap', 'type' => 'enum', 'default' => 'F'),
		array('name' => 'cc_type', 'type' => 'blob', 'default' => ':NULL', 'encrypt' => 'AES'),
		array('name' => 'cc_num', 'type' => 'blob', 'default' => ':NULL', 'encrypt' => 'AES'),
		array('name' => 'cc_exp', 'type' => 'blob', 'default' => ':NULL', 'encrypt' => 'AES'),
		array('name' => 'cc_code', 'type' => 'blob', 'default' => ':NULL', 'encrypt' => 'AES'),
		
		array('name' => 'is_dashdoor_delivery', 'type' => 'tinyint', 'default' => '0'),
		array('name' => 'external_delivery_id', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'dasher_name', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'dasher_dropoff_phone_number', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'dasher_pickup_phone_number', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'dasher_vehicle_make', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'dasher_vehicle_model', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'dasher_vehicle_year', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'delivery_status', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'receive_sms_messages', 'type' => 'tinyint', 'default' => '0'),
		array('name' => 'sent_to_remote_printer', 'type' => 'enum', 'default' => 'F'),

        //Khuetech thêm thời gian yêu cầu sent_to_remote_printer_time để ghi nhận và in lại nhưng đơn yêu cầu trong 1 giờ trở lại
        array('name' => 'sent_to_remote_printer_time', 'type' => 'enum', 'default' => ':NOW()')
	);
	
	public static function factory($attr=array())
	{
		return new pjOrderModel($attr);
	}
}
?>