<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjDateWTModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'dates_wt';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'location_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'date_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'type', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'date', 'type' => 'date', 'default' => ':NULL'),
		array('name' => 'start_time', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'end_time', 'type' => 'time', 'default' => ':NULL')
	);
	
	public static function factory($attr=array())
	{
		return new pjDateWTModel($attr);
	}
	
	public function getWorkingTime($date, $location_id, $type)
	{
		$arr = $this->reset()
			->where('t1.date', $date)
			->where('t1.location_id', $location_id)
			->where('t1.type', $type)
			->limit(1)
			->orderBy("t1.start_time ASC")
			->findAll()
			->getData();
			
		if (count($arr) == 0)
		{
			return false;
		}
		
		$wt = array();
		$d = getdate(strtotime($arr[0]['start_time']));
		$wt['start_hour'] = $d['hours'];
		$wt['start_minutes'] = $d['minutes'];
	
		$d = getdate(strtotime($arr[0]['end_time']));
		$wt['end_hour'] = $d['hours'];
		$wt['end_minutes'] = $d['minutes'];
		
		$wt['start_ts'] = strtotime($date . " " . $arr[0]['start_time']);
		$wt['end_ts'] = strtotime($date . " " . $arr[0]['end_time']);
		
		return $wt;
	}
}
?>