<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAppController extends pjController
{
	public $models = array();
	
	public $defaultLocale = 'admin_locale_id';
	public $defaultRestaurantId = 'admin_restaurant_id';
	
	public $defaultFields = 'fields';
	
	public $defaultFieldsIndex = 'fields_index';
	
	public $smsServiceProvider = 'clicksend';
  
	protected function loadSetFields($force=FALSE, $locale_id=NULL, $fields=NULL)
	{
		if (is_null($locale_id))
		{
			$locale_id = $this->getLocaleId();
		}
		
		if (is_null($fields))
		{
			$fields = $this->defaultFields;
		}
		
		$registry = pjRegistry::getInstance();
		if ($force
				|| !isset($_SESSION[$this->defaultFieldsIndex])
				|| $_SESSION[$this->defaultFieldsIndex] != $this->option_arr['o_fields_index']
				|| !isset($_SESSION[$fields])
				|| empty($_SESSION[$fields]))
		{
			pjAppController::setFields($locale_id);
	
			# Update session
			if ($registry->is('fields'))
			{
				$_SESSION[$fields] = $registry->get('fields');
			}
			$_SESSION[$this->defaultFieldsIndex] = $this->option_arr['o_fields_index'];
		}
	
		if (isset($_SESSION[$fields]) && !empty($_SESSION[$fields]))
		{
			# Load fields from session
			$registry->set('fields', $_SESSION[$fields]);
		}
		
		return TRUE;
	}
	
	public function isCountryReady()
    {
    	return $this->isAdmin();
    }
    
	public function isOneAdminReady()
    {
    	return $this->isAdmin();
    }
	
	public static function setTimezone($timezone="UTC")
    {
    	if (in_array(version_compare(phpversion(), '5.1.0'), array(0,1)))
		{
			date_default_timezone_set($timezone);
		} else {
			$safe_mode = ini_get('safe_mode');
			if ($safe_mode)
			{
				putenv("TZ=".$timezone);
			}
		}
    }

	public static function setMySQLServerTime($offset="-0:00")
    {
		pjAppModel::factory()->prepare("SET SESSION time_zone = :offset;")->exec(compact('offset'));
    }
    
	public function setTime()
	{
		if (isset($this->option_arr['o_timezone']))
		{
			$offset = $this->option_arr['o_timezone'] / 3600;
			if ($offset > 0)
			{
				$offset = "-".$offset;
			} elseif ($offset < 0) {
				$offset = "+".abs($offset);
			} elseif ($offset === 0) {
				$offset = "+0";
			}
	
			pjAppController::setTimezone('Etc/GMT' . $offset);
			if (strpos($offset, '-') !== false)
			{
				$offset = str_replace('-', '+', $offset);
			} elseif (strpos($offset, '+') !== false) {
				$offset = str_replace('+', '-', $offset);
			}
			pjAppController::setMySQLServerTime($offset . ":00");
		}
	}
    
    public function beforeFilter()
    {
    	$this->appendJs('jquery.min.js', PJ_THIRD_PARTY_PATH . 'jquery/');
		$dm = new pjDependencyManager(PJ_THIRD_PARTY_PATH);
		$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
		$this->appendJs('jquery-migrate.min.js', $dm->getPath('jquery_migrate'), FALSE, FALSE);
		$this->appendJs('pjAdminCore.js');
		$this->appendCss('reset.css');
		 
		$this->appendJs('js/jquery-ui.custom.min.js', PJ_THIRD_PARTY_PATH . 'jquery_ui/');
		$this->appendCss('css/smoothness/jquery-ui.min.css', PJ_THIRD_PARTY_PATH . 'jquery_ui/');
				
		$this->appendCss('pj-all.css', PJ_FRAMEWORK_LIBS_PATH . 'pj/css/');
		$this->appendCss('admin.css');
		
    	if ($_GET['controller'] != 'pjInstaller')
		{
			$this->models['Option'] = pjOptionModel::factory();
			$this->option_arr = $this->models['Option']->getPairs($this->getForeignId());
			$this->set('option_arr', $this->option_arr);
			$this->setTime();
			
			if (!isset($_SESSION[$this->defaultLocale]))
			{
				$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
				if (count($locale_arr) === 1)
				{
					$this->setLocaleId($locale_arr[0]['id']);
				}
			}
			if (!in_array($_GET['action'], array('pjActionPreview')))
			{
				$this->loadSetFields();
			}
                        
			if (!$this->isAdmin()) {
				$_restaurant_arr = pjRestaurantModel::factory()
						->select('t1.id, t2.content AS `name`')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjRestaurant' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
						->join('pjUserRestaurant', 't3.restaurant_id = t1.id')
						->where('t3.user_id', $this->getUserId())
						->findAll()
						->getData();
			}
			else {
				$_restaurant_arr = pjRestaurantModel::factory()->select('t1.id, t2.content AS `name`')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjRestaurant' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->findAll()
					->getData();
			}
			$this->set('_restaurant_arr', $_restaurant_arr);
		}
    }
    
	public function isEditor()
    {
    	return $this->getRoleId() == 2;
    }
    
    public function isManager()
    {
        return $this->getRoleId() == 3;
    }
    
    public function getForeignId()
    {
    	return isset($_SESSION[$this->defaultRestaurantId]) && (int)$_SESSION[$this->defaultRestaurantId] > 0 ? (int)$_SESSION[$this->defaultRestaurantId] : 1;
    }
    
	public function getUserRestaurants()
    {
        $arr = pjUserRestaurantModel::factory()->where('t1.user_id', $this->getUserId())->findAll()->getDataPair(null, 'restaurant_id');
        return $arr;
    }
    
    public function setForeignId($foreign_id) {
    	if ((int)$foreign_id > 0) {
    		$_SESSION[$this->defaultRestaurantId] = (int)$foreign_id;
    	}
    }
    
    public static function setFields($locale)
    {
    	if(isset($_SESSION['lang_show_id']) && (int) $_SESSION['lang_show_id'] == 1)
		{
			$fields = pjMultiLangModel::factory()
				->select('CONCAT(t1.content, CONCAT(":", t2.id, ":")) AS content, t2.key')
				->join('pjField', "t2.id=t1.foreign_id", 'inner')
				->where('t1.locale', $locale)
				->where('t1.model', 'pjField')
				->where('t1.field', 'title')
				->findAll()
				->getDataPair('key', 'content');
		}else{
			$fields = pjMultiLangModel::factory()
				->select('t1.content, t2.key')
				->join('pjField', "t2.id=t1.foreign_id", 'inner')
				->where('t1.locale', $locale)
				->where('t1.model', 'pjField')
				->where('t1.field', 'title')
				->findAll()
				->getDataPair('key', 'content');
		}
		$registry = pjRegistry::getInstance();
		$tmp = array();
		if ($registry->is('fields'))
		{
			$tmp = $registry->get('fields');
		}
		$arrays = array();
		foreach ($fields as $key => $value)
		{
			if (strpos($key, '_ARRAY_') !== false)
			{
				list($prefix, $suffix) = explode("_ARRAY_", $key);
				if (!isset($arrays[$prefix]))
				{
					$arrays[$prefix] = array();
				}
				$arrays[$prefix][$suffix] = $value;
			}
		}
		require PJ_CONFIG_PATH . 'settings.inc.php';
		$fields = array_merge($tmp, $fields, $settings, $arrays);
		$registry->set('fields', $fields);
    }

    public static function jsonDecode($str)
	{
		$Services_JSON = new pjServices_JSON();
		return $Services_JSON->decode($str);
	}
	
	public static function jsonEncode($arr)
	{
		$Services_JSON = new pjServices_JSON();
		return $Services_JSON->encode($arr);
	}
	
	public static function jsonResponse($arr)
	{
		header("Content-Type: application/json; charset=utf-8");
		echo pjAppController::jsonEncode($arr);
		exit;
	}

	public function getLocaleId()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : false;
	}
	
	public function setLocaleId($locale_id)
	{
		$_SESSION[$this->defaultLocale] = (int) $locale_id;
	}
	
	public function pjActionCheckInstall()
	{
		$this->setLayout('pjActionEmpty');
		
		$result = array('status' => 'OK', 'code' => 200, 'text' => 'Operation succeeded', 'info' => array());
		$folders = array(
							'app/web/upload',
							'app/web/upload/products'
						);
		foreach ($folders as $dir)
		{
			if (!is_writable($dir))
			{
				$result['status'] = 'ERR';
				$result['code'] = 101;
				$result['text'] = 'Permission requirement';
				$result['info'][] = sprintf('Folder \'<span class="bold">%1$s</span>\' is not writable. You need to set write permissions (chmod 777) to directory located at \'<span class="bold">%1$s</span>\'', $dir);
			}
		}
		
		return $result;
	}
	
	public function friendlyURL($str, $divider='-')
	{
		$str = mb_strtolower($str, mb_detect_encoding($str));
		$str = trim($str);
		$str = preg_replace('/[_|\s]+/', $divider, $str);
		$str = preg_replace('/\x{00C5}/u', 'AA', $str);
		$str = preg_replace('/\x{00C6}/u', 'AE', $str);
		$str = preg_replace('/\x{00D8}/u', 'OE', $str);
		$str = preg_replace('/\x{00E5}/u', 'aa', $str);
		$str = preg_replace('/\x{00E6}/u', 'ae', $str);
		$str = preg_replace('/\x{00F8}/u', 'oe', $str);
		$str = preg_replace('/[^a-z\x{0400}-\x{04FF}0-9-]+/u', '', $str);
		$str = preg_replace('/[-]+/', $divider, $str);
		$str = preg_replace('/^-+|-+$/', '', $str);
		return $str;
	}
	
	public function getCoords($str)
	{
		if (!is_array($str))
		{
			$_address = preg_replace('/\s+/', '+', $str);
			$_address = urlencode($_address);
		} else {
			$address = array();
			$address[] = $str['d_zip'];
			$address[] = $str['d_address_1'];
			$address[] = $str['d_city'];
			$address[] = $str['d_state'];
	
			foreach ($address as $k => $v)
			{
				$tmp = preg_replace('/\s+/', '+', $v);
				$address[$k] = $tmp;
			}
			$_address = join(",+", $address);
		}
							
		$api = sprintf("https://maps.googleapis.com/maps/api/geocode/json?key=".$this->option_arr['o_google_map_api']."&address=%s&sensor=false", $_address);
		
		$pjHttp = new pjHttp();
		$pjHttp->request($api);
		$response = $pjHttp->getResponse();
		
		$geoObj = pjAppController::jsonDecode($response);
		
		$data = array();
		if ($geoObj->status == 'OK')
		{
			$data['lat'] = $geoObj->results[0]->geometry->location->lat;
			$data['lng'] = $geoObj->results[0]->geometry->location->lng;
		} else {
			$data['lat'] = array('NULL');
			$data['lng'] = array('NULL');
		}
		return $data;
	}
	
	public function getDiscount($data, $option_arr)
	{
		$resp = array();
		
		if (isset($data['voucher_code']) && !empty($data['voucher_code']))
		{
			$_arr = pjVoucherModel::factory()
				->where('code', $data['voucher_code'])
				->where('t1.restaurant_id', (int)@$data['restaurant_id'])
				->findAll()
				->getData();
			if(count($_arr) > 0)
			{
				$arr = $_arr[0];
				
				if ($data['type'] == 'delivery')
				{
					$date = null;
					$time = "00:00:00";
					if (isset($data['d_dt']) && !empty($data['d_dt']))
					{
						$date_time = $data['d_dt'];
						if(count(explode(" ", $date_time)) == 3)
						{
							list($_date, $_time, $_period) = explode(" ", $date_time);
							$time = pjUtil::formatTime($_time . ' ' . $_period, $option_arr['o_time_format']);
						}else{
							list($_date, $_time) = explode(" ", $date_time);
							$time = pjUtil::formatTime($_time, $option_arr['o_time_format']);
						}
						$date = $_date;
					}
					if(isset($data['d_date']) && !empty($data['d_date']))
					{
						$date = $data['d_date'];
						if (isset($data['d_time']))
						{
							if($data['d_time'] != 'asap')
							{
								$time = $data['d_time'] . ":00";
							}else{
								$time = date('H:i:s');
							}
						}
					}
				} elseif ($data['type'] == 'catering') {
					$date = null;
					$time = "00:00:00";
					if (isset($data['ca_dt']) && !empty($data['ca_dt']))
					{
						$date_time = $data['ca_dt'];
						if(count(explode(" ", $date_time)) == 3)
						{
							list($_date, $_time, $_period) = explode(" ", $date_time);
							$time = pjUtil::formatTime($_time . ' ' . $_period, $option_arr['o_time_format']);
						}else{
							list($_date, $_time) = explode(" ", $date_time);
							$time = pjUtil::formatTime($_time, $option_arr['o_time_format']);
						}
						$date = $_date;
					}
					if(isset($data['ca_date']) && !empty($data['ca_date']))
					{
						$date = $data['ca_date'];
						if (isset($data['ca_time']))
						{
							if($data['ca_time'] != 'asap')
							{
								$time = $data['ca_time'] . ":00";
							}else{
								$time = date('H:i:s');
							}
						}
					}
				} else {
					$date = null;
					$time = "00:00:00";
					if (isset($data['p_dt']) && !empty($data['p_dt']))
					{
						$date_time = $data['p_dt'];
						if(count(explode(" ", $date_time)) == 3)
						{
							list($_date, $_time, $_period) = explode(" ", $date_time);
							$time = pjUtil::formatTime($_time . ' ' . $_period, $option_arr['o_time_format']);
						}else{
							list($_date, $_time) = explode(" ", $date_time);
							$time = pjUtil::formatTime($_time, $option_arr['o_time_format']);
						}
						$date = $_date;
					}
					if(isset($data['p_date']) && !empty($data['p_date']))
					{
						$date = $data['p_date'];
						if (isset($data['p_time']))
						{
							if($data['p_time'] != 'asap')
							{
								$time = $data['p_time'] . ":00";
							}else{
								$time = date('H:i:s');
							}
						}
					}
				}
				
				if (!empty($date))
				{
					$date= pjUtil::formatDate($date, $option_arr['o_date_format']);
					$d = strtotime($date);
					$dt = strtotime($date . " ". $time);
					
					$valid = false;					
					switch ($arr['valid'])
					{
						case 'fixed':
							$time_from = strtotime($arr['date_from'] . " " . $arr['time_from']);
							$time_to = strtotime($arr['date_to'] . " " . $arr['time_to']);							
							if ($time_from <= $dt && $time_to >= $dt)
							{
								$valid = true;
							}
							break;
						case 'period':
							$d_from = strtotime($arr['date_from']);
							$d_to = strtotime($arr['date_to']);
							$t_from = strtotime($arr['date_from'] . " " . $arr['time_from']);
							$t_to = strtotime($arr['date_to'] . " " . $arr['time_to']);
							if ($d_from <= $d && $d_to >= $d && $t_from <= $dt && $t_to >= $dt)
							{
								$valid = true;
							}
							break;
						case 'recurring':
							$t_from = strtotime($date . " " . $arr['time_from']);
							$t_to = strtotime($date . " " . $arr['time_to']);
							if ($arr['every'] == strtolower(date("l", $dt)) && $t_from <= $dt && $t_to >= $dt)
							{
								$valid = true;
							}
							break;
					}
					if ($valid)
					{
						$resp['voucher_code'] = $arr['code'];
						$resp['voucher_type'] = $arr['type'];
						$resp['voucher_discount'] = $arr['discount'];
						$resp['code'] = 200;
					}else{
						$resp['code'] = 102;
					}
				}else{
					$resp['code'] = 103;
				}
			}else{
				$resp['code'] = 101;
			}
		}else {
			$resp['code'] = 100;
		}
		return $resp;
	}
	
	public function getWorkingTime($date, $location_id, $type)
	{
		$date_arr = pjDateModel::factory()->getWorkingTime($date, $location_id, $type);
		if ($date_arr === false)
		{
			$wt_arr = pjWorkingTimeModel::factory()->getWorkingTime($location_id, $type, $date);
			
			if (count($wt_arr) == 0)
			{
				return false;
			}
			$t_arr = $wt_arr;
		} else {
			if (count($date_arr) == 0)
			{
				return false;
			}
			$t_arr = $date_arr;
		}
		return $t_arr;
	}
	
	public function getLocationWT($date, $location_id, $type)
	{
		$wt_arr = array();
		$break_time_arr = array();
		$date_arr = pjDateWTModel::factory()->reset()
			->where('t1.date', $date)
			->where('t1.location_id', $location_id)
			->where('t1.type', $type)
			->orderBy("t1.start_time ASC, t1. end_time ASC")
			->findAll()
			->getData();
		if ($date_arr) {
			$wt_arr['working_time'] = $date_arr;
			foreach ($date_arr as $k => $v) {
				if (isset($date_arr[$k + 1]) && $date_arr[$k + 1]['start_time'] > $v['end_time']) {
					$break_time_arr[] = array(
						'lunch_break_from' => $v['end_time'],
						'lunch_break_from_ts' => strtotime($v['date'].' '.$v['end_time']),
						'lunch_break_to' => $date_arr[$k + 1]['start_time'],
						'lunch_break_to_ts' => strtotime($date_arr[$k + 1]['date'].' '.$date_arr[$k + 1]['start_time'])
					);
				}
			}
			$wt_arr['break_time'] = $break_time_arr;
		} else {
			$day = strtolower(date("l", strtotime($date)));
			$type = in_array($type, array('catering','delivery')) ? 'delivery' : 'pickup';
			$arr = pjLocationWTModel::factory()
				->where('t1.location_id', $location_id)
				->where('t1.type', $type)
				->where('t1.day', $day)
				->orderBy("t1.start_time ASC, t1. end_time ASC")
				->findAll()
				->getData();
			if ($arr) {
				$wt_arr['working_time'] = $arr;
				foreach ($arr as $k => $v) {
					if (isset($arr[$k + 1]) && $arr[$k + 1]['start_time'] > $v['end_time']) {
						$break_time_arr[] = array(
							'lunch_break_from' => $v['end_time'],
							'lunch_break_from_ts' => strtotime($date.' '.$v['end_time']),
							'lunch_break_to' => $arr[$k + 1]['start_time'],
							'lunch_break_to_ts' => strtotime($date.' '.$arr[$k + 1]['start_time'])
						);
					}
				}
				$wt_arr['break_time'] = $break_time_arr;
			}
		}
		return $wt_arr;
	}
	
	public function getAdminEmail()
	{
		$arr = pjUserModel::factory()
			->findAll()
			->orderBy("t1.id ASC")
			->limit(1)
			->getData();
		return !empty($arr) ? $arr[0]['email'] : null;	
	}
	
	public function getAdminPhone()
	{
		$arr = pjUserModel::factory()
			->findAll()
			->orderBy("t1.id ASC")
			->limit(1)
			->getData();
		return !empty($arr) ? (!empty($arr[0]['phone']) ? $arr[0]['phone'] : null) : null;	
	}
	
	public function getClientTokens($option_arr, $data, $salt, $locale_id)
	{
		$country = NULL;
		if (isset($data['c_country']) && !empty($data['c_country']))
		{
			if(isset($data['c_country']) && (int) $data['c_country'] > 0)
			{
				$country_arr = pjCountryModel::factory()
							->select('t1.id, t2.content AS country_title')
							->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$locale_id."'", 'left outer')
							->find($data['c_country'])->getData();
				if (!empty($country_arr))
				{
					$country = $country_arr['country_title'];
				}
			}
		}
		$search = array(
			'{Title}', '{Name}', '{Email}', '{Password}', '{Phone}',
			'{Address1}', '{Address2}', '{Country}', '{State}',
			'{City}', '{Zip}');
		$replace = array(
			@$data['c_title'], @$data['c_name'], @$data['c_email'], @$data['c_password'], @$data['c_phone'],
			@$data['c_address_1'], @$data['c_address_2'], $country, @$data['c_state'],
			@$data['c_city'], @$data['c_zip']);

		return compact('search', 'replace');
		
	}
	
	public function getTokens($option_arr, $data, $salt, $locale_id)
	{
		$c_country = NULL;
		$d_country = NULL;
		$ca_country = NULL;
		
		if (isset($data['c_country']) && !empty($data['c_country']))
		{
			$pjCountryModel = pjCountryModel::factory();
			
			$country_arr = pjCountryModel::factory()
						->select('t1.id, t2.content AS country_title')
						->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$locale_id."'", 'left outer')
						->find($data['c_country'])->getData();
			if (!empty($country_arr))
			{
				$c_country = $country_arr['country_title'];
			}
		}
		
		if ($data['type'] == 'delivery') {
			$country_arr = pjCountryModel::factory()
				->reset()
				->select('t1.id, t2.content AS country_title')
				->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$locale_id."'", 'left outer')
				->find($data['d_country_id'])
				->getData();
			if (!empty($country_arr))
			{
				$d_country = $country_arr['country_title'];
			}
		} elseif ($data['type'] == 'catering') {
			$country_arr = pjCountryModel::factory()
				->reset()
				->select('t1.id, t2.content AS country_title')
				->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$locale_id."'", 'left outer')
				->find($data['ca_country_id'])
				->getData();
			if (!empty($country_arr))
			{
				$ca_country = $country_arr['country_title'];
			}
		}
		
		$row = array();
		if (isset($data['product_arr']))
		{
			foreach ($data['product_arr'] as $v)
			{
				$extra = array();
				foreach ($v['extra_arr'] as $e)
				{
					$extra[] = '<span style="padding-left: 20px; font-weight: 600; display: block;">'.stripslashes(sprintf("%u x %s", $e['cnt'], $e['name'])).'</span>';
				}
				$group_items = array();
				foreach ($v['group_item_arr'] as $pgi)
				{
					$group_items[] = '<span style="padding-left: 20px; font-weight: 600; display: block;">'.stripslashes($pgi['group_item_name']).'</span>';
				}
				$modifier_items = array();
				foreach ($v['modifier_item_arr'] as $pmi)
				{
					$modifier_items[] = '<span style="padding-left: 20px; font-weight: 600; display: block;">'.stripslashes($pmi['item_name']).'</span>';
				}
				$row[] = '<span style="display: block; border-bottom: 1px dashed #000; margin-bottom: 5px; padding-bottom: 5px;">';
				if(!empty($v['size']))
				{
					$row[] = '<span style="display: block;">'.stripslashes(sprintf("%s x %s: %s", $v['cnt'], $v['name'], pjUtil::formatCurrencySign($v['price'], $this->option_arr['o_currency']))).'</span>';
					$row[] = '<span style="padding-left: 20px; font-weight: 600; display: block;">'.stripslashes(sprintf("%s", $v['size'])).'</span>';
					$row[] = (count($extra) > 0 ? sprintf("%s", join("", $extra)) : NULL) . (count($group_items) > 0 ? sprintf("%s", join("", $group_items)) : NULL) . (count($modifier_items) > 0 ? sprintf("%s", join("", $modifier_items)) : NULL);
				}else{
					$row[] = '<span style="display: block;">'.stripslashes(sprintf("%u x %s: %s ", $v['cnt'], $v['name'], pjUtil::formatCurrencySign($v['price'], $this->option_arr['o_currency']))) . (count($extra) > 0 ? sprintf("%s", join("", $extra)) : NULL) . (count($group_items) > 0 ? sprintf("%s", join("", $group_items)) : NULL) . (count($modifier_items) > 0 ? sprintf("%s", join("", $modifier_items)) : NULL).'</span>';
				}
				$row[] = '</span>';
			}
		}
		$order_data = count($row) > 0 ? join("", $row) : NULL;
		
		$row = array();
		if (isset($data['product_arr']))
		{
			foreach ($data['product_arr'] as $v)
			{
				$extra = array();
				foreach ($v['extra_arr'] as $e)
				{
					$extra[] = '<span style="padding-left: 20px; font-weight: 600; display: block;">'.stripslashes(sprintf("%u x %s", $e['cnt'], $e['name'])).'</span>';
				}
				$group_items = array();
				foreach ($v['group_item_arr'] as $pgi)
				{
					$group_items[] = '<span style="padding-left: 20px; font-weight: 600; display: block;">'.stripslashes($pgi['group_item_name']).'</span>';
				}
				$modifier_items = array();
				foreach ($v['modifier_item_arr'] as $pmi)
				{
					$modifier_items[] = '<span style="padding-left: 20px; font-weight: 600; display: block;">'.stripslashes($pmi['item_name']).'</span>';
				}
				$row[] = '<span style="display: block; border-bottom: 1px dashed #000; margin-bottom: 5px; padding-bottom: 5px;">';
				if(!empty($v['size']))
				{
					$row[] = '<span style="display: block;">'.stripslashes(sprintf("%u x %s ", $v['cnt'], $v['name'])).'</span>';
					$row[] = '<span style="padding-left: 20px; font-weight: 600; display: block;">'.stripslashes(sprintf("%s", $v['size'])).'</span>';
					$row[] = (count($extra) > 0 ? sprintf("%s", join("", $extra)) : NULL) . (count($group_items) > 0 ? sprintf("%s", join("", $group_items)) : NULL) . (count($modifier_items) > 0 ? sprintf("%s", join("", $modifier_items)) : NULL);
				}else{
					$row[] = '<span style="display: block;">'.stripslashes(sprintf("%u x %s", $v['cnt'], $v['name'])) . (count($extra) > 0 ? sprintf("%s", join("", $extra)) : NULL) . (count($group_items) > 0 ? sprintf("%s", join("", $group_items)) : NULL) . (count($modifier_items) > 0 ? sprintf("%s", join("", $modifier_items)) : NULL).'</span>';
				}
				$row[] = '</span>';
			}
		}
		$order_data_without_prices = count($row) > 0 ? join("", $row) : NULL;
		
        $discount = NULL;
		if (!empty($data['voucher_code']))
		{
			$voucher_arr = pjVoucherModel::factory()
				->where('t1.code', $data['voucher_code'])
				->limit(1)
				->findAll()
				->getData();
			if (!empty($voucher_arr))
			{
				$voucher_arr = $voucher_arr[0];
				switch ($voucher_arr['type'])
				{
					case "amount":
						$discount = pjUtil::formatCurrencySign($voucher_arr['discount'], $option_arr['o_currency']);
						break;
					case "percent":
						$discount = $voucher_arr['discount'] . '%';
						break;
				}
			}
		}
		$subtotal = pjUtil::formatCurrencySign($data['subtotal'], $option_arr['o_currency']);
		$price_delivery = pjUtil::formatCurrencySign($data['price_delivery'], $option_arr['o_currency']);
		$total = pjUtil::formatCurrencySign($data['total'], $option_arr['o_currency']);
		$tax = pjUtil::formatCurrencySign($data['tax'], $option_arr['o_currency']);
		$service_fee = pjUtil::formatCurrencySign($data['service_fee'], $option_arr['o_currency']);
		$catering_fee = pjUtil::formatCurrencySign($data['catering_fee'], $option_arr['o_currency']);
		$tip_amount = pjUtil::formatCurrencySign($data['tip_amount'], $option_arr['o_currency']);
		
		$cancelURL = PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionCancel&id='.@$data['id'].'&hash='.sha1(@$data['id'].@$data['created'].$salt);
		
		if (@$data['type'] == 'pickup') {
			$ts = strtotime(@$data['p_dt']);
		} elseif (@$data['type'] == 'delivery') {
			$ts = strtotime(@$data['d_dt']);
		} else {
			$ts = strtotime(@$data['ca_dt']);
		}
		
		$date_time = date($option_arr['o_date_format'], $ts) . ', ' . date($option_arr['o_time_format'], $ts);
		if(@$data['type'] == 'pickup' &&  @$data['p_asap'] == 'T')
		{
			$date_time = date($option_arr['o_date_format'], $ts) . ', ' . __('front_asap', true);
		}
		if(@$data['type'] == 'delivery' &&  @$data['d_asap'] == 'T')
		{
			$date_time = date($option_arr['o_date_format'], $ts) . ', ' . __('front_asap', true);
		}
		$statuses = __('order_statuses', true, false);
		if (@$data['payment_method'] == 'creditcard') {
			$cc_type = @$data['cc_type'];
			$cc_num = @$data['cc_num'];
			$cc_exp = @$data['cc_exp'];
			$cc_code = @$data['cc_code'];
		} else {
			$cc_type = NULL;
			$cc_num = NULL;
			$cc_exp = NULL;
			$cc_code = NULL;
		}
		$search = array(
			'{Country}', '{City}', '{State}', '{Notes}',
			'{Zip}', '{Address1}', '{Address2}',
			'{Name}', '{Email}', '{Phone}', '{dCountry}',
			'{dCity}', '{dState}', '{dZip}', '{dAddress1}', '{dAddress2}', '{dNotes}',
			'{CCType}', '{CCNum}', '{CCExp}',
			'{CCSec}', '{PaymentMethod}', '{DateTime}',
			'{Subtotal}', '{Delivery}', '{Discount}','{Tax}',
			'{Total}', '{dNotes}', '{Location}',
			'{OrderID}', '{CancelURL}', '{OrderDetails}', '{OrderDetailsWithoutPrices}', '{ServiceFee}', '{CateringFee}',
			'{caCountry}', '{caCity}', '{caState}', '{caZip}', '{caAddress1}', '{caAddress2}', '{caNotes}', '{OrderStatus}', '{TipAmount}'
		);
		$replace = array(
			$c_country, @$data['c_city'], @$data['c_state'], @$data['p_notes'],
			@$data['c_zip'], @$data['c_address_1'], @$data['c_address_2'],
			@$data['c_name'], @$data['c_email'], @$data['c_phone'], $d_country,
			@$data['d_city'], $data['d_state'], @$data['d_zip'], @$data['d_address_1'], @$data['d_address_2'], @$data['d_notes'],
			$cc_type, $cc_num, $cc_exp,
			$cc_code, @$data['payment_method'], $date_time,
			$subtotal, $price_delivery, @$discount, @$tax,
			$total, @$data['d_notes'], @$data['location'],
			@$data['uuid'], $cancelURL, $order_data, $order_data_without_prices, $service_fee, $catering_fee,
			$ca_country, @$data['ca_city'], $data['ca_state'], @$data['ca_zip'], @$data['ca_address_1'], @$data['ca_address_2'], @$data['ca_notes'], @$statuses[@$data['status']],
			$tip_amount
		);
			
		return compact('search', 'replace');
	}
	
	public static function addOrderDetails(&$arr, $locale_id)
	{
		$l_arr = pjLocationModel::factory()
			->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjLocation' AND t2.locale = '".$locale_id."' AND t2.field = 'name'", 'left')
			->select('t1.*, t2.content as name')
			->find($arr['location_id'])
			->getData();
		if (count($l_arr) > 0)
		{
			$arr['location'] = $l_arr['name'];
		}

		$pjOrderItemModel = pjOrderItemModel::factory();
		
		$arr['product_arr'] = $pjOrderItemModel
			->reset()
			->join('pjMultiLang', "t2.foreign_id = t1.foreign_id AND t2.model = 'pjProduct' AND t2.locale = '".$locale_id."' AND t2.field = 'name'", 'left')
			->join('pjMultiLang', "t3.foreign_id = t1.price_id AND t3.model = 'pjProductPrice' AND t3.locale = '".$locale_id."' AND t3.field = 'price_name'", 'left')
			->select('t1.*, t2.content as name, t3.content as size')
			->where('t1.order_id', $arr['id'])
			->where('type', 'product')
			->findAll()
			->getData();
			
		foreach ($arr['product_arr'] as $k => $product)
		{
			$arr['product_arr'][$k]['extra_arr'] = $pjOrderItemModel
				->reset()
				->join('pjMultiLang', "t2.foreign_id = t1.foreign_id AND t2.model = 'pjExtra' AND t2.locale = '".$locale_id."' AND t2.field = 'name'", 'left')
				->select('t1.*, t2.content as name')
				->where('t1.order_id', $arr['id'])
				->where('type', 'extra')
				->where('hash', $product['hash'])
				->findAll()
				->getData();
				
			$arr['product_arr'][$k]['group_item_arr'] = $pjOrderItemModel
				->reset()
				->join('pjMultiLang', "t2.foreign_id = t1.foreign_id AND t2.model = 'pjProductGroupItem' AND t2.locale = '".$locale_id."' AND t2.field = 'group_item_name'", 'left')
				->select('t1.*, t2.content as group_item_name')
				->where('t1.order_id', $arr['id'])
				->where('type', 'group')
				->where('hash', $product['hash'])
				->findAll()
				->getData();
				
			$arr['product_arr'][$k]['modifier_item_arr'] = $pjOrderItemModel
				->reset()
				->join('pjMultiLang', "t2.foreign_id = t1.foreign_id AND t2.model = 'pjModifierItem' AND t2.locale = '".$locale_id."' AND t2.field = 'item_name'", 'left')
				->select('t1.*, t2.content as item_name')
				->where('t1.order_id', $arr['id'])
				->where('type', 'modifier_item')
				->where('hash', $product['hash'])
				->findAll()
				->getData();
		}
	}
	
	public function pjActionGetDistanceAndDuration($from_address, $to_address, $miles = true)
	{
		$from_address = preg_replace('/\s+/', '+', $from_address);
		$to_address = preg_replace('/\s+/', '+', $to_address);
		
		$gfile = "https://maps.googleapis.com/maps/api/distancematrix/json?key=".$this->option_arr['o_google_map_api']."&origins=$from_address&destinations=$to_address&language=en-EN&sensor=false";
		
		$Http = new pjHttp();
		$response = $Http->request($gfile)->getResponse();
		
		$geoObj = pjAppController::jsonDecode($response);
		$geoArr = (array) $geoObj;
				
		$data = array('status' => 100, 'distance' => NULL, 'duration' => NULL);
		if ($geoArr['status'] == 'OK')
		{
			$second = 0;
			$meter = 0;
			foreach ($geoArr['rows'][0]->elements as $road)
			{
				if (isset($road->status) && ($road->status == 'ZERO_RESULTS' || $road->status == 'NOT_FOUND')) {
					return array('status' => 100, 'distance' => NULL, 'duration' => NULL);
				} else {
					$second += $road->duration->value;
					$meter += $road->distance->value;
				}
			}
			$km = $meter / 1000;
			$minutes = $second / 60;
			$data['status'] = 200;
			$data['distance'] = number_format(($miles ? ($km * 0.621371192) : $km), 1);
			$data['duration'] = floor($minutes);
		}
		return $data;
	}
	
	public static function base64UrlEncode($data)
	{
	    $base64Url = strtr(base64_encode($data), '+/', '-_');	
	    return rtrim($base64Url, '=');
	}
	
	public static function base64UrlDecode($base64Url)
	{
	    return base64_decode(strtr($base64Url, '-_', '+/'));
	}
	
	public static function doordashDeliveryQuote($data, $option_arr) {
		$header = json_encode(array(
			'alg' => 'HS256',
		    'typ' => 'JWT',
		    'dd-ver' => 'DD-JWT-V1'
		));
		
		$payload = json_encode(array(
			'aud' => 'doordash',
		    'iss' => $option_arr['o_doordash_developer_id'],
		    'kid' => $option_arr['o_doordash_key_id'],
		    'exp' => time() + 1800,
		    'iat' => time()
		));
		
		$base64UrlHeader = pjAppController::base64UrlEncode($header);
		$base64UrlPayload = pjAppController::base64UrlEncode($payload);
		
		$signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, pjAppController::base64UrlDecode($option_arr['o_doordash_signing_secret']), true);
		$base64UrlSignature = pjAppController::base64UrlEncode($signature);
		
		$jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
		$uuid = pjUtil::uuid();
		$request_body = json_encode(array(
			  "external_delivery_id" => $uuid,
			  "pickup_address"=> $data['pickup_address'],
			  "pickup_business_name"=> $data['pickup_business_name'],
			  "pickup_phone_number"=> $data['pickup_phone_number'],
			  "dropoff_address"=> $data['dropoff_address'],
			  "dropoff_business_name"=> $data['dropoff_business_name'],
			  "dropoff_phone_number"=> $data['dropoff_phone_number'],
			  "dropoff_instructions"=> $data['dropoff_instructions'],
			  "order_value"=> $data['order_value'],
		      "tip"=> (float)@$data['tip']
		));
		
		$headers = array(
		  "Content-type: application/json",
		  "Authorization: Bearer ".$jwt
		);
		
		$http = new pjHttp();
		$http->setHeaders($headers);
		$http->setMethod('POST');
		$http->setData($request_body, false);
		$http->request('https://openapi.doordash.com/drive/v2/quotes');
		$resp = $http->getResponse();
		
		return json_decode($resp, true);
	}
	
	public static function doordashAcceptDeliveryQuote($external_delivery_id, $option_arr) {
		$header = json_encode(array(
			'alg' => 'HS256',
		    'typ' => 'JWT',
		    'dd-ver' => 'DD-JWT-V1'
		));
		
		$payload = json_encode(array(
			'aud' => 'doordash',
		    'iss' => $option_arr['o_doordash_developer_id'],
		    'kid' => $option_arr['o_doordash_key_id'],
		    'exp' => time() + 1800,
		    'iat' => time()
		));
		
		$base64UrlHeader = pjAppController::base64UrlEncode($header);
		$base64UrlPayload = pjAppController::base64UrlEncode($payload);
		
		$signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, pjAppController::base64UrlDecode($option_arr['o_doordash_signing_secret']), true);
		$base64UrlSignature = pjAppController::base64UrlEncode($signature);
		
		$jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
		$headers = array(
		  "Content-type: application/json",
		  "Authorization: Bearer ".$jwt
		);
		
		$http = new pjHttp();
		$http->setHeaders($headers);
		$http->setMethod('POST');
		$http->request('https://openapi.doordash.com/drive/v2/quotes/'.$external_delivery_id.'/accept');
		$resp = $http->getResponse();
		
		return json_decode($resp, true);
	}
	
	public static function doordashGetDeliveryStatus($external_delivery_id, $option_arr) {
		$header = json_encode(array(
			'alg' => 'HS256',
		    'typ' => 'JWT',
		    'dd-ver' => 'DD-JWT-V1'
		));
		
		$payload = json_encode(array(
			'aud' => 'doordash',
		    'iss' => $option_arr['o_doordash_developer_id'],
		    'kid' => $option_arr['o_doordash_key_id'],
		    'exp' => time() + 1800,
		    'iat' => time()
		));
		
		$base64UrlHeader = pjAppController::base64UrlEncode($header);
		$base64UrlPayload = pjAppController::base64UrlEncode($payload);
		
		$signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, pjAppController::base64UrlDecode($option_arr['o_doordash_signing_secret']), true);
		$base64UrlSignature = pjAppController::base64UrlEncode($signature);
		
		$jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
		$headers = array(
		  "Content-type: application/json",
		  "Authorization: Bearer ".$jwt
		);
		
		$http = new pjHttp();
		$http->setHeaders($headers);
		$http->setMethod('GET');
		$http->request('https://openapi.doordash.com/drive/v2/deliveries/'.$external_delivery_id);
		$resp = $http->getResponse();
		
		return json_decode($resp, true);
	}
	
	public static function doordashCreateDelivery($data, $option_arr) {
		$header = json_encode(array(
			'alg' => 'HS256',
		    'typ' => 'JWT',
		    'dd-ver' => 'DD-JWT-V1'
		));
		
		$payload = json_encode(array(
			'aud' => 'doordash',
		    'iss' => $option_arr['o_doordash_developer_id'],
		    'kid' => $option_arr['o_doordash_key_id'],
		    'exp' => time() + 1800,
		    'iat' => time()
		));
		
		$base64UrlHeader = pjAppController::base64UrlEncode($header);
		$base64UrlPayload = pjAppController::base64UrlEncode($payload);
		
		$signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, pjAppController::base64UrlDecode($option_arr['o_doordash_signing_secret']), true);
		$base64UrlSignature = pjAppController::base64UrlEncode($signature);
		
		$jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
		$uuid = pjUtil::uuid();
		$request_body = json_encode(array(
			"external_delivery_id" => $uuid,
			  "pickup_address"=> $data['pickup_address'],
			  "pickup_business_name"=> $data['pickup_business_name'],
			  "pickup_phone_number"=> $data['pickup_phone_number'],
			  "dropoff_address"=> $data['dropoff_address'],
			  "dropoff_business_name"=> $data['dropoff_business_name'],
			  "dropoff_phone_number"=> $data['dropoff_phone_number'],
			  "dropoff_instructions"=> $data['dropoff_instructions'],
			  "order_value"=> $data['order_value'],
		      "tip"=> (float)@$data['tip']
		));
		
		$headers = array(
		  "Content-type: application/json",
		  "Authorization: Bearer ".$jwt
		);
		
		$http = new pjHttp();
		$http->setHeaders($headers);
		$http->setMethod('POST');
		$http->setData($request_body, false);
		$http->request('https://openapi.doordash.com/drive/v2/deliveries/');
		$resp = $http->getResponse();
		
		return json_decode($resp, true);
	}
	
	public static function doordashUpdateDelivery($data, $option_arr) {
		$header = json_encode(array(
			'alg' => 'HS256',
		    'typ' => 'JWT',
		    'dd-ver' => 'DD-JWT-V1'
		));
		
		$payload = json_encode(array(
			'aud' => 'doordash',
		    'iss' => $option_arr['o_doordash_developer_id'],
		    'kid' => $option_arr['o_doordash_key_id'],
		    'exp' => time() + 1800,
		    'iat' => time()
		));
		
		$base64UrlHeader = pjAppController::base64UrlEncode($header);
		$base64UrlPayload = pjAppController::base64UrlEncode($payload);
		
		$signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, pjAppController::base64UrlDecode($option_arr['o_doordash_signing_secret']), true);
		$base64UrlSignature = pjAppController::base64UrlEncode($signature);
		
		$jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
		$request_body = json_encode(array(
			  "pickup_address"=> $data['pickup_address'],
			  "pickup_business_name"=> $data['pickup_business_name'],
			  "pickup_phone_number"=> $data['pickup_phone_number'],
			  "dropoff_address"=> $data['dropoff_address'],
			  "dropoff_business_name"=> $data['dropoff_business_name'],
			  "dropoff_phone_number"=> $data['dropoff_phone_number'],
			  "dropoff_instructions"=> $data['dropoff_instructions'],
			  "order_value"=> $data['order_value'],
		      "tip"=> (float)@$data['tip']
		));
		
		$headers = array(
		  "Content-type: application/json",
		  "Authorization: Bearer ".$jwt
		);
		
		$http = new pjHttp();
		$http->setHeaders($headers);
		$http->setMethod('POST');
		$http->setData($request_body, false);
		$http->request('https://openapi.doordash.com/drive/v2/deliveries/'.$data['external_delivery_id']);
		$resp = $http->getResponse();
		
		return json_decode($resp, true);
	}
	
	public static function doordashCancelDelivery($external_delivery_id, $option_arr) {
		$header = json_encode(array(
			'alg' => 'HS256',
		    'typ' => 'JWT',
		    'dd-ver' => 'DD-JWT-V1'
		));
		
		$payload = json_encode(array(
			'aud' => 'doordash',
		    'iss' => $option_arr['o_doordash_developer_id'],
		    'kid' => $option_arr['o_doordash_key_id'],
		    'exp' => time() + 1800,
		    'iat' => time()
		));
		
		$base64UrlHeader = pjAppController::base64UrlEncode($header);
		$base64UrlPayload = pjAppController::base64UrlEncode($payload);
		
		$signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, pjAppController::base64UrlDecode($option_arr['o_doordash_signing_secret']), true);
		$base64UrlSignature = pjAppController::base64UrlEncode($signature);
		
		$jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
		$headers = array(
		  "Content-type: application/json",
		  "Authorization: Bearer ".$jwt
		);
		
		$http = new pjHttp();
		$http->setHeaders($headers);
		$http->request('https://openapi.doordash.com/drive/v2/deliveries/'.$external_delivery_id.'/cancel');
		$resp = $http->getResponse();
		
		return json_decode($resp, true);
	}
	
	public static function writeLog($content, $filename=null)
	{
		$filename = is_null($filename) ? 'payment.log' : $filename;
		@file_put_contents($filename, $content . "\r\n", FILE_APPEND|FILE_TEXT);
	}

    public function isOnlyKiosk()
    {
        $arr = pjUserModel::factory()->where('t1.id', $this->getUserId())->findAll()->getData();
        return !empty($arr) ? $arr[0]['only_kiosk']>0 : false;
    }

    public function isCustomProductKiosk()
    {
        $arr = pjUserModel::factory()->where('t1.id', $this->getUserId())->findAll()->getData();
        return !empty($arr) ? $arr[0]['custom_product_kiosk']>0 : false;
    }
}
?>