(function ($, undefined) {
  $(function () {
    var datagrid = ($.fn.datagrid !== undefined);

    function onBeforeShow (obj) {
      if (parseInt(obj.id, 10) === pjGrid.currentRestaurantId || parseInt(obj.id, 10) === 1) {
        return false;
      }
      return true;
    }

    if ($("#grid").length > 0 && datagrid) {
      var gridOpts = {
        buttons: [
          // {type: "edit", url: "index.php?controller=pjKios&action=pjActionKiosUpdate&id={:id}"},
          // {type: "delete", url: "index.php?controller=pjKios&action=pjActionKiosDelete&id={:id}", beforeShow: onBeforeShow}
        ],
        columns: [
          {text: myLabel.id, type: "text", sortable: true, editable: false, width: 30},
          {text: myLabel.createdTime, type: "text", sortable: true, editable: false},
          {text: myLabel.numberOrder, type: "text", sortable: true, editable: false},
          {text: myLabel.discount, type: "text", sortable: true, editable: false},
          {text: myLabel.tax, type: "text", sortable: true, editable: false},
          {text: myLabel.tip, type: "text", sortable: true, editable: false},
          {text: myLabel.totalPrice, type: "text", sortable: true, editable: false},
          {text: myLabel.status, type: "text", sortable: true, editable: false},
          {text: myLabel.detail, type: "text", sortable: false, editable: false, width: 40}
        ],
        dataUrl: "index.php?controller=pjKiosk&action=pjAjaxOrderList" + pjGrid.queryString,
        dataType: "json",
        fields: ['id', 'createdTime', 'numberOrder', 'discount', 'tax', 'tip', 'totalPrice', 'status', 'detail'],
        paginator: {
          actions: [],
          gotoPage: true,
          paginate: true,
          total: true,
          rowCount: true
        }
      };
      var $grid = $("#grid").datagrid(gridOpts);
    }

    $(document).on("focusin", ".datepick", function (e) {
      var minDate, maxDate,
        $this = $(this),
        custom = {},
        o = {
          firstDay: $this.attr("rel"),
          dateFormat: $this.attr("rev"),
          onClose: function(dateText){
            $('.frm-filter').submit();
          }
        };
      switch ($this.attr("name")) {
        case "date_from":
          if($(".datepick[name='date_to']").val() != '')
          {
            maxDate = $(".datepick[name='date_to']").datepicker({
              firstDay: $this.attr("rel"),
              dateFormat: $this.attr("rev"),
            }).datepicker("getDate");
            $(".datepick[name='date_to']").datepicker("destroy").removeAttr("id");
            if (maxDate !== null) {
              custom.maxDate = maxDate;
            }
          }
          break;
        case "date_to":
          if($(".datepick[name='date_from']").val() != '')
          {
            minDate = $(".datepick[name='date_from']").datepicker({
              firstDay: $this.attr("rel"),
              dateFormat: $this.attr("rev"),
            }).datepicker("getDate");
            $(".datepick[name='date_from']").datepicker("destroy").removeAttr("id");
            if (minDate !== null) {
              custom.minDate = minDate;
            }
          }
          break;
      }
      $(this).datepicker($.extend(o, custom));

    }).on("click", ".pj-form-field-icon-date", function (e) {
      var $dp = $(this).parent().siblings("input[type='text']");
      if ($dp.hasClass("hasDatepicker")) {
        $dp.datepicker("show");
      } else {
        $dp.trigger("focusin").datepicker("show");
      }
    }).on("change", "#location_id", function (e) {
      generateReport.call(null);
    }).on("change", "#filter_status", function (e) {
      $('.frm-filter').submit();
    }).on("submit", ".frm-filter", function (e) {
      if (e && e.preventDefault) {
        e.preventDefault();
      }
      var $this = $(this),
        content = $grid.datagrid("option", "content"),
        cache = $grid.datagrid("option", "cache");
      $.extend(cache, {
        date_from: $this.find("input[name='date_from']").val(),
        date_to: $this.find("input[name='date_to']").val(),
        status: $this.find("select[name='status']").val()
      });
      $grid.datagrid("option", "cache", cache);
      $grid.datagrid("load", "index.php?controller=pjKiosk&action=pjAjaxOrderList", "createdTime", "DESC", content.page, content.rowCount);
      return false;
    });

  });



})(jQuery);
