(function ($, undefined) {
	$(function () {
		var datagrid = ($.fn.datagrid !== undefined);

    function onBeforeShow (obj) {
      if (parseInt(obj.id, 10) === pjGrid.currentRestaurantId || parseInt(obj.id, 10) === 1) {
        return false;
      }
      return true;
    }

		if ($("#grid").length > 0 && datagrid) {
			
			var gridOpts = {
				buttons: [
          {type: "edit", url: "index.php?controller=pjKiosk&action=pjActionKioskUpdate&id={:id}"},
          {type: "delete", url: "index.php?controller=pjKiosk&action=pjActionKioskDelete&id={:id}", beforeShow: onBeforeShow}
        ],
				columns: [{text: myLabel.rid, type: "text", sortable: true, editable: false, width: 65},
                  {text: myLabel.id, type: "text", sortable: true, editable: false, width: 65},
                  {text: myLabel.name, type: "text", sortable: true, editable: false, width: 120},
				          {text: myLabel.description, type: "text", sortable: true, editable: false},
                  {text: myLabel.pre_receipt_name, type: "text", sortable: true, editable: false},
				          {text: myLabel.setting, type: "text", sortable: true, editable: false}
				          ],
				dataUrl: "index.php?controller=pjKiosk&action=pjAjaxKioskList" + pjGrid.queryString,
				dataType: "json",
				fields: ['rid', 'id', 'name', 'description', 'pre_receipt_name', 'setting'],
				paginator: {
					actions: [],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				}
			};
			$("#grid").datagrid(gridOpts);
		}
	});
})(jQuery);
