<?php
if (!defined("ROOT_PATH")) {
    header("HTTP/1.1 403 Forbidden");
    exit;
}

class pjKioskAppController extends pjPlugin
{
    private $kiosk_id;
    public $pathConfig;
    public $pathStatic;

    public function __construct()
    {
        $this->kiosk_id = "kiosk_of_rid_" . $this->getForeignId();
        $this->setLayout('pjActionAdmin');
        $this->setKioskList();

        if ($this->getKioskId() > 0) {
            $this->pathConfig = "files/" . $this->getForeignId() . "/" . $this->getKioskId() . "/config";
            $this->pathStatic = "files/" . $this->getForeignId() . "/" . $this->getKioskId() . "/static";
            if (!file_exists($this->pathConfig)) {
                mkdir($this->pathConfig, 0777, true);
            }

            if (!file_exists($this->pathStatic)) {
                mkdir($this->pathStatic, 0777, true);
            }

            /*Kiểm tra đã có config chưa, nếu chưa thì lấy data mẫu*/
            $template = PJ_PLUGINS_PATH . "pjKiosk/config/template.general.json";
            if (!file_exists($this->pathConfig . "/config.json") && file_exists($template)) {
                copy($template, $this->pathConfig . "/config.json");

                /*Thêm id printer nếu chưa có*/
                $config = json_decode(file_get_contents($this->pathConfig . "/config.json"), true);
                $printers = $config['printers'];
                foreach ($printers as $k => $v) {
                    if ($v['id'] == '') {
                        $printers[$k]['id'] = uniqid();
                    }
                }
                $config['printers'] = $printers;
                file_put_contents($this->pathConfig . "/config.json", json_encode($config, JSON_UNESCAPED_UNICODE));
            }

            /*Kiểm tra đã có custom products chưa, nếu chưa thì tạo mới*/
            if (!file_exists($this->pathConfig . "/custom_products.json")) {
                file_put_contents($this->pathConfig . "/custom_products.json", json_encode(array(), JSON_UNESCAPED_UNICODE));
            }
        }
    }

    public static function getConst($const)
    {
        $registry = pjRegistry::getInstance();
        $store = $registry->get('pjKiosk');
        return isset($store[$const]) ? $store[$const] : NULL;
    }

    private function setKioskList()
    {
        $data = pjKioskModel::factory()->where('t1.rid', $this->getForeignId())->findAll()->getData();
        $this->set('kiosk_list', $data);

        if (count($data) == 0) {
            $this->setKioskId(0);
        } else if ($this->getKioskId() == 0 && count($data) > 0) {
            $this->setKioskId($data[0]['id']);
        }

        $this->appendJs('jquery.min.js', PJ_THIRD_PARTY_PATH . 'jquery/');
        $this->appendJs('pjKiosk.js', $this->getConst('PLUGIN_JS_PATH'));
    }

    public function getKioskId()
    {
        return isset($_SESSION[$this->kiosk_id]) && (int)$_SESSION[$this->kiosk_id] > 0 ? (int)$_SESSION[$this->kiosk_id] : 0;
    }

    public function setKioskId($kioskId)
    {
        $_SESSION[$this->kiosk_id] = (int)$kioskId;
    }

    public function getKiosk()
    {
        return pjKioskModel::factory()->find($this->getKioskId())->getData();
    }

    public function getKioskById($kioskId)
    {
        return pjKioskModel::factory()->find($kioskId)->getData();
    }

    public function getSettingDataById($rid, $kid)
    {
        $pathStatic = "files/" . $rid . "/" . $kid . "/static";
        return json_decode(file_get_contents($pathStatic . "/setting.json"), true);
    }

    public function getConfigDataById($rid, $kid)
    {
        $pathConfig = "files/" . $rid . "/" . $kid . "/config";
        return json_decode(file_get_contents($pathConfig . "/config.json"), true);
    }

    public function getConfigData()
    {
        return json_decode(file_get_contents($this->pathConfig . "/config.json"), true);
    }

    public function setConfigData($config)
    {
        return file_put_contents($this->pathConfig . "/config.json", json_encode($config, JSON_UNESCAPED_UNICODE));
    }

    public function getCustomProductsData()
    {
        return json_decode(file_get_contents($this->pathConfig . "/custom_products.json"), true);
    }

    public function setCustomProductsData($custom_products)
    {
        return file_put_contents($this->pathConfig . "/custom_products.json", json_encode($custom_products, JSON_UNESCAPED_UNICODE));
    }

    public function getCustomExtrasData()
    {
        return json_decode(file_get_contents($this->pathConfig . "/custom_extras.json"), true);
    }

    public function setCustomExtrasData($custom_extras)
    {
        return file_put_contents($this->pathConfig . "/custom_extras.json", json_encode($custom_extras, JSON_UNESCAPED_UNICODE));
    }

    public function getCustomModifiersData()
    {
        return json_decode(file_get_contents($this->pathConfig . "/custom_modifiers.json"), true);
    }

    public function setCustomModifiersData($custom_modifiers)
    {
        return file_put_contents($this->pathConfig . "/custom_modifiers.json", json_encode($custom_modifiers, JSON_UNESCAPED_UNICODE));
    }

    public function getPrinterById($rid, $kid, $printer_id)
    {
        $config = $this->getSettingDataById($rid, $kid);
        foreach ($config['printers'] as $key => $printer) {
            if ($printer['id'] == $printer_id) {
                return $printer;
            }
        }
        return null;
    }
}

?>
