<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminModifiers extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['modifier_create']))
			{
				$data = array();
				$data['restaurant_id'] = $this->getForeignId();
				$id = pjModifierModel::factory(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AMOD03';
					if (isset($_POST['i18n']))
					{
						$pjModifierItemModel = pjModifierItemModel::factory();
						$pjMultiLangModel = pjMultiLangModel::factory();
							
						$i18n_arr = array();
						foreach ($_POST['i18n'] as $locale => $locale_arr) {
							foreach ($locale_arr as $field => $content)
							{
								if ($field != 'item_name') {
									$i18n_arr[$locale][$field] = $content;
								}
							}
						}
						$pjMultiLangModel->saveMultiLang($i18n_arr, $id, 'pjModifier', 'data');
						
						if(isset($_POST['index_arr']) && $_POST['index_arr'] != '')
						{
							$index_arr = explode("|", $_POST['index_arr']);
							foreach($index_arr as $k => $v)
							{
								if(strpos($v, 'fd') !== false)
								{
									$mi_data = array();
									$mi_data['modifier_id'] = $id;
									$mi_data['price'] = $_POST['item_price'][$v];
									$item_id = $pjModifierItemModel->reset()->setAttributes($mi_data)->insert()->getInsertId();
									if ($item_id !== false && (int) $item_id > 0)
									{
										foreach ($_POST['i18n'] as $locale => $locale_arr)
										{
											foreach ($locale_arr as $field => $content)
											{
												if(is_array($content))
												{
													$insert_id = $pjMultiLangModel->reset()->setAttributes(array(
														'foreign_id' => $item_id,
														'model' => 'pjModifierItem',
														'locale' => $locale,
														'field' => $field,
														'content' => $content[$v],
														'source' => 'data'
													))->insert()->getInsertId();
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					$err = 'AMOD04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminModifiers&action=pjActionIndex&err=$err");
			} else {
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
						
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file']; 
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
		
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminModifiers.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeleteModifier()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjModifierModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjMultiLangModel::factory()->where('model', 'pjModifier')->where('foreign_id', $_GET['id'])->eraseAll();
				$mi_ids = pjModifierItemModel::factory()->where('t1.modifier_id', $_GET['id'])->findAll()->getDataPair(NULL, 'id');
				if ($mi_ids) {
					pjModifierItemModel::factory()->reset()->whereIn('id', $mi_ids)->eraseAll();
					pjMultiLangModel::factory()->reset()->where('model', 'pjModifierItem')->whereIn('foreign_id', $mi_ids)->eraseAll();	
				}
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteModifierBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjModifierModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				pjMultiLangModel::factory()->where('model', 'pjModifier')->whereIn('foreign_id', $_POST['record'])->eraseAll();
				
				$mi_ids = pjModifierItemModel::factory()->whereIn('t1.modifier_id', $_POST['record'])->findAll()->getDataPair(NULL, 'id');
				if ($mi_ids) {
					pjModifierItemModel::factory()->reset()->whereIn('id', $mi_ids)->eraseAll();
					pjMultiLangModel::factory()->reset()->where('model', 'pjModifierItem')->whereIn('foreign_id', $mi_ids)->eraseAll();	
				}
			}
		}
		exit;
	}
	
	public function pjActionGetModifier()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjModifierModel = pjModifierModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjModifier' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left');
			
			$pjModifierModel->where('t1.restaurant_id', $this->getForeignId());
				
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjModifierModel->where('t2.content LIKE', "%$q%");
			}

			$column = 'name';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjModifierModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 20;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$data = $pjModifierModel
				->select('t1.*, t2.content AS name, 
						  (SELECT COUNT(t3.product_id) FROM `'.pjProductModifierModel::factory()->getTable().'` AS t3 WHERE t3.modifier_id=t1.id) as products')
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
				
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminModifiers.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveModifier()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjModifierModel = pjModifierModel::factory();
			if (!in_array($_POST['column'], $pjModifierModel->getI18n()))
			{
				$pjModifierModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjModifier', 'data');
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['modifier_update']))
			{
				pjModifierModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
				if (isset($_POST['i18n']))
				{
					$i18n_arr = array();
					foreach ($_POST['i18n'] as $locale => $locale_arr) {
						foreach ($locale_arr as $field => $content)
						{
							if ($field != 'item_name') {
								$i18n_arr[$locale][$field] = $content;
							}
						}
					}
					pjMultiLangModel::factory()->updateMultiLang($i18n_arr, $_POST['id'], 'pjModifier', 'data');
					
					$pjMultiLangModel = pjMultiLangModel::factory();
					$pjModifierItemModel = pjModifierItemModel::factory();
					
					if(isset($_POST['index_arr']) && $_POST['index_arr'] != '')
					{
						$index_arr = explode("|", $_POST['index_arr']);
						foreach($index_arr as $k => $v)
						{
							if(strpos($v, 'fd') !== false)
							{
								$mi_data = array();
								$mi_data['modifier_id'] = $_POST['id'];
								$mi_data['price'] = $_POST['item_price'][$v];
								$item_id = $pjModifierItemModel->reset()->setAttributes($mi_data)->insert()->getInsertId();
								if ($item_id !== false && (int) $item_id > 0)
								{
									foreach ($_POST['i18n'] as $locale => $locale_arr)
									{
										foreach ($locale_arr as $field => $content)
										{
											if(is_array($content))
											{
												$insert_id = $pjMultiLangModel->reset()->setAttributes(array(
													'foreign_id' => $item_id,
													'model' => 'pjModifierItem',
													'locale' => $locale,
													'field' => $field,
													'content' => $content[$v],
													'source' => 'data'
												))->insert()->getInsertId();
											}
										}
									}
								}
							}else{
								$mi_data = array();
								$mi_data['price'] = $_POST['item_price'][$v];
								$pjModifierItemModel->reset()->where('id', $v)->limit(1)->modifyAll($mi_data);
								foreach ($_POST['i18n'] as $locale => $locale_arr)
								{
									foreach ($locale_arr as $field => $content)
									{
										if(is_array($content))
										{
											$sql = sprintf("INSERT INTO `%1\$s` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`)
												VALUES (NULL, :foreign_id, :model, :locale, :field, :update_content, :source)
												ON DUPLICATE KEY UPDATE `content` = :update_content, `source` = :source;",
												$pjMultiLangModel->getTable()
											);
											$foreign_id = $v;
											$model = 'pjModifierItem';
											$source = 'data';
											$update_content = $content[$v];
											$modelObj = $pjMultiLangModel->reset()->prepare($sql)->exec(compact('foreign_id', 'model', 'locale', 'field', 'update_content', 'source'));
											if ($modelObj->getAffectedRows() > 0 || $modelObj->getInsertId() > 0)
											{
												
											}
										}
									}
								}
							}
						}
					}
					
					if(isset($_POST['remove_arr']) && $_POST['remove_arr'] != '')
					{
						$remove_arr = explode("|", $_POST['remove_arr']);
						$pjMultiLangModel->reset()->where('model', 'pjModifierItem')->whereIn('foreign_id', $remove_arr)->eraseAll();
						$pjModifierItemModel->reset()->whereIn('id', $remove_arr)->eraseAll();
					}					
				}
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminModifiers&action=pjActionIndex&err=AMOD01");
				
			} else {
				$arr = pjModifierModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0 || ($arr && $arr['restaurant_id'] != $this->getForeignId()))
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminModifiers&action=pjActionIndex&err=AMOD08");
				}
				$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjModifier');
				$this->set('arr', $arr);
				
				$item_arr = pjModifierItemModel::factory()->where('modifier_id', $_GET['id'])->findAll()->getData();
				foreach($item_arr as $k => $v)
				{
					$item_arr[$k]['i18n'] = pjMultiLangModel::factory()->getMultiLang($v['id'], 'pjModifierItem');
				}
				$this->set('item_arr', $item_arr);
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file']; 
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminModifiers.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
}
?>