<?php
$type_err = __('type_err', true, false);
$ts = time();
if (empty($tpl['wt_arr']))
{
	echo $type_err[1];
	exit;
}
if (empty($_GET['location_id']) || !isset($tpl['wt_arr']['end_ts']))
{
	exit;
}

$index = $_GET['index'];
$STORAGE = @$_SESSION[$controller->defaultStore];

switch ($_GET['type'])
{
	case 'pickup':
		$time_key = 'p_time';
		break;
	case 'delivery':
		$time_key = 'd_time';
		break;
	case 'catering':
		$time_key = 'ca_time';
		break;
}
$time = isset($STORAGE) && isset($STORAGE[$time_key]) ? $STORAGE[$time_key] : NULL;

$start_time = strtotime(date($tpl['date'] . ' 00:00:00'));
$end_time = strtotime(date($tpl['date'] . ' 23:45:00'));

if (isset($tpl['wt_arr']))
{
	$start_time = strtotime($tpl['date'] . ' ' . $tpl['wt_arr']['start_hour'] . ':' . $tpl['wt_arr']['start_minutes'] . ':00');
	$end_time = strtotime($tpl['date'] . ' ' . $tpl['wt_arr']['end_hour'] . ':' . $tpl['wt_arr']['end_minutes'] . ':00');
}
if($end_time < $start_time)
{
	$end_time += 86400;
}
if ($end_time < $ts)
{
	echo $type_err[3]; ?>
	<div style="height: 1px !important; opacity: 0 !important;">
		<select name="ca_time" class="form-control fdSelect required" data-err="<?php __('front_time_required');?>">
			<option value=""></option>
		</select>
	</div>
	<?php 
	exit;
}
if ($_GET['type'] == 'catering' && $end_time < $ts + ((int)$tpl['option_arr']['o_catering_hours_in_advance'] * 3600)) {
	echo sprintf($type_err[4], (int)$tpl['option_arr']['o_catering_hours_in_advance']);
	?>
	<div style="height: 1px !important; opacity: 0 !important;">
		<select name="ca_time" class="form-control fdSelect required" data-err="<?php __('front_time_required');?>">
			<option value=""></option>
		</select>
	</div>
	<?php 
	exit;
}

$midnight = strtotime($tpl['date'] . ' 23:59:59');

$interval = 900;
$next = pjUtil::getCurrentTimeSnap15Minutes();
if($start_time < $next)
{
	$start_time = $next;
}
?>
<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
	<select id="<?php echo $time_key . '_' . $index;?>" name="<?php echo $time_key;?>" class="form-control fdSelect fdSelectTime required" data-err="<?php __('front_time_required');?>">
		<?php if ($time_key == 'd_time' && $tpl['option_arr']['o_allow_delivery_doordash'] == 'Yes') { ?>
			<option value="asap"><?php __('front_asap');?></option>
		<?php } else { 
			if($ts >= $tpl['wt_arr']['start_ts'] && $ts <= $tpl['wt_arr']['end_ts'] && $_GET['type'] != 'catering')
			{ 
				?>
				<option value="asap"><?php __('front_asap');?></option>
				<?php
			}
			for($i = $start_time; $i <= $end_time; $i += $interval)
			{
				if ($_GET['type'] == 'catering' && $i < $ts + ((int)$tpl['option_arr']['o_catering_hours_in_advance'] * 3600)) {
					continue;
				}
				$is_lunch_break = false;
				if (isset($tpl['location_wt_arr']['break_time']) && count($tpl['location_wt_arr']['break_time']) > 0) {
					foreach ($tpl['location_wt_arr']['break_time'] as $bt) {
						if ($i >= $bt['lunch_break_from_ts'] && $i < $bt['lunch_break_to_ts']) {
							$is_lunch_break = true;
							continue;	
						}
					}
				}
				if (!$is_lunch_break) {
					$iso_time = date($tpl['option_arr']['o_time_format'], $i);
					$time_text = $iso_time;
					if($i > $midnight )
					{
						$time_text .= ' (' . __('front_next_day', true) . ')';
					}
					?><option value="<?php echo $iso_time;?>"<?php echo $iso_time == $time ? ' selected="selected"' : null; ?>><?php echo $time_text;?></option><?php
				}	
			} 
		}
		?>
	</select>
</div>