<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$jqTimeFormat = pjUtil::jqTimeFormat($tpl['option_arr']['o_time_format']);
	
	$_yesno = __('_yesno', true, false);
	?>
	<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
		<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
			<li class="ui-state-default ui-corner-top ui-tabs-active ui-state-active"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOrders&amp;action=pjActionIndex"><?php __('menuOrders'); ?></a></li>
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionIndex"><?php __('menuClients'); ?></a></li>
		</ul>
	</div>
	<?php
	pjUtil::printNotice(__('infoUpdateOrderTitle', true, false), __('infoUpdateOrderDesc', true, false)); 
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOrders&amp;action=pjActionUpdate" method="post" class="form pj-form" id="frmUpdateOrder">
		<input type="hidden" name="order_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']?>" />
		<input type="hidden" name="external_delivery_id" id="external_delivery_id" value="<?php echo $tpl['arr']['external_delivery_id'];?>" />
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('lblOrderDetails');?></a></li>
				<li><a href="#tabs-2"><?php __('tabClientDetails');?></a></li>
			</ul>
			<div id="tabs-1">
				<fieldset class="fieldset white">
					<legend><?php __('lblProducts'); ?></legend>
					<table class="fdOrderList" id="fdOrderList">
						<thead>
							<tr class="fdLine">
								<th width="166"><?php __('lblProduct');?></th>
								<th width="145"><?php __('lblSizeAndPrice');?></th>
								<th width="70" class="splitter"><?php __('lblQty');?></th>
								<th width="145" class="fdPL5"><?php __('lblExtra');?></th>
								<th width="70"><?php __('lblQty');?></th>
								<th width="30" class="splitter">&nbsp;</th>
								<th width="70" class="fdPL5"><?php __('lblTotal');?></th>
								<th width="30">&nbsp;</th>
							</tr>
						</thead>
						<tbody class="main-body">
							<?php
							foreach ($tpl['product_arr'] as $k => $product)
							{
								foreach ($tpl['oi_arr'] as $oi)
								{
									if ($oi['type'] == 'product' && $oi['foreign_id'] == $product['id'])
									{
										$has_extra = false;
										?>
										<tr class="fdLine" data-index="<?php echo $oi['hash']; ?>">
											<td width="166">
												<select id="fdProduct_<?php echo $oi['hash']; ?>" data-index="<?php echo $oi['hash']; ?>" name="product_id[<?php echo $oi['hash']; ?>]" class="pj-form-field fdProduct w160">
													<option value="">-- <?php __('lblChoose'); ?>--</option>
													<?php
													foreach ($tpl['product_arr'] as $p)
													{
														if($p['id'] == $product['id'] && $p['cnt_extras'] > 0)
														{
															$has_extra = true;
														}
														?><option value="<?php echo $p['id']; ?>"<?php echo $p['id'] == $product['id'] ? ' selected="selected"' : NULL; ?> data-extra="<?php echo $p['cnt_extras'];?>"><?php echo stripslashes($p['name']); ?></option><?php
													}
													?>
												</select>
											</td>
											<td width="145" id="fdPriceTD_<?php echo $oi['hash']; ?>">
												<div class="business-<?php echo $oi['hash']; ?>">
													<?php
													if(empty($oi['price_id']))
													{
														?>
															<span class="fdPriceLabel"><?php echo pjUtil::formatCurrencySign(number_format($product['price'], 2), $tpl['option_arr']['o_currency']);?></span>
															<input type="hidden" id="fdPrice_<?php echo $oi['hash']; ?>" data-type="input" name="price_id[<?php echo $oi['hash']; ?>]" value="<?php echo $product['price'];?>" />
														<?php
													} else {
														if(isset($oi['price_arr']) && $oi['price_arr'])
														{
															?>
															<select id="fdPrice_<?php echo $oi['hash']; ?>" name="price_id[<?php echo $oi['hash']; ?>]" data-type="select" class="fdSize pj-form-field w140">
																<option value="">-- <?php __('lblChoose'); ?>--</option>
																<?php
																foreach ($oi['price_arr'] as $pr)
																{
																	?><option value="<?php echo $pr['id']; ?>"<?php echo $pr['id'] == $oi['price_id'] ? ' selected="selected"' : NULL; ?> data-price="<?php echo $pr['price'];?>"><?php echo stripslashes($pr['price_name']).": ".pjUtil::formatCurrencySign(number_format($pr['price'], 2), $tpl['option_arr']['o_currency']); ?></option><?php
																} 
																?>
															</select>
															<?php
														} else {
															?><input type="hidden" id="fdPrice_<?php echo $oi['hash']; ?>" name="price_id[<?php echo $oi['hash']; ?>]" value="" /><?php
														}
													}
													?>
												</div>
											</td>
											<td width="70" class="splitter">
												<div class="business-<?php echo $oi['hash']; ?>">
													<input type="text" id="fdProductQty_<?php echo $oi['hash']; ?>" name="cnt[<?php echo $oi['hash']; ?>]" class="pj-form-field w50 float_left pj-field-count" value="<?php echo $oi['cnt']; ?>" />
												</div>
											</td>
											<td  width="236" colspan="3" class="splitter fdPL5">
												<div class="business-<?php echo $oi['hash']; ?>">
													<table id="fdExtraTable_<?php echo $oi['hash']; ?>" class="pj-extra-table" cellpadding="0" cellspacing="0" style="width: auto">							
														<tbody>
															<?php
															foreach ($tpl['extra_arr'] as $extra)
															{
																foreach ($tpl['oi_arr'] as $oi_sub)
																{
																	if ($oi_sub['type'] == 'extra' && $oi_sub['hash'] == $oi['hash'] && $oi_sub['foreign_id'] == $extra['id'])
																	{
																		?>
																		<tr>
																			<td width="145">
																				<select name="extra_id[<?php echo $oi['hash']; ?>][<?php echo $oi_sub['id']; ?>]" data-index="<?php echo $oi['hash']; ?>_<?php echo $oi_sub['id']; ?>" class="fdExtra fdExtra_<?php echo $oi['hash']; ?> pj-form-field w130">
																					<option value="">-- <?php __('lblChoose'); ?>--</option>
																					<?php
																					foreach ($tpl['extra_arr'] as $e)
																					{
																						if (in_array($e['id'], $product['allowed_extras']))
																						{
																							?><option value="<?php echo $e['id']; ?>"<?php echo $e['id'] == $extra['id'] ? ' selected="selected"' : NULL; ?> data-price="<?php echo $e['price'];?>"><?php echo stripslashes($e['name']); ?>: <?php echo pjUtil::formatCurrencySign($e['price'], $tpl['option_arr']['o_currency'])?></option><?php
																						}
																					}
																					?>
																				</select>
																			</td>
																			<td class="w70"><input type="text" id="fdExtraQty_<?php echo $oi['hash']; ?>_<?php echo $oi_sub['id']; ?>" name="extra_cnt[<?php echo $oi['hash']; ?>][<?php echo $oi_sub['id']; ?>]" class="pj-form-field w50 float_left pj-field-count" value="<?php echo $oi_sub['cnt']; ?>" /></td>
																			<td class="w30"><a href="#" class="pj-remove-extra"></a></td>
																		</tr>
																		<?php
																	}
																}
															} 
															?>
														</tbody>
													</table>
													<input type="button" value="<?php __('btnAddExtra');?>" data-index="<?php echo $oi['hash']; ?>" class="pj-button float_left pj-add-extra fdExtraBusiness_<?php echo $oi['hash'];?> fdExtraButton_<?php echo $oi['hash'];?>" style="display:<?php echo $has_extra == true ? 'block' : 'none'; ?>;"/>
													<span class="fdExtraBusiness_<?php echo $oi['hash'];?> fdExtraNA_<?php echo $oi['hash'];?>" style="display:<?php echo $has_extra == false ? 'block' : 'none'; ?>;"><?php __('lblNA');?></span>
												</div>
												<br/><br/>
												<div class="business-<?php echo $oi['hash']; ?> fdProductGroupsContainer-<?php echo $oi['hash']; ?>">
													<?php $group_arr = isset($tpl['group_arr'][$product['id']]) ? $tpl['group_arr'][$product['id']] : array();?>
													<?php foreach ($group_arr as $pg) { ?>
														<?php if (isset($tpl['group_item_arr'][$pg['id']]) && count($tpl['group_item_arr'][$pg['id']]) > 0) { ?>
															<table width="100%" cellpadding="5" cellspacing="5" class="fdProductGroupsTable">
																<tr>
																	<td width="40%"><?php echo pjSanitize::html($pg['group_name']);?></td>
																	<td>
																		<?php foreach ($tpl['group_item_arr'][$pg['id']] as $pgi) { 
																			$pgi_checked = '';
																			foreach ($tpl['oi_arr'] as $oi_sub)
																			{
																				if ($oi_sub['type'] == 'group' && $oi_sub['hash'] == $oi['hash'] && $oi_sub['foreign_id'] == $pgi['id'])
																				{
																					$pgi_checked = ' checked="checked"';
																					break;
																				}
																			}
																														
																			?>
																			<div class="b5"><input type="radio" <?php echo $pgi_checked;?> name="group_item_id[<?php echo $oi['hash']; ?>][<?php echo $pg['id']; ?>]" id="group_item_id_<?php echo $oi['hash']; ?>_<?php echo $pgi['id']; ?>" value="<?php echo $pgi['id'];?>" />&nbsp;<label for="group_item_id_<?php echo $oi['hash']; ?>_<?php echo $pgi['id']; ?>"><?php echo pjSanitize::html($pgi['group_item_name']);?></label></div>
																		<?php } ?>
																	</td>
																</tr>
															</table>
														<?php } ?>
													<?php } ?>
												</div>
												
												<br/>
												<div class="business-<?php echo $oi['hash']; ?> fdProductModifiersContainer-<?php echo $oi['hash']; ?>">
													<?php $modifier_arr = isset($tpl['modifier_arr'][$product['id']]) ? $tpl['modifier_arr'][$product['id']] : array();?>
													<?php foreach ($modifier_arr as $mo) { ?>
														<?php if (isset($tpl['modifier_item_arr'][$mo['modifier_id']]) && count($tpl['modifier_item_arr'][$mo['modifier_id']]) > 0) { ?>
															<table width="100%" cellpadding="5" cellspacing="5" class="fdProductModifiersTable">
																<tr>
																	<td width="40%"><?php echo pjSanitize::html($mo['modifier_name']);?></td>
																	<td>
																		<?php foreach ($tpl['modifier_item_arr'][$mo['modifier_id']] as $pmi) { 
																			$pmi_checked = '';
																			foreach ($tpl['oi_arr'] as $oi_sub)
																			{
																				if ($oi_sub['type'] == 'modifier_item' && $oi_sub['hash'] == $oi['hash'] && $oi_sub['foreign_id'] == $pmi['id'])
																				{
																					$pmi_checked = ' checked="checked"';
																					break;
																				}
																			}
																														
																			?>
																			<div class="b5">
																				<?php if ((float)$pmi['price'] > 0) { ?>
																					<input data-price="<?php echo (float)$pmi['price'];?>" class="fdModifierItem fdModifierItem_<?php echo $oi['hash']; ?>" type="checkbox" <?php echo $pmi_checked;?> name="modifier_item_id[<?php echo $oi['hash']; ?>][<?php echo $pmi['id']; ?>]" id="modifier_item_id_<?php echo $oi['hash']; ?>_<?php echo $pmi['id']; ?>" value="<?php echo $pmi['id'];?>" />&nbsp;<label for="modifier_item_id_<?php echo $oi['hash']; ?>_<?php echo $pmi['id']; ?>"><?php echo pjSanitize::html($pmi['modifier_item_name']);?> (<?php echo pjUtil::formatCurrencySign(number_format($pmi['price'], 2), $tpl['option_arr']['o_currency']);?>)</label>
																				<?php } else { ?>
																					<input data-price="<?php echo (float)$pmi['price'];?>" class="fdModifierItem fdModifierItem_<?php echo $oi['hash']; ?>" type="checkbox" <?php echo $pmi_checked;?> name="modifier_item_id[<?php echo $oi['hash']; ?>][<?php echo $pmi['id']; ?>]" id="modifier_item_id_<?php echo $oi['hash']; ?>_<?php echo $pmi['id']; ?>" value="<?php echo $pmi['id'];?>" />&nbsp;<label for="modifier_item_id_<?php echo $oi['hash']; ?>_<?php echo $pmi['id']; ?>"><?php echo pjSanitize::html($pmi['modifier_item_name']);?></label>
																				<?php } ?>
																			</div>
																		<?php } ?>
																	</td>
																</tr>
															</table>
														<?php } ?>
													<?php } ?>
												</div>
												
											</td>
											<td width="70" class="fdPL5">
												<span id="fdTotalPrice_<?php echo $oi['hash']; ?>" class="fdPriceLabel">&nbsp;</span>
											</td>
											<td width="30">
												<?php
												if($k > 0)
												{ 
													?><a href="#" class="pj-remove-product"></a><?php
												}else{
													echo '&nbsp;';
												} 
												?>
											</td>
										</tr>
										<?php
									}
								}
							}
							?>
						</tbody>
					</table>
					
					<div class="overflow">
						<input type="button" id="btnAddProduct" value="<?php __('btnAddProduct');?>" class="pj-button float_left r10" />
						<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
					</div>
				</fieldset>
				
				<fieldset class="fieldset white">
					<legend><?php __('lblPaymentsOtherDetails'); ?></legend>
					<div class="overflow">
						<div class="float_left w50p overflow">
							<p>
								<label class="title"><?php __('lblOrderID'); ?></label>
								<span class="inline-block">
									<input type="text" name="uuid" id="uuid" class="pj-form-field w100" readonly="readonly" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['uuid'])); ?>"/>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblType'); ?></label>
								<span class="inline_block">
									<select name="type" id="type" class="pj-form-field required">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach (__('types', true, false) as $k => $v)
										{
											?><option value="<?php echo $k; ?>"<?php echo $tpl['arr']['type'] == $k ? ' selected="selected"' : NULL;?>><?php echo stripslashes($v); ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblStatus'); ?></label>
								<span class="inline_block">
									<select name="status" id="status" class="pj-form-field required">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach (__('order_statuses', true, false) as $k => $v)
										{
											?><option value="<?php echo $k; ?>"<?php echo $tpl['arr']['status'] == $k ? ' selected="selected"' : NULL;?>><?php echo stripslashes($v); ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							
							<p>
								<label class="title"><?php __('lblPaymentMethod');?></label>
								<span class="inline-block">
									<select name="payment_method" id="payment_method" class="pj-form-field w150 required">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach (__('payment_methods', true, false) as $k => $v)
										{
											?><option value="<?php echo $k; ?>"<?php echo $tpl['arr']['payment_method'] == $k ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<?php $isCC = $tpl['arr']['payment_method'] == 'creditcard'; ?>
							<p class="boxCC" style="display: <?php echo !$isCC ? 'none' : NULL; ?>;">
								<label class="title"><?php __('lblCCType'); ?></label>
								<span class="inline-block">
									<select name="cc_type" class="pj-form-field w150">
										<option value="">---</option>
										<?php
										foreach (__('cc_types', true, false) as $k => $v)
										{
											?><option value="<?php echo $k; ?>"<?php echo $tpl['arr']['cc_type'] == $k ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<p class="boxCC" style="display: <?php echo !$isCC ? 'none' : NULL; ?>;">
								<label class="title"><?php __('lblCCNum'); ?></label>
								<span class="inline-block">
									<input type="text" name="cc_num" id="cc_num" class="pj-form-field w136" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['cc_num'])); ?>"/>
								</span>
							</p>
							<p class="boxCC" style="display: <?php echo !$isCC ? 'none' : NULL; ?>;">
								<?php
								$ey = $em = NULL;
								if (strpos($tpl['arr']['cc_exp'], "/") !== false)
								{
									list($em, $ey) = explode("/", $tpl['arr']['cc_exp']);
								} 
								?>
								<label class="title"><?php __('lblCCExp'); ?></label>
								<span class="inline-block">
									<select name="cc_exp_month" class="pj-form-field">
										<option value="">---</option>
										<?php
										$month_arr = __('months', true, false);
										ksort($month_arr);
										foreach ($month_arr as $key => $val)
										{
											?><option value="<?php echo $key;?>"<?php echo $em == $key ? ' selected="selected"' : NULL; ?>><?php echo $val;?></option><?php
										}
										?>
									</select>
									<select name="cc_exp_year" class="pj-form-field">
										<option value="">---</option>
										<?php
										$y = (int) date('Y');
										for ($i = $y; $i <= $y + 10; $i++)
										{
											?><option value="<?php echo $i; ?>"<?php echo $ey == $i ? ' selected="selected"' : NULL; ?>><?php echo $i; ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<p class="boxCC" style="display: <?php echo !$isCC ? 'none' : NULL; ?>;">
								<label class="title"><?php __('lblCCCode'); ?></label>
								<span class="inline-block">
									<input type="text" name="cc_code" id="cc_code" class="pj-form-field w100" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['cc_code'])); ?>"/>
								</span>
							</p>
							
							<p>
								<label class="title">&nbsp;</label>
								<span class="inline-block">
									<input type="checkbox" name="receive_sms_messages" id="receive_sms_messages" value="1" <?php echo $tpl['arr']['receive_sms_messages'] == 1 ? 'checked="checked"' : '';?> />
									<label for="receive_sms_messages"><?php __('front_receive_order_sms_mesages');?></label>
								</span>
							</p>
							
							<p>
								<label class="title"><?php __('lblClient'); ?></label>
								<span class="inline_block">
									<label class="title"><a href="#" class="pjFdOpenClientTab"><?php echo $tpl['arr']['client_name']; ?></a></label>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblIpAddress'); ?></label>
								<span class="inline_block">
									<label class="title"><?php echo $tpl['arr']['ip'];?></label>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblDateTime'); ?></label>
								<span class="inline_block">
									<label class="title"><?php echo pjUtil::formatDate(date("Y-m-d", strtotime($tpl['arr']['created'])), "Y-m-d", $tpl['option_arr']['o_date_format']);?>, <?php echo pjUtil::formatTime(date("H:i:s", strtotime($tpl['arr']['created'])), "H:i:s", $tpl['option_arr']['o_time_format']);?></label>
								</span>
							</p>
							<?php if ((int)$tpl['arr']['is_dashdoor_delivery'] == 1) { 
								$delivery_statuses = __('delivery_statuses', true);
								?>
								<p>
									<label class="title"><?php __('lblDeliveryStatus'); ?></label>
									<span class="inline_block">
										<label class="title"><?php echo @$delivery_statuses[$tpl['arr']['delivery_status']];?></label>
									</span>
								</p>
							<?php } ?>
							<p>
								<label class="title">&nbsp;</label>
								<span class="inline_block">
									<input type="button" value="<?php __('btnPrint');?>" class="pj-button" onclick="window.open('<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOrders&amp;action=pjActionPrintOrder&amp;id=<?php echo $tpl['arr']['id']; ?>&hash=<?php echo sha1($tpl['arr']['id'].$tpl['arr']['created'].PJ_SALT)?>')"/>
									<input type="button" value="<?php __('btnPrintNormal');?>" class="pj-button" onclick="window.open('<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOrders&amp;action=pjActionPrintOrderNormal&amp;id=<?php echo $tpl['arr']['id']; ?>&hash=<?php echo sha1($tpl['arr']['id'].$tpl['arr']['created'].PJ_SALT)?>')"/>
									<input type="button" id="btnEmail" data-id="<?php echo $tpl['arr']['id'];?>" value="<?php __('btnEmail');?>" class="pj-button" />
								</span>
							</p>
							
							<p>
								<span class="block b10">
									<input type="button" id="btnRePrintToRemotePrinter" data-id="<?php echo $tpl['arr']['id'];?>" data-type="1" value="<?php __('btnRePrintToRemotePrinter');?>" class="pj-button" />
								</span>
								<span class="block b10">
									<input type="button" id="btnPrintToRemotePrinter" data-id="<?php echo $tpl['arr']['id'];?>" data-type="2" value="<?php __('btnPrintToRemotePrinter');?>" class="pj-button" />
								</span>
								<span class="block b10">
									<input type="button" id="btnSendConfirmedOrderSms" data-id="<?php echo $tpl['arr']['id'];?>" value="<?php __('btnConfirmedOrderSMS');?>" class="pj-button" />
								</span>
								<span class="block">
									<input type="button" id="btnSendReadyForPickupSms" data-id="<?php echo $tpl['arr']['id'];?>" value="<?php __('btnReadyForPickupSMS');?>" class="pj-button" />
								</span>
							</p>							
						</div>
						<div class="float_left w50p overflow">
							<p>
								<label class="title"><?php __('lblOrderIsPaid'); ?></label>
								<span class="inline_block">
									<select name="is_paid" id="is_paid" class="pj-form-field required">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<option value="1"<?php echo $tpl['arr']['is_paid'] == 1 ? ' selected="selected"' : NULL;?>><?php echo $_yesno['T']; ?></option>
										<option value="0"<?php echo $tpl['arr']['is_paid'] == 0 ? ' selected="selected"' : NULL;?>><?php echo $_yesno['F']; ?></option>
									</select>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblPrice'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="price" name="price" class="pj-form-field number w80 required" readonly="readonly" value="<?php echo $tpl['arr']['price']; ?>" />
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblDelivery'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="price_delivery" name="price_delivery" class="pj-form-field number w80" readonly="readonly" value="<?php echo $tpl['arr']['price_delivery']; ?>" />
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblDiscount'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="discount" name="discount" class="pj-form-field number w80" readonly="readonly" value="<?php echo $tpl['arr']['discount']; ?>" />
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblSubTotal'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="subtotal" name="subtotal" class="pj-form-field number w80" readonly="readonly" value="<?php echo $tpl['arr']['subtotal']; ?>" />
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblTax'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="tax" name="tax" class="pj-form-field number w80" readonly="readonly" value="<?php echo $tpl['arr']['tax']; ?>" />
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblServiceFee'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="service_fee" name="service_fee" class="pj-form-field number w80" readonly="readonly" value="<?php echo $tpl['arr']['service_fee']; ?>" />
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblCateringFee'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="catering_fee" name="catering_fee" class="pj-form-field number w80" readonly="readonly" value="<?php echo $tpl['arr']['catering_fee']; ?>" />
								</span>
							</p>
							
							<p>
								<label class="title"><?php __('lblOrderTipOptions'); ?></label>
								<select name="tip_option" id="tip_option" class="pj-form-field">
									<?php foreach (__('_tip_options', true) as $k => $v) { ?>
										<option value="<?php echo $k;?>" <?php echo $k == $tpl['arr']['tip_option'] ? 'selected="selected"' : '';?>><?php echo $v;?></option>
									<?php } ?>
								</select>
							</p>
							
							<p class="pjTipPercentage" style="display:<?php echo $tpl['arr']['tip_option'] == 1 ? '' : 'none';?>">
								<label class="title"><?php __('lblOrderTipPercentage'); ?></label>
								<select id="tip_percentage" name="tip_percentage" class="pj-form-field w80">
									<?php foreach (range(1, 6) as $val) { ?>
										<?php if ((int)$tpl['option_arr']['o_tip_'.$val] > 0) { ?>
											<option value="<?php echo (int)$tpl['option_arr']['o_tip_'.$val];?>" <?php echo (int)$tpl['option_arr']['o_tip_'.$val] == $tpl['arr']['tip_percentage'] ? 'selected="selected"' : '';?>><?php echo (int)$tpl['option_arr']['o_tip_'.$val];?>%</option>
										<?php } ?>
									<?php } ?>
								</select>
							</p>
							
							<p class="pjTipAmount" style="display:<?php echo $tpl['arr']['tip_option'] != 0 ? '' : 'none';?>">
								<label class="title"><?php __('lblOrderTipAmount'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="tip_amount" name="tip_amount" class="pj-form-field number w80" <?php echo $tpl['arr']['tip_option'] == 2 ? '' : 'readonly="readonly"';?> value="<?php echo $tpl['arr']['tip_amount']; ?>" />
									<input type="hidden" id="dasher_tip_amount" name="dasher_tip_amount" class="pj-form-field number w80" value="<?php echo $tpl['arr']['dasher_tip_amount']; ?>" />
								</span>
							</p>
														
							<p>
								<label class="title"><?php __('lblTotal'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="total" name="total" class="pj-form-field number w80" readonly="readonly" value="<?php echo $tpl['arr']['total']; ?>"/>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblVoucher'); ?></label>
								<span class="inline-block">
									<input type="text" name="voucher_code" id="voucher_code" class="pj-form-field w100" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['voucher_code'])); ?>"/>
								</span>
							</p>
							<p>
								<label class="title">&nbsp;</label>
								<span class="inline-block">
									<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
									<input type="button" id="btnCalc" value="<?php __('btnCalculateTotal');?>" class="pj-button" />
								</span>
							</p>
						</div>
					</div>
				</fieldset>
				
			</div>
			<div id="tabs-2">
				<div class="overflow">
					<?php
					if(!empty($tpl['client_arr']))
					{ 
						?>
						<p class="client-container">
							<label class="title"><?php __('lblExistingClient'); ?></label>
							<span class="inline-block">
								<span class="block float_left r5">
									<select name="client_id" id="client_id" class="pj-form-field w500 required">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach ($tpl['client_arr'] as $v)
										{
											$email_phone = array();
											if(!empty($v['c_email']))
											{
												$email_phone[] = stripslashes($v['c_email']);
											}
											if(!empty($v['c_phone']))
											{
												$email_phone[] = stripslashes($v['c_phone']);
											}	
											?><option value="<?php echo $v['id']; ?>"<?php echo $v['id'] == $tpl['arr']['client_id'] ? ' selected="selected"' : NULL;?>><?php echo stripslashes($v['c_name']); ?> (<?php echo join(" | ", $email_phone); ?>)</option><?php
										}
										?>
									</select>
								</span>
								<a id="pjFdEditClient" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionUpdate&id=<?php echo $tpl['arr']['client_id'];?>" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionUpdate&id={ID}" class="pj-edit-client"></a>
							</span>
						</p>
						<?php
					} 
					?>
					<fieldset class="fieldset white pickup" style="display: <?php echo $tpl['arr']['type'] == 'pickup' ? NULL : 'none'; ?>;">
						<legend><?php __('lblPickupAddress'); ?></legend>
						<p>
							<label class="title"><?php __('lblLocation');?></label>
							<span class="inline-block">
								<select name="p_location_id" id="p_location_id" class="pj-form-field w400 required">
									<option value="">-- <?php __('lblChoose'); ?>--</option>
									<?php
									foreach ($tpl['location_arr'] as $location)
									{
										?><option value="<?php echo $location['id']; ?>"<?php echo $location['id'] == $tpl['arr']['location_id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($location['name']); ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<?php
						$date_time = !empty($tpl['arr']['p_dt']) ?  pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['p_dt'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['p_dt'])), 'H:i:s', $tpl['option_arr']['o_time_format']) : ''; 
						?>
						<p>
							<label class="title"><?php __('lblPickerDateTime'); ?></label>
							<span class="block overflow">
								<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
									<input type="text" name="p_dt" id="p_dt" class="pj-form-field pointer w150 datetimepick required" readonly="readonly" data-wt="open" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>" value="<?php echo $date_time;?>"/>
									<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
								</span>
								<?php
								if($tpl['arr']['p_asap'] == 'T')
								{
									?><label class="content">&nbsp;<?php __('lblAsap');?></label><?php
								} 
								?>
							</span>
						</p>
						<?php
						if (in_array($tpl['option_arr']['o_pf_include_notes'], array(2, 3)))
						{
							?>
							<p>
								<label class="title"><?php __('lblSpecialInstructions'); ?></label>
								<span class="inline-block">
									<textarea name="p_notes" id="p_notes" class="pj-form-field w500 h120<?php echo $tpl['option_arr']['o_pf_include_notes'] == 3 ? ' required' : NULL; ?>"><?php echo stripslashes($tpl['arr']['p_notes']); ?></textarea>
								</span>
							</p>
							<?php
						} 
						?>
						<p>
							<label class="title">&nbsp;</label>
							<span class="inline-block">
								<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
								<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminOrders&action=pjActionIndex';" />
							</span>
						</p>
					</fieldset>
					<fieldset class="fieldset white delivery" style="display: <?php echo $tpl['arr']['type'] == 'delivery' ? NULL : 'none'; ?>;">
						<legend><?php __('lblDeliveryAddress'); ?></legend>
						<p>
							<label class="title"><?php __('lblLocation');?></label>
							<span class="inline-block">
								<select name="d_location_id" id="d_location_id" class="pj-form-field w400 required">
									<option value="">-- <?php __('lblChoose'); ?>--</option>
									<?php
									foreach ($tpl['location_arr'] as $location)
									{
										?><option value="<?php echo $location['id']; ?>"<?php echo $location['id'] == $tpl['arr']['location_id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($location['name']); ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<?php
						if (in_array($tpl['option_arr']['o_df_include_address_1'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblAddress1'); ?></label>
								<span class="inline-block">
									<input type="text" name="d_address_1" id="d_address_1" class="pj-form-field w400<?php echo $tpl['option_arr']['o_df_include_address_1'] == 3 ? ' required' : NULL; ?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['d_address_1'])); ?>"/>
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_df_include_address_2'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblAddress2'); ?></label>
								<span class="inline-block">
									<input type="text" name="d_address_2" id="d_address_2" class="pj-form-field w400<?php echo $tpl['option_arr']['o_df_include_address_2'] == 3 ? ' required' : NULL; ?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['d_address_2'])); ?>"/>
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_df_include_city'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblCity'); ?></label>
								<span class="inline-block">
									<input type="text" name="d_city" id="d_city" class="pj-form-field w300<?php echo $tpl['option_arr']['o_df_include_city'] == 3 ? ' required' : NULL; ?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['d_city'])); ?>"/>
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_df_include_state'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblState'); ?></label>
								<span class="inline-block">
									<input type="text" name="d_state" id="d_state" class="pj-form-field w300<?php echo $tpl['option_arr']['o_df_include_state'] == 3 ? ' required' : NULL; ?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['d_state'])); ?>"/>
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_df_include_state'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblZip'); ?></label>
								<span class="inline-block">
									<input type="text" name="d_zip" id="d_zip" class="pj-form-field w300<?php echo $tpl['option_arr']['o_df_include_zip'] == 3 ? ' required' : NULL; ?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['d_zip'])); ?>"/>
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_df_include_country'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblCountry'); ?></label>
								<span class="inline-block">
									<select name="d_country_id" id="d_country_id" class="pj-form-field w300<?php echo $tpl['option_arr']['o_df_include_country'] == 3 ? ' required' : NULL; ?>">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach ($tpl['country_arr'] as $v)
										{
											?><option value="<?php echo $v['id']; ?>"<?php echo $v['id'] == $tpl['arr']['d_country_id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['country_title']); ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_df_include_notes'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblSpecialInstructions'); ?></label>
								<span class="inline-block">
									<textarea name="d_notes" id="d_notes" class="pj-form-field w500 h120<?php echo $tpl['option_arr']['o_df_include_notes'] == 3 ? ' required' : NULL; ?>"><?php echo stripslashes($tpl['arr']['d_notes']); ?></textarea>
								</span>
							</p>
							<?php
						}
						$date_time = !empty($tpl['arr']['d_dt']) ? pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['d_dt'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['d_dt'])), 'H:i:s', $tpl['option_arr']['o_time_format']) : ''; 
						?>
						<p>
							<label class="title"><?php __('lblDeliveryDateTime'); ?></label>
							<span class="block overflow">
								<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
									<input type="text" name="d_dt" id="d_dt" class="pj-form-field pointer w150 datetimepick required" readonly="readonly" data-wt="open" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>" value="<?php echo $date_time;?>"/>
									<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
								</span>
								<?php
								if($tpl['arr']['d_asap'] == 'T')
								{
									?><label class="content">&nbsp;<?php __('lblAsap');?></label><?php
								} 
								?>
							</span>
						</p>
						<p>
							<label class="title">&nbsp;</label>
							<span class="inline-block">
								<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
								<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminOrders&action=pjActionIndex';" />
							</span>
						</p>
					</fieldset>
					
					<fieldset class="fieldset white catering" style="display: <?php echo $tpl['arr']['type'] == 'catering' ? NULL : 'none'; ?>;">
						<legend><?php __('lblCateringAddress'); ?></legend>
						<p>
							<label class="title"><?php __('lblLocation');?></label>
							<span class="inline-block">
								<select name="ca_location_id" id="ca_location_id" class="pj-form-field w400">
									<option value="">-- <?php __('lblChoose'); ?>--</option>
									<?php
									foreach ($tpl['location_arr'] as $location)
									{
										?><option value="<?php echo $location['id']; ?>"<?php echo $location['id'] == $tpl['arr']['location_id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($location['name']); ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<?php
						if (in_array($tpl['option_arr']['o_cf_include_address_1'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblAddress1'); ?></label>
								<span class="inline-block">
									<input type="text" name="ca_address_1" id="ca_address_1" value="<?php echo stripslashes($tpl['arr']['ca_address_1']);?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_cf_include_address_2'] == 3 ? ' fdRequired' : NULL; ?>" />
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_cf_include_address_2'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblAddress2'); ?></label>
								<span class="inline-block">
									<input type="text" name="ca_address_2" id="ca_address_2" value="<?php echo stripslashes($tpl['arr']['ca_address_2']);?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_cf_include_address_2'] == 3 ? ' fdRequired' : NULL; ?>" />
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_cf_include_city'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblCity'); ?></label>
								<span class="inline-block">
									<input type="text" name="ca_city" id="ca_city" value="<?php echo stripslashes($tpl['arr']['ca_city']);?>" class="pj-form-field w300<?php echo $tpl['option_arr']['o_cf_include_city'] == 3 ? ' fdRequired' : NULL; ?>"/>
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_cf_include_state'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblState'); ?></label>
								<span class="inline-block">
									<input type="text" name="ca_state" id="ca_state" value="<?php echo stripslashes($tpl['arr']['ca_state']);?>" class="pj-form-field w300<?php echo $tpl['option_arr']['o_cf_include_state'] == 3 ? ' fdRequired' : NULL; ?>" />
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_cf_include_zip'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblZip'); ?></label>
								<span class="inline-block">
									<input type="text" name="ca_zip" id="ca_zip" value="<?php echo stripslashes($tpl['arr']['ca_zip']);?>" class="pj-form-field w300<?php echo $tpl['option_arr']['o_cf_include_zip'] == 3 ? ' fdRequired' : NULL; ?>" />
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_cf_include_country'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblCountry'); ?></label>
								<span class="inline-block">
									<select name="ca_country_id" id="ca_country_id" class="pj-form-field w300<?php echo $tpl['option_arr']['o_cf_include_country'] == 3 ? ' fdRequired' : NULL; ?>">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach ($tpl['country_arr'] as $v)
										{
											?><option value="<?php echo $v['id']; ?>" <?php echo $tpl['arr']['ca_country_id'] == $v['id'] ? 'selected="selected"' : null;?>><?php echo stripslashes($v['country_title']); ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_cf_include_notes'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblSpecialInstructions'); ?></label>
								<span class="inline-block">
									<textarea name="ca_notes" id="ca_notes" class="pj-form-field w500 h120<?php echo $tpl['option_arr']['o_cf_include_notes'] == 3 ? ' fdRequired' : NULL; ?>"><?php echo stripslashes($tpl['arr']['ca_notes']); ?></textarea>
								</span>
							</p>
							<?php
						} 
						$date_time = !empty($tpl['arr']['ca_dt']) ? pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['ca_dt'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['ca_dt'])), 'H:i:s', $tpl['option_arr']['o_time_format']) : ''; 
						?>
						<p>
							<label class="title"><?php __('lblCateringDateTime'); ?></label>
							<span class="block overflow">
								<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
									<input type="text" name="ca_dt" id="ca_dt" value="<?php echo $date_time;?>" class="pj-form-field pointer w150 datetimepick" readonly="readonly" data-wt="open" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>"/>
									<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
								</span>
							</span>
						</p>
						<p>
							<label class="title">&nbsp;</label>
							<span class="inline-block">
								<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
								<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminOrders&action=pjActionIndex';" />
							</span>
						</p>
					</fieldset>
					
				</div>
			</div>
		</div><!-- #tabs -->
	</form>
	<table style="display: none" id="boxProductClone">
		<tbody>
		<?php
		include PJ_VIEWS_PATH . 'pjAdminOrders/elements/clone.php'; 
		?>
		</tbody>
	</table>
	
	<div id="dialogReminderEmail" title="<?php __('lblReminderEmail', false, true); ?>" style="display: none"></div>
	<div id="dialogConfirm" title="<?php __('lblInfoMessage', false, true); ?>" style="display: none"><?php __('lblConfirmationContent');?></div>
	<div id="dialogPrintToRemotePrinter" title="<?php __('lblPrintToRemotePrinterTitle', false, true); ?>" style="display: none"><?php __('lblPrintToRemotePrinterMessage');?></div>
	<div id="dialogSendConfirmedOrderSms" title="<?php __('lblConfirmedOrderSmsTitle', false, true); ?>" style="display: none"><?php __('lblConfirmedOrderSmsMessage');?></div>
	<div id="dialogSendReadyForPickupSms" title="<?php __('lblReadyForPickupSmsTitle', false, true); ?>" style="display: none"><?php __('lblReadyForPickupSmsMessage');?></div>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.currency = "<?php echo $tpl['option_arr']['o_currency'];?>";
	myLabel.restaurant_closed = "<?php __('lblRestaurantClosed');?>";
	myLabel.btnSmsToOwner = "<?php __('btnSmsToOwner');?>";
	myLabel.btnSmsToCustomer = "<?php __('btnSmsToCustomer');?>";
	</script>
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{		
		$tab_id = $_GET['tab_id'];
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "selected", <?php echo $tab_id; ?>);
			});
		})(jQuery);
		</script>
		<?php
	}
}
?>