<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$jqTimeFormat = pjUtil::jqTimeFormat($tpl['option_arr']['o_time_format']);
	
	$_yesno = __('_yesno', true, false);
	?>
	<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
		<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
			<li class="ui-state-default ui-corner-top ui-tabs-active ui-state-active"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOrders&amp;action=pjActionIndex"><?php __('menuOrders'); ?></a></li>
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionIndex"><?php __('menuClients'); ?></a></li>
		</ul>
	</div>
	<?php
	pjUtil::printNotice(__('infoAddOrderTitle', true, false), __('infoAddOrderDesc', true, false)); 
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOrders&amp;action=pjActionCreate" method="post" class="form pj-form" id="frmCreateOrder">
		<input type="hidden" name="order_create" value="1" />
		<input type="hidden" name="external_delivery_id" id="external_delivery_id" value="" />
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('lblOrderDetails');?></a></li>
				<li><a href="#tabs-2"><?php __('tabClientDetails');?></a></li>
			</ul>
			<div id="tabs-1">
				<fieldset class="fieldset white">
					<legend><?php __('lblProducts'); ?></legend>
					<!-- <div id="fdProductList"></div> -->
					
					<table class="fdOrderList" id="fdOrderList">
						<thead>
							<tr class="fdLine">
								<th width="166"><?php __('lblProduct');?></th>
								<th width="145"><?php __('lblSizeAndPrice');?></th>
								<th width="70" class="splitter"><?php __('lblQty');?></th>
								<th width="145" class="fdPL5"><?php __('lblExtra');?></th>
								<th width="70"><?php __('lblQty');?></th>
								<th width="30" class="splitter">&nbsp;</th>
								<th width="70" class="fdPL5"><?php __('lblTotal');?></th>
								<th width="30">&nbsp;</th>
							</tr>
						</thead>
						<tbody class="main-body">
							<?php
							$index = "new_" . mt_rand(0, 999999); 
							?>
							<tr class="fdLine" data-index="<?php echo $index;?>">
								<td width="166">
									<select id="fdProduct_<?php echo $index;?>" data-index="<?php echo $index;?>" name="product_id[<?php echo $index;?>]" class="pj-form-field fdProduct w160">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach ($tpl['product_arr'] as $p)
										{
											?><option value="<?php echo $p['id']; ?>" data-extra="<?php echo $p['cnt_extras'];?>"><?php echo stripslashes($p['name']); ?></option><?php
										}
										?>
									</select>
								</td>
								<td width="145" id="fdPriceTD_<?php echo $index;?>">
									<div class="business-<?php echo $index;?>" style="display: none;">
										<select id="fdPrice_<?php echo $index;?>" name="price_id[<?php echo $index;?>]" data-type="select" class="fdSize pj-form-field w140">
											<option value="">-- <?php __('lblChoose'); ?>--</option>
										</select>
									</div>
								</td>
								<td width="70" class="splitter">
									<div class="business-<?php echo $index;?>" style="display: none;">
										<input type="text" id="fdProductQty_<?php echo $index;?>" name="cnt[<?php echo $index;?>]" class="pj-form-field w50 float_left pj-field-count" value="1" />
									</div>
								</td>
								<td  width="236" colspan="3" class="splitter fdPL5">
									<div class="business-<?php echo $index;?>" style="display: none;">
										<table id="fdExtraTable_<?php echo $index;?>" class="pj-extra-table" cellpadding="0" cellspacing="0" style="width: auto">							
											<tbody>
											</tbody>
										</table>
										<input type="button" value="<?php __('btnAddExtra');?>" data-index="<?php echo $index;?>" class="pj-button float_left pj-add-extra fdExtraBusiness_<?php echo $index;?> fdExtraButton_<?php echo $index;?>" />
										<span class="fdExtraBusiness_<?php echo $index;?> fdExtraNA_<?php echo $index;?>"><?php __('lblNA');?></span>
									</div>
									<br/><br/>
									<div class="business-<?php echo $index;?> fdProductGroupsContainer-<?php echo $index;?>"></div>
									<br/>
									<div class="business-<?php echo $index;?> fdProductModifiersContainer-<?php echo $index;?>"></div>
								</td>
								<td width="70" class="fdPL5">
									<span id="fdTotalPrice_<?php echo $index;?>" class="fdPriceLabel"><?php echo pjUtil::formatCurrencySign(number_format(0, 2), $tpl['option_arr']['o_currency']);?></span>
								</td>
								<td width="30">
									&nbsp;
								</td>
							</tr>
						</tbody>
					</table>
					
					<div class="overflow">
						<input type="button" id="btnAddProduct" value="<?php __('btnAddProduct');?>" class="pj-button float_left r10" />
						<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
					</div>
				</fieldset>
				
				<fieldset class="fieldset white">
					<legend><?php __('lblPaymentsOtherDetails'); ?></legend>
					<div class="overflow">
						<div class="float_left w50p overflow">
							<p>
								<label class="title"><?php __('lblType'); ?></label>
								<span class="inline_block">
									<select name="type" id="type" class="pj-form-field required">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach (__('types', true, false) as $k => $v)
										{
											?><option value="<?php echo $k; ?>"><?php echo stripslashes($v); ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblStatus'); ?></label>
								<span class="inline_block">
									<select name="status" id="status" class="pj-form-field required">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach (__('order_statuses', true, false) as $k => $v)
										{
											?><option value="<?php echo $k; ?>"><?php echo stripslashes($v); ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							
							<p>
								<label class="title"><?php __('lblPaymentMethod');?></label>
								<span class="inline-block">
									<select name="payment_method" id="payment_method" class="pj-form-field w150 required">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach (__('payment_methods', true, false) as $k => $v)
										{
											?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<p class="boxCC" style="display: none;">
								<label class="title"><?php __('lblCCType'); ?></label>
								<span class="inline-block">
									<select name="cc_type" class="pj-form-field w150">
										<option value="">---</option>
										<?php
										foreach (__('cc_types', true, false) as $k => $v)
										{
											?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<p class="boxCC" style="display: none;">
								<label class="title"><?php __('lblCCNum'); ?></label>
								<span class="inline-block">
									<input type="text" name="cc_num" id="cc_num" class="pj-form-field w136" />
								</span>
							</p>
							<p class="boxCC" style="display: none;">
								<label class="title"><?php __('lblCCExp'); ?></label>
								<span class="inline-block">
									<select name="cc_exp_month" class="pj-form-field">
										<option value="">---</option>
										<?php
										$month_arr = __('months', true, false);
										ksort($month_arr);
										foreach ($month_arr as $key => $val)
										{
											?><option value="<?php echo $key;?>"><?php echo $val;?></option><?php
										}
										?>
									</select>
									<select name="cc_exp_year" class="pj-form-field">
										<option value="">---</option>
										<?php
										$y = (int) date('Y');
										for ($i = $y; $i <= $y + 10; $i++)
										{
											?><option value="<?php echo $i; ?>"><?php echo $i; ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<p class="boxCC" style="display: none">
								<label class="title"><?php __('lblCCCode'); ?></label>
								<span class="inline-block">
									<input type="text" name="cc_code" id="cc_code" class="pj-form-field w100" />
								</span>
							</p>
							
							<p>
								<label class="title">&nbsp;</label>
								<span class="inline-block">
									<input type="checkbox" name="receive_sms_messages" id="receive_sms_messages" value="1" checked="checked" />
									<label for="receive_sms_messages"><?php __('front_receive_order_sms_mesages');?></label>
								</span>
							</p>
							
							<p>
								<label class="title">&nbsp;</label>
								<span class="inline-block">
									<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
									<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminOrders&action=pjActionIndex';" />
								</span>
							</p>
						</div>
						<div class="float_left w50p overflow">
							<p>
								<label class="title"><?php __('lblOrderIsPaid'); ?></label>
								<span class="inline_block">
									<select name="is_paid" id="is_paid" class="pj-form-field required">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<option value="1"><?php echo $_yesno['T']; ?></option>
										<option value="0"><?php echo $_yesno['F']; ?></option>
									</select>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblPrice'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="price" name="price" class="pj-form-field number w80 required" readonly="readonly"/>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblDelivery'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="price_delivery" name="price_delivery" class="pj-form-field number w80" readonly="readonly"/>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblDiscount'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="discount" name="discount" class="pj-form-field number w80" readonly="readonly"/>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblSubTotal'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="subtotal" name="subtotal" class="pj-form-field number w80" readonly="readonly"/>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblTax'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="tax" name="tax" class="pj-form-field number w80" readonly="readonly"/>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblServiceFee'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="service_fee" name="service_fee" class="pj-form-field number w80" readonly="readonly" value="<?php echo (float) $tpl['option_arr']['o_service_fee']; ?>"/>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblCateringFee'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="catering_fee" name="catering_fee" class="pj-form-field number w80" readonly="readonly" />
								</span>
							</p>
							
							<p>
								<label class="title"><?php __('lblOrderTipOptions'); ?></label>
								<select name="tip_option" id="tip_option" class="pj-form-field">
									<?php foreach (__('_tip_options', true) as $k => $v) { ?>
										<option value="<?php echo $k;?>" <?php echo $k == 0 ? 'selected="selected"' : '';?>><?php echo $v;?></option>
									<?php } ?>
								</select>
							</p>
							
							<p class="pjTipPercentage" style="display:none;">
								<label class="title"><?php __('lblOrderTipPercentage'); ?></label>
								<select id="tip_percentage" name="tip_percentage" class="pj-form-field w80">
									<?php foreach (range(1, 6) as $val) { ?>
										<?php if ((int)$tpl['option_arr']['o_tip_'.$val] > 0) { ?>
											<option value="<?php echo (int)$tpl['option_arr']['o_tip_'.$val];?>"><?php echo (int)$tpl['option_arr']['o_tip_'.$val];?>%</option>
										<?php } ?>
									<?php } ?>
								</select>
							</p>
							
							<p class="pjTipAmount" style="display:none;">
								<label class="title"><?php __('lblOrderTipAmount'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="tip_amount" name="tip_amount" class="pj-form-field number w80" readonly="readonly" />
									<input type="hidden" id="dasher_tip_amount" name="dasher_tip_amount" class="pj-form-field number w80"  />
								</span>
							</p>
							
							<p>
								<label class="title"><?php __('lblTotal'); ?></label>
								<span class="pj-form-field-custom pj-form-field-custom-before">
									<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
									<input type="text" id="total" name="total" class="pj-form-field number w80" readonly="readonly"/>
								</span>
							</p>
							<p>
								<label class="title"><?php __('lblVoucher'); ?></label>
								<span class="inline-block">
									<input type="text" name="voucher_code" id="voucher_code" class="pj-form-field w100" />
								</span>
							</p>
							<p>
								<label class="title">&nbsp;</label>
								<span class="inline-block">
									<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
									<input type="button" id="btnCalc" value="<?php __('btnCalculateTotal');?>" class="pj-button" />
								</span>
							</p>
						</div>
					</div>
				</fieldset>
				
			</div>
			<div id="tabs-2">
				<div class="overflow">
					<?php
					if(!empty($tpl['client_arr']))
					{ 
						?>
						<p class="client-container">
							<label class="title"><?php __('lblExistingClient'); ?></label>
							<span class="inline-block">
								<span class="block float_left r5">
									<select name="client_id" id="client_id" class="pj-form-field w500 required">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach ($tpl['client_arr'] as $v)
										{
											$email_phone = array();
											if(!empty($v['c_email']))
											{
												$email_phone[] = stripslashes($v['c_email']);
											}
											if(!empty($v['c_phone']))
											{
												$email_phone[] = stripslashes($v['c_phone']);
											}
											?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['c_name']); ?> (<?php echo join(" | ", $email_phone); ?>)</option><?php
										}
										?>
									</select>
								</span>
								<a id="pjFdEditClient" href="#" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionUpdate&id={ID}" class="pj-edit-client" style="display:none;"></a>
							</span>
						</p>
						<?php
					} 
					?>
					<fieldset class="fieldset white pickup" style="display:none">
						<legend><?php __('lblPickupAddress'); ?></legend>
						<p>
							<label class="title"><?php __('lblLocation');?></label>
							<span class="inline-block">
								<select name="p_location_id" id="p_location_id" class="pj-form-field w400">
									<option value="">-- <?php __('lblChoose'); ?>--</option>
									<?php
									foreach ($tpl['location_arr'] as $location)
									{
										?><option value="<?php echo $location['id']; ?>"><?php echo stripslashes($location['name']); ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblPickerDateTime'); ?></label>
							<span class="block overflow">
								<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
									<input type="text" name="p_dt" id="p_dt" class="pj-form-field pointer w150 datetimepick" readonly="readonly" data-wt="open" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>"/>
									<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
								</span>
							</span>
						</p>
						<?php
						if (in_array($tpl['option_arr']['o_pf_include_notes'], array(2, 3)))
						{
							?>
							<p>
								<label class="title"><?php __('lblSpecialInstructions'); ?></label>
								<span class="inline-block">
									<textarea name="p_notes" id="p_notes" class="pj-form-field w500 h120<?php echo $tpl['option_arr']['o_pf_include_notes'] == 3 ? ' fdRequired' : NULL; ?>"></textarea>
								</span>
							</p>
							<?php
						} 
						?>
						<p>
							<label class="title">&nbsp;</label>
							<span class="inline-block">
								<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
								<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminOrders&action=pjActionIndex';" />
							</span>
						</p>
					</fieldset>
					
					<fieldset class="fieldset white delivery" style="display:none">
						<legend><?php __('lblDeliveryAddress'); ?></legend>
						<p>
							<label class="title"><?php __('lblLocation');?></label>
							<span class="inline-block">
								<select name="d_location_id" id="d_location_id" class="pj-form-field w400">
									<option value="">-- <?php __('lblChoose'); ?>--</option>
									<?php
									foreach ($tpl['location_arr'] as $location)
									{
										?><option value="<?php echo $location['id']; ?>"><?php echo stripslashes($location['name']); ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<?php
						if (in_array($tpl['option_arr']['o_df_include_address_1'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblAddress1'); ?></label>
								<span class="inline-block">
									<input type="text" name="d_address_1" id="d_address_1" class="pj-form-field w400<?php echo $tpl['option_arr']['o_df_include_address_2'] == 3 ? ' fdRequired' : NULL; ?>" />
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_df_include_address_2'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblAddress2'); ?></label>
								<span class="inline-block">
									<input type="text" name="d_address_2" id="d_address_2" class="pj-form-field w400<?php echo $tpl['option_arr']['o_df_include_address_2'] == 3 ? ' fdRequired' : NULL; ?>" />
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_df_include_city'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblCity'); ?></label>
								<span class="inline-block">
									<input type="text" name="d_city" id="d_city" class="pj-form-field w300<?php echo $tpl['option_arr']['o_df_include_city'] == 3 ? ' fdRequired' : NULL; ?>"/>
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_df_include_state'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblState'); ?></label>
								<span class="inline-block">
									<input type="text" name="d_state" id="d_state" class="pj-form-field w300<?php echo $tpl['option_arr']['o_df_include_state'] == 3 ? ' fdRequired' : NULL; ?>" />
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_df_include_zip'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblZip'); ?></label>
								<span class="inline-block">
									<input type="text" name="d_zip" id="d_zip" class="pj-form-field w300<?php echo $tpl['option_arr']['o_df_include_zip'] == 3 ? ' fdRequired' : NULL; ?>" />
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_df_include_country'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblCountry'); ?></label>
								<span class="inline-block">
									<select name="d_country_id" id="d_country_id" class="pj-form-field w300<?php echo $tpl['option_arr']['o_df_include_country'] == 3 ? ' fdRequired' : NULL; ?>">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach ($tpl['country_arr'] as $v)
										{
											?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['country_title']); ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_df_include_notes'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblSpecialInstructions'); ?></label>
								<span class="inline-block">
									<textarea name="d_notes" id="d_notes" class="pj-form-field w500 h120<?php echo $tpl['option_arr']['o_df_include_notes'] == 3 ? ' fdRequired' : NULL; ?>"></textarea>
								</span>
							</p>
							<?php
						} 
						?>
						<p>
							<label class="title"><?php __('lblDeliveryDateTime'); ?></label>
							<span class="block overflow">
								<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
									<input type="text" name="d_dt" id="d_dt" class="pj-form-field pointer w150 datetimepick" readonly="readonly" data-wt="open" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>"/>
									<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
								</span>
							</span>
						</p>
						<p>
							<label class="title">&nbsp;</label>
							<span class="inline-block">
								<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
								<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminOrders&action=pjActionIndex';" />
							</span>
						</p>
					</fieldset>
					
					<fieldset class="fieldset white catering" style="display:none">
						<legend><?php __('lblCateringAddress'); ?></legend>
						<p>
							<label class="title"><?php __('lblLocation');?></label>
							<span class="inline-block">
								<select name="ca_location_id" id="ca_location_id" class="pj-form-field w400">
									<option value="">-- <?php __('lblChoose'); ?>--</option>
									<?php
									foreach ($tpl['location_arr'] as $location)
									{
										?><option value="<?php echo $location['id']; ?>"><?php echo stripslashes($location['name']); ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<?php
						if (in_array($tpl['option_arr']['o_cf_include_address_1'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblAddress1'); ?></label>
								<span class="inline-block">
									<input type="text" name="ca_address_1" id="ca_address_1" class="pj-form-field w400<?php echo $tpl['option_arr']['o_cf_include_address_2'] == 3 ? ' fdRequired' : NULL; ?>" />
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_cf_include_address_2'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblAddress2'); ?></label>
								<span class="inline-block">
									<input type="text" name="ca_address_2" id="ca_address_2" class="pj-form-field w400<?php echo $tpl['option_arr']['o_cf_include_address_2'] == 3 ? ' fdRequired' : NULL; ?>" />
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_cf_include_city'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblCity'); ?></label>
								<span class="inline-block">
									<input type="text" name="ca_city" id="ca_city" class="pj-form-field w300<?php echo $tpl['option_arr']['o_cf_include_city'] == 3 ? ' fdRequired' : NULL; ?>"/>
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_cf_include_state'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblState'); ?></label>
								<span class="inline-block">
									<input type="text" name="ca_state" id="ca_state" class="pj-form-field w300<?php echo $tpl['option_arr']['o_cf_include_state'] == 3 ? ' fdRequired' : NULL; ?>" />
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_cf_include_zip'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblZip'); ?></label>
								<span class="inline-block">
									<input type="text" name="ca_zip" id="ca_zip" class="pj-form-field w300<?php echo $tpl['option_arr']['o_cf_include_zip'] == 3 ? ' fdRequired' : NULL; ?>" />
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_cf_include_country'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblCountry'); ?></label>
								<span class="inline-block">
									<select name="ca_country_id" id="ca_country_id" class="pj-form-field w300<?php echo $tpl['option_arr']['o_cf_include_country'] == 3 ? ' fdRequired' : NULL; ?>">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach ($tpl['country_arr'] as $v)
										{
											?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['country_title']); ?></option><?php
										}
										?>
									</select>
								</span>
							</p>
							<?php
						}
						if (in_array($tpl['option_arr']['o_cf_include_notes'], array(2, 3)))
						{ 
							?>
							<p>
								<label class="title"><?php __('lblSpecialInstructions'); ?></label>
								<span class="inline-block">
									<textarea name="ca_notes" id="ca_notes" class="pj-form-field w500 h120<?php echo $tpl['option_arr']['o_cf_include_notes'] == 3 ? ' fdRequired' : NULL; ?>"></textarea>
								</span>
							</p>
							<?php
						} 
						?>
						<p>
							<label class="title"><?php __('lblCateringDateTime'); ?></label>
							<span class="block overflow">
								<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
									<input type="text" name="ca_dt" id="ca_dt" class="pj-form-field pointer w150 datetimepick" readonly="readonly" data-wt="open" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>"/>
									<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
								</span>
							</span>
						</p>
						<p>
							<label class="title">&nbsp;</label>
							<span class="inline-block">
								<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
								<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminOrders&action=pjActionIndex';" />
							</span>
						</p>
					</fieldset>

				</div>
			</div>
		</div>
	</form>
	<table style="display: none" id="boxProductClone">
		<tbody>
		<?php
		include PJ_VIEWS_PATH . 'pjAdminOrders/elements/clone.php'; 
		?>
		</tbody>
	</table>
	<div id="dialogConfirm" title="<?php __('lblInfoMessage', false, true); ?>" style="display: none"><?php __('lblConfirmationContent');?></div>
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.currency = "<?php echo $tpl['option_arr']['o_currency'];?>";
	myLabel.restaurant_closed = "<?php __('lblRestaurantClosed');?>";
	</script>
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{		
		$tab_id = $_GET['tab_id'];
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "selected", <?php echo $tab_id; ?>);
			});
		})(jQuery);
		</script>
		<?php
	}
}
?>