<div style="width: 300px; margin: auto; box-shadow: 1px 2px 4px 0px; padding: 15px; background: #f6f6f6; color: black;">
    <div style="padding: 10px 0px; text-align: center; font-weight: bold;">
        <div><?php echo $tpl['res_name']?></div>
        <div>Settlement Report</div>
        <div><?php echo $tpl['date_from']?></div>
    </div>
    <div style="padding: 10px 0px; text-align: center; font-weight: bold; font-size: 20px;">
        <?php echo pjUtil::formatCurrencySign(number_format( (float)$tpl['deposit_amount'], 2 ),  $tpl['option_arr']['o_currency']);?>
    </div>
    <p></p>
    <div>
        <div style="float:left;">KD</div>
        <div style="float:right;"><?php echo $tpl['kid']?></div>
    </div>
    <br><br>

    <div>
        <table class="table-bordered">
            <tr class="header">
                <td>Card</td>
                <td style="text-align: center;">Type</td>
                <td style="text-align: center;">Count</td>
                <td style="text-align: right;">Amount</td>
            </tr>
            <?php
            foreach($tpl['card_arr'] as $k => $v)
            {
                ?>
                <tr>
                    <td><?php echo pjSanitize::html($v['name']);?></td>
                    <td style="text-align: center;"><?php echo pjSanitize::html($v['type']);?></td>
                    <td style="text-align: center;"><?php echo (int) $v['count'];?></td>
                    <td style="text-align: right;"><?php echo pjUtil::formatCurrencySign(number_format( (float)$v['amount'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
                </tr>
                <?php
            }
            ?>
            <tr class="footer">
                <td>TOTAL</td>
                <td style="text-align: center;"></td>
                <td style="text-align: center;"><?php echo $tpl['total_orders'] ?></td>
                <td style="text-align: right;"><?php echo pjUtil::formatCurrencySign(number_format( (float)$tpl['total_sale'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
            </tr>
        </table>
    </div>
    <br><br>

    <div>
        <table class="table-bordered">
            <tr class="header">
                <td>Type</td>
                <td style="text-align: center;">Count</td>
                <td style="text-align: right;">Amount</td>
            </tr>
            <tr>
                <td>Sale</td>
                <td style="text-align: center;"><?php echo $tpl['total_orders'] ?></td>
                <td style="text-align: right;"><?php echo pjUtil::formatCurrencySign(number_format( (float)$tpl['total_sale'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
            </tr>
            <?php if((float)$tpl['merchant_fee']>0) :?>
            <tr>
                <td>Merchant fee</td>
                <td></td>
                <td style="text-align: right;">-<?php echo pjUtil::formatCurrencySign(number_format( (float)$tpl['merchant_fee'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
            </tr>
            <?php endif ?>
            <?php if((float)$tpl['other_fee']>0) :?>
            <tr>
                <td>Discount</td>
                <td></td>
                <td style="text-align: right;">-<?php echo pjUtil::formatCurrencySign(number_format( (float)$tpl['other_fee'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
            </tr>
            <?php endif ?>
            <tr>
                <td>Deposit Amount</td>
                <td></td>
                <td style="text-align: right;"><?php echo pjUtil::formatCurrencySign(number_format( (float)$tpl['deposit_amount'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
            </tr>
        </table>
    </div>
    <br><br>

    <div>
        <table class="table-bordered">
            <tr class="header">
                <td>Tip Breakdown</td>
                <td style="text-align: right;">Amount</td>
            </tr>
            <tr>
                <td>Total tip</td>
                <td style="text-align: right;"><?php echo pjUtil::formatCurrencySign(number_format( (float)$tpl['total_tip'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
            </tr>
        </table>
    </div>
    <br><br>
    <div style="border-top: 1px px #c6bfbf solid; padding: 5px 0px;">End of Report</div>

</div>
<!--<br>
<div align="center">
    <input type="button" value="Export to PDF" class="pj-button" onclick="window.open('<?php /*echo $_SERVER['PHP_SELF']; */?>?controller=pjKiosk&action=pjActionExportReport&date_from=<?php /*echo $tpl['date_from']; */?>&date_to=<?php /*echo $tpl['date_to']; */?>&hash=<?php /*echo sha1(date().PJ_SALT)*/?>')"/>
</div>-->

<?php if(isset($tpl['all_kiosks'])) { ?>
<br><br>
<div style="width: 100%;">
    <div align="center"><h1 style="font-weight: bold;">SUMMARY OTHER KIOSKS</h1></div>
    <br>
    <table class="table-bordered">
        <tr class="header">
            <td>Kiosks</td>
            <td>Description</td>
            <td style="text-align: center;">Sale</td>
            <td style="text-align: center;">Merchant fee</td>
            <td style="text-align: center;">Discount</td>
            <td style="text-align: right;">Deposit Amount</td>
            <td style="text-align: right;">Tip Breakdown</td>
        </tr>
        <?php
        $summary_total_sale=0;
        $summary_total_merchant_fee=0;
        $summary_total_other_fee=0;
        $summary_total_deposit_amount=0;
        $summary_total_tip_breakdown=0;
        foreach($tpl['all_kiosks'] as $k => $v)
        {
            $settlement=$v['settlement'];
            $summary_total_sale+=$settlement['total_sale'];
            $summary_total_merchant_fee+=$settlement['merchant_fee'];
            $summary_total_other_fee+=$settlement['other_fee'];
            $summary_total_deposit_amount+=$settlement['deposit_amount'];
            $summary_total_tip_breakdown+=$settlement['total_tip'];
            ?>
            <tr>
                <td><?php echo pjSanitize::html($v['name']);?></td>
                <td><?php echo pjSanitize::html($v['description']);?></td>
                <td style="text-align: center;"><?php echo pjUtil::formatCurrencySign(number_format( (float)$settlement['total_sale'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
                <td style="text-align: center;">-<?php echo pjUtil::formatCurrencySign(number_format( (float)$settlement['merchant_fee'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
                <td style="text-align: center;">-<?php echo pjUtil::formatCurrencySign(number_format( (float)$settlement['other_fee'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
                <td style="text-align: right;"><?php echo pjUtil::formatCurrencySign(number_format( (float)$settlement['deposit_amount'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
                <td style="text-align: right;"><?php echo pjUtil::formatCurrencySign(number_format( (float)$settlement['total_tip'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
            </tr>
            <?php
        }
        ?>
        <tr class="footer">
            <td>TOTAL</td>
            <td></td>
            <td style="text-align: center;"><?php echo pjUtil::formatCurrencySign(number_format( (float)$summary_total_sale, 2 ),  $tpl['option_arr']['o_currency']);?></td>
            <td style="text-align: center;">-<?php echo pjUtil::formatCurrencySign(number_format( (float)$summary_total_merchant_fee, 2 ),  $tpl['option_arr']['o_currency']);?></td>
            <td style="text-align: center;">-<?php echo pjUtil::formatCurrencySign(number_format( (float)$summary_total_other_fee, 2 ),  $tpl['option_arr']['o_currency']);?></td>
            <td style="text-align: right;"><?php echo pjUtil::formatCurrencySign(number_format( (float)$summary_total_deposit_amount, 2 ),  $tpl['option_arr']['o_currency']);?></td>
            <td style="text-align: right;"><?php echo pjUtil::formatCurrencySign(number_format( (float)$summary_total_tip_breakdown, 2 ),  $tpl['option_arr']['o_currency']);?></td>
        </tr>
    </table>
</div>
<?php } ?>

<style>
    .table-bordered{
        width: 100%;
        border-collapse: collapse;
        border-spacing: 0;
    }

    .table-bordered .header{
        border-bottom: 1px #c6bfbf solid;
        font-weight: bold;
    }

    .table-bordered .footer{
        border-top: 1px #c6bfbf solid;
        font-weight: bold;
    }

    .table-bordered tr td{
        padding: 7px 0px;
        text-align: left;
    }
</style>

