<?php
if (isset($tpl['status'])) {
  $status = __('status', true);
  switch ($tpl['status']) {
    case 2:
      pjUtil::printNotice(NULL, $status[2]);
      break;
  }
  exit;
}

include_once("tabs.php");
pjUtil::printNotice("Kiosk Order Detail", "Detail transaction");

$transaction = $tpl['detail'];
if(!isset($transaction)){
  exit;
}
?>

<?php if($transaction['status']==='Approved') { ?>
  <form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjKiosk&amp;action=pjActionOrderUpdate" method="post" id="change-status" class="form pj-form" style="display: none;">
    <input type="hidden" name="order_update" value="1"/>
    <input type="hidden" name="next_action" value="pjActionOrder"/>
    <input type="hidden" name="id" value="<?php echo $_GET['id']; ?>" />
    <input type="hidden" name="transactionId" value="<?php echo $_GET['transactionId']; ?>" />
    <fieldset class="fieldset white">
      <legend>Change status</legend>
      <table class="pj-table" cellpadding="0" cellspacing="0" style="width: 100%">
        <thead>
        <tr>
          <th><?php __('lblOption'); ?></th>
          <th><?php __('lblValue'); ?></th>
        </tr>
        </thead>
        <tbody>
        <tr class="pj-table-row-odd" style="">
          <td>Status</td>
          <td>
            <select name="status" class="pj-form-field w300" required>
              <?php foreach($tpl['status_list'] as $k=>$v){ ?>
                <option value="<?php echo $v; ?>" <?php echo ($tpl['detail']['status']===$v)? 'selected': '';?>><?php echo $v ?></option>
              <?php } ?>
            </select>
          </td>
        </tr>
        <!--<tr>
          <td>Notes</td>
          <td><textarea class="pj-form-field w300" rows="6" name="notes" required><?php /*echo $transaction['notes']; */?></textarea></td>
        </tr>-->
        </tbody>
      </table>
      <br>

      <div align="center">
        <input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
      </div>
    </fieldset>
  </form>
<?php } ?>

<script>
  function changStatus() {
    var x = document.getElementById("change-status");
    if (x.style.display === "none") {
      x.style.display = "block";
    } else {
      x.style.display = "none";
    }
  }
</script>
<fieldset class="fieldset white">
  <legend>Information</legend>
    <div style="line-height: 20px;">
      <?php
      $color="#39b2df";
      if($transaction['status']=='Approved'){
        $color="#0da20d";
      }else if($transaction['status']=='user cancel'){
        $color="#f6b234";
      }else if($transaction['status']=='Error'){
        $color="#e33d3d";
      }
      ?>
      <p>- Status: <span style="padding: 3px 5px; border-radius: 3px; color: white; background: <?php echo $color; ?>; font-weight: bold;"><?php echo $transaction['status'];?></span> <?php if($transaction['status']=='Approved'){ echo '<a href="javascript:void(0);" onclick="changStatus();">Change status</a> </p>'; } ?>
      <p>- Total: <b><?php echo pjUtil::formatCurrencySign(number_format($transaction['totalPrice'], 2), $tpl['option_arr']['o_currency']);?></b></p>
      <p>- Datetime: <?php echo $transaction['createdTime'];?></p>
      <p>- Order Number: <?php echo $transaction['numberOrder'];?></p>
      <?php if(isset($transaction['tent'])):  ?>
          <p>- Customer Number: <?php echo $transaction['tent'];?></p>
      <?php endif; ?>
      <p>- Transaction Id: <?php echo $transaction['transactionId'];?></p>
      <p>- Terminal Id: <?php echo $transaction['deviceId'];?></p>
    </div>
</fieldset>

<?php
$extra = json_decode(json_decode($transaction['extra'], true),true);
if(count($extra)>0){ ?>
  <fieldset class="fieldset white">
    <legend>Extra</legend>
    <div style="line-height: 20px;">
      <?php foreach ($extra as $key=>$value) {
        if (is_array($value)) {
          echo "<b>- $key:</b><br>";
          foreach ($value as $k => $v) {
            echo "<p>+ $k: $v</p>";
          }
        } else {
          echo "<p>- $key: $value</p>";
        }
      }
      ?>
    </div>
  </fieldset>
<?php } ?>

<table class="pj-table" width="100%">
  <thead>
    <tr style="background: gainsboro; font-weight: bold;">
      <td>Product/Option</td>
      <td>Qty x Price</td>
      <td>Total</td>
    </tr>
  </thead>
  <tbody>
  <?php
  $json = $transaction['data'];
  $products = json_decode(json_decode($json, true), true);
  foreach ($products as $key=>$value){
    $check=false;
    if($value['set_different_sizes']==='T'){
      foreach($value['price_arr'] as $k=>$v){
        if($v['QTY']>0){
          $check=true;
        }
      }
    }else if($value['QTY']>0){
      $check=true;
    }

    if($check==false){
      continue;
    }
  ?>
  <tr>
    <td>
      <div style="font-weight: bold; padding: 10px 5px;">
        <?php echo $value['name'];?>
        <?php if($value['set_different_sizes']==='T') { ?>
          <?php foreach ($value['price_arr'] as $k=>$v){ ?>
            <?php if($v['CHECKED']) { echo ' ('.$v['price_name'].')'; } ?>
          <?php } ?>
        <?php } ?>
      </div>
      <div style="display: flex;">
        <div><img src="<?php echo $value['image'];?>" style="width: 120px;"></div>
        <div style="padding: 0px 10px;">
          <!--Group-->
          <?php foreach ($value['group_arr'] as $k=>$v) {
              echo '<p>- '.$v['group_name'].': '.$v['group_item_arr'][$v['SELECTED']]['group_item_name'].'</p>';
          } ?>

          <!--Modifier-->
          <?php foreach ($value['modifier_arr'] as $k=>$v){
            $check=false;
            foreach ($v['modifier_item_arr'] as $kk=>$vv){
              if($vv['CHECKED']){
                $check=true;
              }
            }
            if($check){
              echo '<p>- '.$v['modifier_name'].':</p>';
              foreach ($v['modifier_item_arr'] as $kk=>$vv){
                if($vv['CHECKED']){
                  echo '<p style="margin-left: 5px; font-style: italic;">+ '.$vv['modifier_item_name'].' ('.pjUtil::formatCurrencySign(number_format($vv['price'], 2), $tpl['option_arr']['o_currency']).')</p>';
                }
              }
            }
          } ?>

          <!--Extra-->
          <?php foreach ($value['extra_arr'] as $k=>$v){
            if($v['QTY']>0){
              echo '<p>- '.$v['name'].' ('.pjUtil::formatCurrencySign(number_format($v['price'], 2), $tpl['option_arr']['o_currency']).' x '.$v['QTY'].')</p>';
            }
          } ?>

            <!--Combo-->
            <?php foreach ($value['combo_arr'] as $k => $v) {
                $check = false;
                foreach ($v['lst_products'] as $kk => $vv) {
                    if ($vv['CHECKED']) {
                        $check = true;
                    }
                }
                if ($check) {
                    echo '<p>- ' . $v['name'] . ':</p>';
                    foreach ($v['lst_products'] as $kk => $vv) {
                        if ($vv['CHECKED']) {
                            echo '<p style="margin-left: 5px; font-style: italic;">+ ' . $vv['name'] . '</p>';
                        }
                    }
                }
            } ?>

        </div>
      </div>
    </td>
    <td>
      <?php
      if($value['set_different_sizes']==='T'){
        foreach($value['price_arr'] as $k=>$v){
          if($v['QTY']>0){
            echo '<p>'.$v['QTY'].' x '.pjUtil::formatCurrencySign(number_format($v['price'], 2), $tpl['option_arr']['o_currency']).' ('.$v['price_name'].')</p>';
          }
        }
      }else{
        echo '<p>'.$value['QTY'].' x '.pjUtil::formatCurrencySign(number_format($value['price'], 2), $tpl['option_arr']['o_currency']).'</p>';
      }
      ?>
    </td>
    <td><?php echo pjUtil::formatCurrencySign(number_format($value['TOTAL'], 2), $tpl['option_arr']['o_currency']);?></td>
  </tr>
<?php
}
?>
  <tr>
    <td colspan="2" style="text-align: right;">Sub total</td>
    <td><?php echo pjUtil::formatCurrencySign(number_format($transaction['subTotal'], 2), $tpl['option_arr']['o_currency']);?></td>
  </tr>
  <tr>
    <td colspan="2" style="text-align: right;">Discount</td>
    <td><?php echo pjUtil::formatCurrencySign(number_format($transaction['discount'], 2), $tpl['option_arr']['o_currency']);?></td>
  </tr>
  <tr>
    <td colspan="2" style="text-align: right;">Tax</td>
    <td><?php echo pjUtil::formatCurrencySign(number_format($transaction['tax'], 2), $tpl['option_arr']['o_currency']);?></td>
  </tr>
  <tr>
    <td colspan="2" style="text-align: right;">Tip</td>
    <td><?php echo pjUtil::formatCurrencySign(number_format($transaction['tip'], 2), $tpl['option_arr']['o_currency']);?></td>
  </tr>
  <tr>
    <td colspan="2" style="text-align: right;"><b>Total</b></td>
    <td><b><?php echo pjUtil::formatCurrencySign(number_format($transaction['totalPrice'], 2), $tpl['option_arr']['o_currency']);?></b></td>
  </tr>
  <tr>
    <td colspan="3">
      <p>Phone: <?php echo $transaction['phone']; ?></p>
      <p>Notes: <?php echo $transaction['note']; ?></p>
    </td>
  </tr>
  </tbody>
</table>
<br>

<div align="center">
  <a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjKiosk&amp;action=pjActionOrder" class="pj-button">Back</a>
  <?php if($transaction['status']=='Approved'){ ?>
    <a href="<?php echo PJ_INSTALL_URL ?>receipt-<?php echo $transaction['id'] ?>.html" target="_blank" style="margin-bottom: 3px;" class="pj-button">E-Receipt online</a>
    <div style="display: inline-grid;">
    <?php foreach ($tpl['printers'] as $key=>$value){ ?>
      <a onclick="printerTo('<?php echo $value['id']; ?>','<?php echo $_GET['id']; ?>');" style="margin-bottom: 3px;" class="pj-button">Printer with SDP <?php echo'('.$value['pre_name'].'/'.$value['location'].')'; ?></a>
    <?php } ?>
    </div>
  <?php } ?>
</div>

<script>
  function printerTo(printer_id, order_id){
    if (confirm("Do you want to print this order?") == true) {
      $.ajax({
        type: 'GET',
        async: true,
        url: "index.php?controller=pjKiosk&action=pjAjaxOrderPrintAddQueue",
        data: {
          printer_id: printer_id,
          order_id: order_id
        },
        beforeSend: function(){
          $("body").append("<div class='loading'></div>");
        },
        success: function(data){
          $(".loading").remove();
          if(data==""){
            data='error';
          }
          alert('Status: '+data);
        },
        error: function (data){
          $(".loading").remove();
          alert('Status: error');
        }
      });
    }
  }
</script>


<style>
  /* Absolute Center CSS Spinner */
  .loading {
    position: fixed;
    z-index: 9999999999;
    height: 2em;
    width: 2em;
    overflow: visible;
    margin: auto;
    top: 0;
    left: 0;
    bottom: 0;
    right: 0;
  }

  /* Transparent Overlay */
  .loading:before {
    content: '';
    display: block;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0,0,0,0.3);
  }

  /* :not(:required) hides these rules from IE9 and below */
  .loading:not(:required) {
    /* hide "loading..." text */
    font: 0/0 a;
    color: transparent;
    text-shadow: none;
    background-color: transparent;
    border: 0;
  }

  .loading:not(:required):after {
    content: '';
    display: block;
    font-size: 10px;
    width: 1em;
    height: 1em;
    margin-top: -0.5em;
    -webkit-animation: spinner 1500ms infinite linear;
    -moz-animation: spinner 1500ms infinite linear;
    -ms-animation: spinner 1500ms infinite linear;
    -o-animation: spinner 1500ms infinite linear;
    animation: spinner 1500ms infinite linear;
    border-radius: 0.5em;
    -webkit-box-shadow: rgba(0, 0, 0, 0.75) 1.5em 0 0 0, rgba(0, 0, 0, 0.75) 1.1em 1.1em 0 0, rgba(0, 0, 0, 0.75) 0 1.5em 0 0, rgba(0, 0, 0, 0.75) -1.1em 1.1em 0 0, rgba(0, 0, 0, 0.5) -1.5em 0 0 0, rgba(0, 0, 0, 0.5) -1.1em -1.1em 0 0, rgba(0, 0, 0, 0.75) 0 -1.5em 0 0, rgba(0, 0, 0, 0.75) 1.1em -1.1em 0 0;
    box-shadow: rgba(0, 0, 0, 0.75) 1.5em 0 0 0, rgba(0, 0, 0, 0.75) 1.1em 1.1em 0 0, rgba(0, 0, 0, 0.75) 0 1.5em 0 0, rgba(0, 0, 0, 0.75) -1.1em 1.1em 0 0, rgba(0, 0, 0, 0.75) -1.5em 0 0 0, rgba(0, 0, 0, 0.75) -1.1em -1.1em 0 0, rgba(0, 0, 0, 0.75) 0 -1.5em 0 0, rgba(0, 0, 0, 0.75) 1.1em -1.1em 0 0;
  }

  /* Animation */

  @-webkit-keyframes spinner {
    0% {
      -webkit-transform: rotate(0deg);
      -moz-transform: rotate(0deg);
      -ms-transform: rotate(0deg);
      -o-transform: rotate(0deg);
      transform: rotate(0deg);
    }
    100% {
      -webkit-transform: rotate(360deg);
      -moz-transform: rotate(360deg);
      -ms-transform: rotate(360deg);
      -o-transform: rotate(360deg);
      transform: rotate(360deg);
    }
  }
  @-moz-keyframes spinner {
    0% {
      -webkit-transform: rotate(0deg);
      -moz-transform: rotate(0deg);
      -ms-transform: rotate(0deg);
      -o-transform: rotate(0deg);
      transform: rotate(0deg);
    }
    100% {
      -webkit-transform: rotate(360deg);
      -moz-transform: rotate(360deg);
      -ms-transform: rotate(360deg);
      -o-transform: rotate(360deg);
      transform: rotate(360deg);
    }
  }
  @-o-keyframes spinner {
    0% {
      -webkit-transform: rotate(0deg);
      -moz-transform: rotate(0deg);
      -ms-transform: rotate(0deg);
      -o-transform: rotate(0deg);
      transform: rotate(0deg);
    }
    100% {
      -webkit-transform: rotate(360deg);
      -moz-transform: rotate(360deg);
      -ms-transform: rotate(360deg);
      -o-transform: rotate(360deg);
      transform: rotate(360deg);
    }
  }
  @keyframes spinner {
    0% {
      -webkit-transform: rotate(0deg);
      -moz-transform: rotate(0deg);
      -ms-transform: rotate(0deg);
      -o-transform: rotate(0deg);
      transform: rotate(0deg);
    }
    100% {
      -webkit-transform: rotate(360deg);
      -moz-transform: rotate(360deg);
      -ms-transform: rotate(360deg);
      -o-transform: rotate(360deg);
      transform: rotate(360deg);
    }
  }
</style>


