const cleanupId = (id) => {
	if (id.includes('--')) {
		return id.split('--')[0]
	}

	return id
}

export const handleOutofStock = (el) => {
	const form = el.closest('[data-product_variations]')

	if (!form || form.dataset.product_variations === 'false') {
		return
	}

	const outOfStockLabel =
		wc_add_to_cart_variation_params?.i18n_out_of_stock || ''

	const selects = Array.from(form.querySelectorAll('select'))

	const selectedAttributes = selects
		.filter((s) => s.value && s.closest('.ct-variation-swatches'))
		.reduce((acc, s) => {
			acc[`attribute_${cleanupId(s.getAttribute('id'))}`] = s.value

			return acc
		}, {})

	const filteredVariations = JSON.parse(form.dataset.product_variations)
		.filter((variation) =>
			Object.keys(selectedAttributes).every(
				(key) =>
					variation.attributes[key] === selectedAttributes[key] ||
					variation.attributes[key] === ''
			)
		)
		.filter((variation) => {
			return variation.is_in_stock
		})

	const availableAttributes = filteredVariations.reduce((acc, variation) => {
		Object.keys(variation.attributes).forEach((key) => {
			if (!acc[key]) {
				acc[key] = []
			}

			if (!acc[key].includes(variation.attributes[key])) {
				acc[key].push(variation.attributes[key])
			}
		})

		return acc
	}, {})

	selects
		.filter((s) => !s.value)
		.forEach((s) => {
			if (!s.closest('.ct-variation-swatches')) {
				return
			}

			s.closest('.ct-variation-swatches')
				.querySelectorAll('[data-value]')
				.forEach((singleSwatchEl) => {
					const attributeTerms =
						availableAttributes[
							`attribute_${cleanupId(s.getAttribute('id'))}`
						] || []

					if (
						attributeTerms.includes('') ||
						attributeTerms.includes(singleSwatchEl.dataset.value) ||
						singleSwatchEl.classList.contains('disabled')
					) {
						singleSwatchEl.classList.remove('ct-out-of-stock')

						const maybeTooltip =
							singleSwatchEl.querySelector('.ct-tooltip')

						if (
							maybeTooltip &&
							!maybeTooltip.querySelector('.ct-media-container')
						) {
							maybeTooltip.textContent =
								maybeTooltip.textContent.replace(
									` - ${outOfStockLabel}`,
									''
								)
						}
					} else {
						singleSwatchEl.classList.add('ct-out-of-stock')

						const maybeTooltip =
							singleSwatchEl.querySelector('.ct-tooltip')

						if (
							maybeTooltip &&
							!maybeTooltip.textContent.includes(outOfStockLabel)
						) {
							maybeTooltip.textContent = `${maybeTooltip.textContent} - ${outOfStockLabel}`
						}
					}
				})
		})
}

export const computeSwatch = (el) => {
	;[...el.querySelectorAll('.ct-variation-swatches')].map((swatchesEl) => {
		const select = swatchesEl.querySelector('select')

		if (!select) {
			return
		}

		const maybeActive = swatchesEl.querySelector('.active')

		if (maybeActive) {
			maybeActive.classList.remove('active')

			const labelContainer = document.querySelector(
				`[for="${select.getAttribute('id')}"]`
			)
			if (labelContainer) {
				labelContainer.textContent =
					labelContainer.textContent.split(':')?.[0].trim() ||
					labelContainer.textContent
			}
		}

		const selectValue = JSON.stringify(String(select.value))

		if (
			selectValue &&
			swatchesEl.querySelector(`[data-value=${selectValue}]`)
		) {
			const label = select.querySelector(
				`[value=${selectValue}]`
			).textContent
			const labelContainer = document.querySelector(
				`[for="${select.getAttribute('id')}"]`
			)
			if (labelContainer) {
				labelContainer.textContent = `${
					labelContainer.textContent.split(':')?.[0].trim() ||
					labelContainer.textContent
				}: ${label}`
			}

			swatchesEl
				.querySelector(`[data-value=${selectValue}]`)
				.classList.add('active')
		}

		;[...swatchesEl.querySelectorAll('[data-value]')].map(
			(singleSwatchEl) => {
				singleSwatchEl.classList.remove('active', 'disabled')

				const swatchValue = JSON.stringify(
					String(singleSwatchEl.dataset.value)
				)

				if (swatchValue === selectValue) {
					singleSwatchEl.classList.add('active')
				}

				if (
					!select.querySelector(`[value=${swatchValue}]`) ||
					select
						.querySelector(`[value=${swatchValue}]`)
						.hasAttribute('disabled')
				) {
					singleSwatchEl.classList.add('disabled')
				}
			}
		)

		handleOutofStock(el)
	})
}
